/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* dyadset APL2 V1.0.0 *************************************************
* Called from dyadicp and scalax to determine if dyadic scalar         *
* processing is possible, given the data types of the arguments left   *
* and rite.  Dyadset returns the entry point to the dyadic scalar      *
* procedure that handles the specified scalar operation.  As a side    *
* dyadset sets *poutype to the required output data type.              *
***********************************************************************/
#define INCLUDES APLCB+FUNSTRUC
#include "includes.h"
SCALAR_PROC dyadset(pfun, pleft, prite, poutype)
void *pfun;           /* Describes the scalar dyadic. */
Aplcb *pleft,*prite; /* Operands. */
int *poutype;        /* Set by dyadset to required output data type. */
{
	Dyadcom;
     extern int aplerr;
     SCALAR_PROC oper=NULL;
	int intype,ltype,rtype;
     Scalar_dyadics *fun;

     ltype = (*pleft)->aplflags & APLMASK;
     rtype = (*prite)->aplflags & APLMASK;
     oper = dyadcom(pfun, &intype, poutype, ltype, rtype);
     if (aplerr == 0)
     	if (!(intype & APLCHAR))
			if (!matchok(pleft,prite,intype)) return(NULL);
     return(oper);
}
