/* Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved. */
/* dublin APL2 V1.0.0 ***************************************************
* Called by cplxin.                                                     *
* Given: Ptr a to string with a numeric constant; b to double, c and d  *
* to int, and e to end-of-string pointed to by a, converts constant to  *
* *b or *c, depending if it is integer or real, setting d to 0 or 1     *
* accordingly. Returns offset (rel 1) of last char of constant, or 0.   *
************************************************************************/
#define INCLUDES APLCHDEF+STRING
#include "includes.h"
int dublin(a,b,c,d,e)
char *a,*e;  double *b;  int *c,*d;
{
	Charcode; Dublins;
	extern char *aplchar[]; /* global APL character array */
	char *s,*t;
	double div,mul,val;
	int exp,expsign,i,sign,sw;

     sw = dublins(a,e,&s,&sign,&val,&div);
     if (sw == 0) return(0);
     t = s;
	exp = 0; /* default exponent */
	expsign = 1; /* default exp. sign */
	if (s < e && *s == *(aplchar[APL_E])) {
		s++;
		if ( s < e && *s==*(aplchar[PLUS]) || *s==*(aplchar[OVERBAR]))
			expsign = (*s++ == *(aplchar[PLUS])) ? 1 : -1;
		while (s < e
			&& *s >= *(aplchar[APL_0]) && *s <= *(aplchar[APL_9])) {
			exp = 10 * exp + (*s++ - *(aplchar[APL_0]));
			sw=3; /* exponent found */
		}
	}
	if (sw != 3) { /* no exponent found */
		s = t; /* restore s */
		exp = 0; /* default exponent */
		expsign = 1; /* def. exp. sign */
	}
	if (sw > 1) {
		*d=1; /* indicate real found */
		mul = 1.0;
          if (expsign == 1)
			while (0 < exp--)
				if (div > 1.0) div /= 10.0;
				else mul *= 10.0;
               while (0 < exp--)
               	if (mul > 1.0) mul /= 10.0;
                    else div *= 10.0;
		*b = sign * mul/div*val;
	} else {
		*d = 0; /* indicate integer */
		*c = val * sign;
	}
	while(s < e
		&& *s == *(aplchar[SPACE])
		|| *s == '\n' 
		|| *s == '\t') s++; /* skip trailing white space */
	return(s-a);
}
