/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* circulaw APL2 V1.0.0 ************************************************
* Called by circulax.                                                  *
* Circle functions for complex numbers, trigonometric functions        *
* TAN, COS, SIN.                                                       *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void circulaw(left,rrr,ret)
double *left,*rrr,*ret;
{
	Circulaw; Dividex; Expx; Minusx; Plusx; Timesx;
	extern int aplerr;
	int ileft;
	double wa[2],wb[2],wc[2],wd[2],x,y;
	static double
		iii[2]={0.0,1.0},
		one[2]={1.0,0.0},
		two[2]={2.0,0.0},
		twoiii[2]={0.0,2.0};

	switch (ileft = (int) *left) {
		case  SIN: /* sin r = (s_1%s#*iXr)%2Xi */
			timesx(iii,rrr,wb);		/* wb = iXr */
			expx(wb,wa);			/* wa = *iXr */
			dividex(one,wa,wb);		/* wb = 1%*iXr */
			minusx(wa,wb,wc);		/* wc = s_1%s#*iXr */
			dividex(wc,twoiii,ret);	/*ret = (s_1%s#*iXr)%2Xi */
			break;
		case  COS:/* cos r = (s+1%s#*iXr)%2 */
			timesx(iii,rrr,wb);		/* wb = iXr */
			expx(wb,wa);			/* wa = *iXr */
			dividex(one,wa,wb);		/* wb = 1%*iXr */
			plusx(wa,wb,wc);		/* wc = s+1%s#*iXr */
			dividex(wc,two,ret);	/*ret = (s+1%s#*iXr)%2 */
			break;
		case  TAN:/* tan r = (sin r)%cos r */
			x = SIN; circulaw(&x,rrr,wa);	/* wa = sin r */
			x = COS; circulaw(&x,rrr,wb);	/* wb = cos r */
			dividex(wa,wb,ret);			/*ret = (sin r)%cos r */
			break;
		default: aplerr = 85; return; /* left invalid */
	} /* end switch */
}
