/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* circulas APL2 V1.0.0 ************************************************
* Called by circulax.                                                  *
* Circle functions for complex numbers, non-trigonometric, with		 *
* negative key codes.										 *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void circulas(left,rrr,ret)
double *left,*rrr,*ret;
{
	Circulat; Conjugx; Expx; Plusx; Powerx; Timesx;
	extern int aplerr;
	int ileft;
	double ixr[2],wa[2],wb[2],x,y;
	static double
		eight[2]={8.0,0.0},
		half[2]={0.5,0.0},
		iii[2]={0.0,1.0},
		negone[2]={-1.0,0.0};

	switch (ileft = (int) *left) {
		case -12:	/* * 0j1 X r */
          	IXR /* build ixr */
			expx(ixr,ret); /* exponential (*) */
			break;
		case -11:	/* 0j1 X r */
          	IXR /* build ixr */
			XFR(ret,ixr); /* Transfer iXr to ret. */
			break;
		case -10:	/* +r */
			conjugx(rrr,ret);
			break;
		case -9:	/* r */
			ASGX(ret, *rrr, *(rrr+1));
			break;
		case -8: /* _8Or */
			circulat(eight,rrr,ret);
			PREFIX_MINUS(ret);
			break;
		case -4:	/* (-1+r*2)*.5 for x>=0 or for -1<x and x<0 and y=0 */
					/* _(-1+r*2)*.5 otherwise */
			timesx(rrr,rrr,wa);		/* r*2 */
			plusx(negone,wa,wb); /* -1+r*2 */
			powerx(wb,half,ret);	/* (-1+r*2)*.5 */
			GETXY
			if (!((x >=  0.0) || (-1.0 < x && x <0.0 && y == 1.0)))
				PREFIX_MINUS(ret); /* _(-1+r*2)*.5 */
			break;
		default: aplerr = 85; return; /* left invalid */
	} /* end switch */
}
