/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* catlamcm APL2 V1.0.0 ************************************************
* Called by both cat and laminate to move data to out.                 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb catlamcm(left,rite,out,axis,axicnt,botcnt,topcnt,leftcnt,ritecnt)
Aplcb left,rite,out;
int axis,axicnt,botcnt,topcnt,leftcnt,ritecnt;
{
	Dtacopy; Errstop;
	union apluptr lp,op,rp;
	int datatyp,i,lincr,rincr;

	datatyp = left->aplflags & (APLMASK + APLAPL);
	lincr=left->aplcount>1;
	rincr=rite->aplcount>1;
	lp.aplint=left->aplptr.aplint;
	rp.aplint=rite->aplptr.aplint;
	op.aplint=out->aplptr.aplint;
	for (i=topcnt; i>0; i--) {
		op.aplint=dtacopy(op.aplint,lp.aplint,leftcnt,lincr,datatyp);
		lp.aplchar+=leftcnt*lincr*left->aplsize;
		op.aplint=dtacopy(op.aplint,rp.aplint,ritecnt,rincr,datatyp);
		rp.aplchar+=ritecnt*rincr*rite->aplsize;
	}
	return(errstop(0,left,rite,out));
}
