/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplwksp APL2 V1.0.0 *************************************************
* Called by funcsusq to process commands beginning with a right        *
* parenthesis. Returns 1 if processing is to continue, 0 to terminate. *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF
#include "includes.h"
int aplwksp(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to char immediately after right parenthesis */
char *cpend; /* Pointer to end of command text */
{
	Aplcpy; Apldrop; Aplerase; Aplgroup; Aplgrp; Aplgrps; Apllib;
	Aplmsg; Aplread; Aplrun; Aplsave; Aplsi; Aplwrite; Aplwsid;
	Aplwksq; Aplwksr; Endoper; Errstop; Execmsg;
#include "aplwkcd.h"
#include "aplwkcm.h"
	extern int aplerr;
	int code,i,*ip,ret=1;

	for (i = 0; aplerr == 0; i++)
		if ((NULL == (ip = table[i])) || aplwksq(ip,&cp,cpend))
			break;
	if (aplerr == 0)
		switch (++i) {
			case CLEAR:	/* these codes must be deferred */
			case LOAD:
			case OFF:
						ret = 0; /* terminate loop in caller */
						rite = aplwksr(rite,cp,cpend,i);	break;
			case COPY:	aplcpy(rite,cp,cpend,0);			break;
			case DROP:	apldrop(rite,cp,cpend);			break;
			case ERASE:	aplerase(rite,cp,cpend);			break;
			case FNS:		aplgrps(rite,cp,cpend,3);		break;
			case GROUP:	aplgroup(rite,cp,cpend);			break;
			case GRP:		aplgrp(rite,cp,cpend);			break;
			case GRPS:	aplgrps(rite,cp,cpend,1);		break;
			case LIB:		apllib(rite,cp,cpend);			break;
			case PCOPY:	aplcpy(rite,cp,cpend,1);			break;
			case READ:	aplread(rite,cp,cpend);			break;
			case RUN:		aplrun(rite,cp,cpend);			break;
			case SAVE:	aplsave(rite,cp,cpend);			break;
			case SI:		aplsi(rite,cp,cpend,0);			break;
			case SINL:	aplsi(rite,cp,cpend,1);			break;
			case VARS:	aplgrps(rite,cp,cpend,2);		break;
			case WRITE:	aplwrite(rite,cp,cpend);			break;
			case WSID:	aplwsid(rite,cp,cpend);			break;
			default:		aplerr = 99; /* unknown command */	break;
		} /* end switch */
	if (aplerr)
		execmsg(rite->aplptr.aplchar, rite->aplcount, 0, aplmsg(aplerr));
	if (rite != NULL)
		endoper(rite);
	return(ret);
}
