/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplsave APL2 V1.0.0 *************************************************
* Called from aplwksp to do )SAVE.                                     *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+IO+STAT+STRING+STDIO
#include "includes.h"
void aplsave(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to char immediately after right parenthesis */
char *cpend; /* Pointer to end of command text */
{
	Aplparfn; Aplsavf; Execmsg;
	extern int aplerr;
	extern char *aplfile;
#if ! APL_DOS
        extern int errno;
#endif
	struct stat buf;
	char *newfile,*s;
	int fp=-1,i=0;

	newfile = aplparfn(cp,cpend);
	if (newfile == NULL)
		if (aplfile == NULL) i = 108; /* save where? */
		else newfile = aplfile; /* default file to )SAVE to. */
	if (newfile != NULL)
		if (stat(newfile,&buf)) { /* file doesn't exist */
			fp = creat(newfile, S_IREAD | S_IWRITE); /* create file */
			i = 101; /* Potential error number - can't create file. */
		}
		else { /* file exists */
			if (aplfile == NULL || 0 != APL_STRCMP(aplfile,newfile))
				i = 107; /* Can't save to existing file. */
			else {
				fp = open(newfile, 1); /* open for write access */
				i = 102; /* Pot. error number - can't open file. */
			}
		}
	errno = 0;
	if (fp != -1) {
		i = aplsavf(fp); /* go write to file */
		fp = close(fp); /* close file */
		if (fp == -1 && i == 0) i = 104; /* unable to close */
		if (i) fp = -1; /* indicate error */
	}
	if (fp == -1) {
		aplerr = i; /* File can't be created, opened, or written to. */
		execmsg(newfile,strlen(newfile),0,NULL);
		if (newfile != aplfile) free (newfile);
		return;
	}
	if (aplfile != NULL && aplfile != newfile) free(aplfile);
	aplfile = newfile;
	execmsg(aplfile,strlen(aplfile),0,"saved.");
}
