/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplquote APL2 V1.0.0 ************************************************
* Called from aplparsf when the current character is a quote to parse  *
* a quoted string.                                                     *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN
#include "includes.h"
void aplquote(cur,sp,spend)
Apltoken cur;
char *sp[]; /* pointer to pointer to string being parsed */
char *spend; /* pointer to after end of string being parsed */
{
	Getcb;
	extern int aplerr;
	extern char *aplchar[];
	char *q=aplchar[QUOTE],*s,*t,*u,*v;
	int datacnt,i,j,rank;
	
	s = t = sp[0]; /* point after starting quote */
	for (i=1 , datacnt=0 ; i ; datacnt += i) {
		if (t == spend) {
			cur-> token_code = MESSAGE_TOKEN;
			cur-> token_ptr.token_string = "unbalanced quotes";
			return;
		}
		if (*t++ == *q)
			if (t == spend) i = 0; /* all done */
			else { /* is it APL quote? */
				i = (*t == *q); /* i = 0 if ending quote */
				t += i; /* bump t if two contiguous quotes */
			}
	}
	sp[0] = t; /* update text pointer */
	rank = (datacnt == 1) ? 0 : 1;
	cur-> token_ptr.token_vector = 
		getcb(NULL,datacnt,APLCHAR+APLTEMP,rank,NULL);
	if (aplerr) {
		cur-> token_code = MESSAGE_TOKEN;
		cur-> token_ptr.token_string = "out of memory";
		return;
	}
	v = (cur-> token_ptr.token_vector)-> aplptr.aplchar;
	while (datacnt--) { /* copy quoted string */
		s += (*s == *q); /* bump if APL quote. */
		*v++ = *s++; /* copy character */
	}
}
