/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* aplquae APL2 V1.0.0 *************************************************
* Called from aplquad and execqncs to see if sp points to q-type name, *
* e.g. Lio.  If not, 0 returned.  Otherwise QUAD_code returned, and sp *
* w/b set to point beyond name.	                                       *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN
#include "includes.h"
#define DC(name,cha,chb) static int name[]={cha,chb,999}
int aplquae(sp,spend)
char *sp[]; /* pointer to pointer to string being parsed */
char *spend; /* pointer to after end of string being parsed */
{
	Aplscan; Aplwksq;
	char *s,*t,*u; int code,first,i,j;
	DC(ai,APL_A,APL_I); DC(av,APL_A,APL_V); DC(cr,APL_C,APL_R);
	DC(ct,APL_C,APL_T); DC(dl,APL_D,APL_L); DC(ea,APL_E,APL_A);
	DC(ex,APL_E,APL_X); DC(fc,APL_F,APL_C); DC(fx,APL_F,APL_X);
	DC(ht,APL_H,APL_T); DC(io,APL_I,APL_O); DC(lc,APL_L,APL_C);
	DC(lx,APL_L,APL_X); DC(nc,APL_N,APL_C); DC(nl,APL_N,APL_L);
	DC(pp,APL_P,APL_P); DC(pw,APL_P,APL_W); DC(rl,APL_R,APL_L); 
	DC(tc,APL_T,APL_C); DC(ts,APL_T,APL_S); DC(tt,APL_T,APL_T);
	DC(tz,APL_T,APL_Z); DC(ul,APL_U,APL_L); DC(wa,APL_W,APL_A);

	t = 2 + (s = sp[0]); /* point after starting quad */
	if (t > spend) return(0); /* can't be e.g. Lio or Lav */
	i = 0;
	if (aplwksq(ai,&s,t))		i = QUAD_AI;
	else if (aplwksq(av,&s,t))	i = QUAD_AV;
	else if (aplwksq(cr,&s,t))	i = QUAD_CR;
	else if (aplwksq(ct,&s,t))	i = QUAD_CT;
	else if (aplwksq(dl,&s,t))	i = QUAD_DL;
	else if (aplwksq(ea,&s,t))	i = QUAD_EA;
	else if (aplwksq(ex,&s,t))	i = QUAD_EX;
	else if (aplwksq(fc,&s,t))	i = QUAD_FC;
	else if (aplwksq(fx,&s,t))	i = QUAD_FX;
	else if (aplwksq(ht,&s,t))	i = QUAD_HT;
	else if (aplwksq(io,&s,t))	i = QUAD_IO;
	else if (aplwksq(lc,&s,t))	i = QUAD_LC;
	else if (aplwksq(lx,&s,t))	i = QUAD_LX;
	else if (aplwksq(nc,&s,t))	i = QUAD_NC;
	else if (aplwksq(nl,&s,t))	i = QUAD_NL;
	else if (aplwksq(pp,&s,t))	i = QUAD_PP;
	else if (aplwksq(pw,&s,t))	i = QUAD_PW;
	else if (aplwksq(rl,&s,t))	i = QUAD_RL;
	else if (aplwksq(tc,&s,t))	i = QUAD_TC;
	else if (aplwksq(ts,&s,t))	i = QUAD_TS;
	else if (aplwksq(tt,&s,t))	i = QUAD_TT;
	else if (aplwksq(tz,&s,t))	i = QUAD_TZ;
	else if (aplwksq(ul,&s,t))	i = QUAD_UL;
	else if (aplwksq(wa,&s,t))	i = QUAD_WA;
	else return(0); /* not a quad name */
	u = s;
	j = aplscan(&u,spend); /* delimiting token code */
	if ((j >= ALPHAONE && j <= ALPHATWO) || (j >= APL_0 && j <= APL_9))
		return(0); /* not properly delimited */
	sp[0] = s; /* update text pointer */
	return(i);
}
