/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplclean APL2 V1.0.0 ************************************************
* Called by apl at termination to free all storage currently allocated.*
***********************************************************************/
#define INCLUDES APLCB+APLMEM+TREE
#include "includes.h"
void aplclean(void)
{
	Aplclsub; Execterm;
	extern char *aplfile; /* WSID */
	extern Treelist treehdr; /* variable tree stack */
	Treelist workhdr;

	if (aplfile != NULL) {
		free(aplfile); /* free WSID string */
		aplfile = NULL;
	}
	if (treehdr == NULL) return; /* nothing to free */
	while (NULL != (workhdr = (Treelist) treehdr)) {
		while (NULL != treehdr->avlexec)
			execterm(); /* Go free execstk element. */
		treehdr = workhdr->treenext; /* pop tree stack */
		aplclsub(workhdr->avlhdr); /* pass top of tree */
		free(workhdr); /* free tree stack element */
	}
}
void aplclsub(node)
Avlnode node; /* points to node of binary tree */
{
	Leafdel;

	if (node == NULL) return;
	aplclsub(node->left_child); /* free left branch, if any */
	aplclsub(node->rite_child); /* free right branch, if any */
	leafdel(node->avlleaf); /* free this leaf, if any */
	free(node->avlname); /* free name string */
	free(node); /* free this node */
}
