/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* allcopy APL2 V1.0.0 *************************************************
* Copies any of the supported APL data types, converting as needed if  *
* both are numeric of some kind.  Else returns NULL.				 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void *allcopy(to,from,count,incr,itype,otype)
void *to,*from;
int count,incr,itype,otype;
{	Dabsx; Dtacopy; double *dp,dwrk[2]; char *op; int *ip;

	if (itype == otype) return(dtacopy(to,from,count,incr,itype));
	op = to;
	switch (itype) { /* input type */
		case APLCPLX:
			dp = from;
			while(count--) {
				dabsx(dp,dwrk); /* convert to real */
				switch (otype) { /* output type */
					case APLINT: *((int *)op)++ = *dwrk;
						break;
					case APLNUMB: *((double *)op)++ = *dwrk;
						break;
				}
				dp += incr;
			}
			break;
		case APLNUMB:
			dp = from;
			while(count--) {
				switch (otype) {
					case APLCPLX: *((double *)op)++ = *dp;
						*((double *)op)++ = 0e0;
						break;
					case APLINT: *((int *)op)++ = *dp;
						break;
				}
				dp += incr;
			}
			break;
		case APLINT:
			ip = from;
			while(count--) {
				switch (otype) {
					case APLCPLX: *((double *)op)++ = *ip;
						*((double *)op)++ = 0e0;
						break;
					case APLNUMB: *((double *)op)++ = *ip;
						break;
				}
				ip += incr;
			}
			break;
		default: return(NULL); /* no conversion possible */
	} /* end switch */
	return(NULL); /* bad */
}
