/*Copyright (C) 1997 by Thomas Glen Smith.  All Rights Reserved.*/
/* acosx APL2 V1.0.0 ***************************************************
* Arc-cosine for complex numbers.								 *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void acosx(rrr,ret)
double *rrr,*ret;
{
	Logx; Minusx; Powerx; Timesx;
	double ixr[2],wa[2],wb[2],wc[2];
	static double
		half[2]={0.5,0.0},
		iii[2]={0.0,1.0},
		one[2]={1.0,0.0};

	timesx(rrr,rrr,wa);		/* wa = r*2 */
	minusx(one,wa,wb);		/* wb = 1_r*2 */
	powerx(wb,half,wa);		/* wa = (1_r*2)*.5 */
	timesx(iii,wa,wb);		/* wb = iX(1_r*2)*.5 */
	minusx(rrr,wb,wa);		/* wa = r_iX(1_r*2)*.5 */
	logx(wa,wb);			/* wb = @r_iX(1_r*2)*.5 */
	timesx(iii,wb,ret);		/*ret = iX@r_iX(1_r*2)*.5 */
	PREFIX_MINUS(ret);		/*ret = _iX@r_iX(1_r*2)*.5 */
}

