/* Copyright (C) 1993, 1998 by Thomas Glen Smith.  All Rights Reserved. */
/* includes.h APL2 V1.0.1 **********************************************
* Generates the specified includes.                                    *
***********************************************************************/
#if !defined(INCLUDES_INCL)
#define INCLUDES_INCL
#define APLCB          1
#define APLCHDEF       2
#define STDIO          4
#define APLDEBUG       8
#define APLDERIV      16
#define APLEXT        32
#define APLFUNCI      64
#define APLMEM       128
#define APLTOKCD     256
#define APLTOKEN     512
#define FUNCODES    1024
#define FUNSTRUC    2048
#define TREE        4096
#define STRING      8192
#define APLED      16384
#define INDEXMI    32768
#define APLDOS     65536
#define CONIO     131072
#define MATH      262144
#define TRIGKEYS  524288
#define LIMITS   1048576
#define STAT     2097152
#define IO       4194304
#define FORM     8388608
#define ERRNO   16777216
#define APLMAIN 33554432
#define QEL     67108864
#include "aplenv.h"
#include "entrys.h"
#if INCLUDES & APLDEBUG
     #include "apldebug.h"
     #endif
#if INCLUDES & APLMEM
     #include "aplmem.h"
     #endif
#if INCLUDES & CONIO
     #if APL_DOS
     #include <conio.h>
     #endif
     #endif
#include <stdlib.h>
#if INCLUDES & ERRNO
     #include <errno.h>
     #endif
#if INCLUDES & IO
     #if APL_DOS
          #include <io.h>
     #elif defined(HPUX)
          #include <sys/io.h>
     #else
          #include <asm/io.h>
     #endif
     #endif
#if INCLUDES & STDIO
     #include <stdio.h>
     #endif
#if INCLUDES & (APLDOS || APLMAIN)
     #include APL_DOS_H
	#if INCLUDES & APLMAIN
	size_t aplstack; /* used to check stack */
	#endif
     #endif
#if INCLUDES & STRING
     #include <string.h>
     #if APL_DOS
#define APL_STRCMP strcmpl
     #else
#define APL_STRCMP strcmp
     #endif
     #endif
#if INCLUDES & MATH
     #include <math.h>
     #if defined(HPUX)
         #define PI 3.14159265358979323846
     #endif
     #endif
#if INCLUDES & LIMITS
     #include <limits.h>
     #endif
#if INCLUDES & STAT
     #if APL_DOS
          #include <sys\stat.h>
     #else
          #include <sys/stat.h>
     #endif
     #endif
#if INCLUDES & APLCB
     #include "aplcb.h"
     #endif
#if INCLUDES & APLCHDEF
     #include "aplchdef.h"
     #endif
#if INCLUDES & APLCOM
     #include "aplcom.h"
     #endif
#if INCLUDES & (FUNSTRUC + APLDERIV)
     #if !defined(APLCB_INCL)
          #include "aplcb.h"
          #endif
     #if !defined(APLTOKEN_INCL)
          #include "apltoken.h"
          #endif
     #include "funstruc.h"
     #endif
#if INCLUDES & APLDERIV
     #include "aplderiv.h"
     #endif
#if INCLUDES & (APLEXT | APLMAIN)
     #include "aplext.h"
     #endif
#if INCLUDES & APLFUNCI
     #include "aplfunc.h"
     #endif
#if INCLUDES & APLTOKCD
     #include "apltokcd.h"
     #endif
#if INCLUDES & APLTOKEN
     #include "apltoken.h"
     #endif
#if INCLUDES & FUNCODES
     #include "funcodes.h"
     #endif
#if INCLUDES & TREE
     #if !defined(APLTOKEN_INCL)
          #include "apltoken.h"
          #endif
     #if !defined(APLFUNC_INCL)
          #include "aplfunc.h"
          #endif
     #include "tree.h"
     #endif
#if INCLUDES & APLED
     #include "apled.h"
     #endif
#if INCLUDES & INDEXMI
     #include "indexmi.h"
     #endif
#if INCLUDES & TRIGKEYS
     #include "trigkeys.h"
     #endif
#if INCLUDES & FORM
     #include "formincl.h"
     #endif
#if INCLUDES & QEL
     #include "qel.h"
     #endif
#endif
