/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* decodei.h APL2 V1.0.0 ***********************************************
* Included in decodeb and decodec to do the decode.                    *
***********************************************************************/
#include "aplcb.h"
struct aplcb *EP(left,rite,out,laxis,dataout,ldata,rdata,
	laxicnt,lbotcnt,ltopcnt,lincr,
	raxicnt,rbotcnt,rtopcnt,rincr)
struct aplcb *left,*rite,*out;
int laxis,
	laxicnt,lbotcnt,ltopcnt,lincr,
	raxicnt,rbotcnt,rtopcnt,rincr;
TYPE *dataout,*ldata,*rdata;
{
	struct aplcb *errstop();
	int axicnt,i,j,k,m,n,p,r;
	TYPE *ip,*jp,*kp,*mp,*np,radix,wrk;

	axicnt = raxicnt;
	for (i=0; i<ltopcnt; i++) {
		ip = ldata + i*axicnt*lincr;
		for (j=0; j<lbotcnt; j++) {
			jp = ip + j;
			for (k=0; k<rtopcnt; k++) {
				kp = rdata + k*axicnt*rincr;
				for (m=0; m<rbotcnt; m++) {
					mp = kp + m + axicnt*rincr;
					np = jp + axicnt*lincr;
					radix = ONE; /* one is int or double 1 */
					wrk = ZERO; /* zero is int or double 0 */
					for (n=0; n<axicnt; n++) {
						wrk += radix * *(mp-=rincr);
						radix *= *(np-=lincr);
					}
					*dataout++ = wrk;
				}
			}
		}
	}
	return(errstop(0,left,rite,out));
}
