/* aplcb.h Copyright 1993 by Thomas Glen Smith */
/* APL2 V1.0.0 */
/* if stdio.h also included, aplcb.h should come after */
#if !defined(APLCB_INCL)
#define APLCB_INCL
#define APLFUNC_IN_USE 2048 /* function definition already in use */
#define APLINDX 1024 /* variable is used for indexing */
#define APLGROUP 512
#define APLFUNC 256
#define APLLABEL 128
#define APLCPLX 64
#define APLAPL 32
#define APLCBTM 16 /* reserved */
#define APLMASK 78 /* APLCHAR + APLINT + APLNUMB + APLCPLX */
#define APLCHAR 8
#define APLINT  4
#define APLNUMB 2
#define APLTEMP 1
#define ERR 0
#define MAXMSG 100 /* max error msg len */
#define NOTOK 0
#define OK 1
#define APL_REAL (APLINT + APLNUMB)
#define APL_NUMERIC (APL_REAL + APLCPLX)
typedef union apluptr Apluptr;
union apluptr {
     double *apldata; /* data ptr */
     int    *aplint;
     char   *aplchar;
     struct aplcb **aplapl;
     void   *aplvoid;
};
typedef struct aplcb *Aplcb;
struct aplcb {
     Apluptr aplptr;
     int aplflags;
          /*   1 = temporary variable        */
          /*   2 = double float variable     */
          /*   4 = integer variable          */
          /*   8 = character variable        */
          /*  16 = temporary aplcb           */
          /*  32 = aplcb pointer variable    */
          /*  64 = Not presently used        */
          /* 128 = APL label in function     */
          /* 256 = APL function definition   */
          /* 512 = Group name                */
          /*1024 = Index variable            */
          /*2048 = function def. in use      */
     int aplcount; /* # els. in var. */
     int aplrank; /* 0=scalar 1=vector 2=matrix, etc. */
     int *apldim; /* dimension pointer. This points to the first byte */
                  /* beyond field APLSIZE.  The memory for the APLCB  */
                  /* and the array pointed to by APLDIM are obtained  */
                  /* in a single unit.                                */
     int aplsize; /* size of data item in characters */
};
#endif
