;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Bitmap FX Unit 1.0 / 286 for real mode.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;

                .286p
                .model medium, pascal
                jumps

include         support.inc

                .code

;
;   flipx()     bitmap flip horizontally
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   pass:       dest - buffer of bitmap to flip
;               bufw - buffer width
;               bufd - buffer depth
;   returns:    nothing
;

                public flipx

flipx           proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, di, si
                cld

                lds si,b2ptr
                mov di,si
                add di,bufw
                sub di,2

                mov dx,bufd
align 2
flipxl1:
                push di si

                mov cx,bufw
                shr cx,1
                shr cx,1
                pushf
align 2
flipxl2:
                mov ax,word ptr [si]
                ror ax,8
                xchg ax,word ptr [di]
                ror ax,8
                mov word ptr [si],ax            ; switch first & last bytes
                add si,2
                sub di,2

                ; loop for remaining cols
                dec cx
                jnz flipxl2

                popf

                adc cx,cx
                jcxz flipxl3
                dec si
                inc di

                mov al,byte ptr [si]
                xchg al,byte ptr [di]
                mov byte ptr [si],al            ; switch first & last bytes
flipxl3:

                ; loop for remaining rows
                pop si di
                add si,bufw
                add di,bufw
                dec dx
                jnz flipxl1

                ret
flipx           endp


;
;   flipy()     bitmap flip vertically
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   pass:       dest - buffer of bitmap to flip
;               bufw - buffer width
;               bufd - buffer depth
;   returns:    nothing
;

                public flipy

flipy           proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, di, si
                cld

                lds si,b2ptr
                mov di,si
                mov ax,bufw
                mov cx,bufd
                dec cx
                mul cx
                add di,ax

                mov dx,bufd
                shr dx,1
align 2
flipyl1:
                push di si

                mov cx,bufw
                shr cx,1
                pushf
align 2
flipyl2:
                mov ax,word ptr [si]
                xchg ax,word ptr [di]
                mov word ptr [si],ax            ; switch first & last bytes
                add si,2
                add di,2

                ; loop for remaining cols
                dec cx
                jnz flipyl2

                popf
                adc cx,cx
                jcxz flipyl3
                dec si
                dec di

                mov al,byte ptr [si]
                xchg al,byte ptr [di]
                mov byte ptr [si],al            ; switch first & last bytes
flipyl3:

                ; loop for remaining rows
                pop si di
                add si,bufw
                sub di,bufw
                dec dx
                jnz flipyl1

                ret
flipy           endp


;
;   rotate()    bitmap rotate
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   pass:       dest - buffer of bitmap to flip
;               bufw - buffer width
;               bufd - buffer depth
;   returns:    nothing
;

ang256          dw 0
tcos            dw 0
tsin            dw 0
ycos            dw 0
ysin            dw 0
xlim            dw 0
ylim            dw 0
x2              dw 0
y2              dw 0
pclr            db 0

                public rotate

rotate          proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, di, si
                cld

                mov ax,cs:[ang256]
                inc ax
                cmp ax,256
                jl notangof
                sub ax,256
notangof:
                mov cs:[ang256],ax

                les di,b2ptr
                mov ax,bufw
                mov cx,bufd
                mul cx
                mov cx,ax
                shr cx,1
                mov ax,0
           rep  stosw

                mov ax,bufw
                shr ax,1
                mov cs:[xlim],ax                ; x limit

                mov ax,bufd
                shr ax,1
                mov cs:[ylim],ax                ; y limit

                mov bx,255
                sub bx,cs:[ang256]
                shl bx,1
                add bx,offset costab
                mov bx,cs:[bx]
                mov cs:[tcos],bx                ; tcos = sine[(255 - ang256)
                                                ;   + 64];

                mov bx,255
                sub bx,cs:[ang256]
                shl bx,1
                add bx,offset sintab
                mov bx,cs:[bx]
                mov cs:[tsin],bx                ; tsin = sine[255 - ang256];

                mov bx,cs:[ylim]
                neg bx                          ; for(y = -100; y < 100; y++)
align 2
rotatel1:
                push di si

                mov ax,cs:[tcos]
                mul bx
                sar ax,8
                mov cs:[ycos],ax                ; ycos = (y * tcos) / 256;

                mov ax,cs:[tsin]
                mul bx
                sar ax,8
                mov cs:[ysin],ax                ; ysin = (y * tsin) / 256;

                mov cx,cs:[xlim]
                neg cx                          ; for(x = -160; x < 160; x++)
align 2
rotatel2:
                mov ax,cs:[tcos]
                mul cx
                sar ax,8
                sub ax,cs:[ysin]
                mov cs:[x2],ax                  ; x2 = ((x * tcos) / 256)
                                                ;   - ysin;

                mov ax,cs:[tsin]
                mul cx
                sar ax,8
                add ax,cs:[ycos]
                mov cs:[y2],ax                  ; y2 = ((x * tsin) / 256)
                                                ;   + ycos;

                mov dx,cs:[xlim]
                mov ax,cs:[x2]
                cmp ax,dx
                jge rotatel3
                neg dx
                cmp ax,dx
                jle rotatel3                    ; if(x2 > -124 && x2 < 124)

                mov dx,cs:[ylim]
                mov ax,cs:[y2]
                cmp ax,dx
                jge rotatel3
                neg dx
                cmp ax,dx
                jle rotatel3                    ; if(y2 > -30 && y2 < 30)

                lds si,b1ptr
                mov ax,cs:[y2]
                add ax,cs:[ylim]
                mov dx,bufw
                mul dx
                add ax,cs:[x2]
                add ax,cs:[xlim]
                add si,ax
                mov dl,byte ptr [si]
                mov cs:[pclr],dl                ; clr = bmpbuf[(x2+124) +
                                                ;   (y2+30)*248];

                les di,b2ptr
                mov ax,bx
                add ax,cs:[ylim]
                mov dx,bufw
                mul dx
                add ax,cx
                add ax,cs:[xlim]
                add di,ax
                mov al,[pclr]
                mov byte ptr es:[di],al

                ;    putpixel(centx + x, centy + y, clr);

align 2
rotatel3:
                ; loop for remaining cols
                inc cx
                cmp cx,cs:[xlim]
                jl rotatel2

                ; loop for remaining rows
                pop si di
                add si,bufw
                add di,bufw
                inc bx
                cmp bx,cs:[ylim]
                jl rotatel1

                ret
rotate          endp


;
;
;   DATA (STORED IN CODE SEGMENT)
;
;

sintab          dw 0,6,13,19,25,31,38,44,50,56
                dw 62,69,75,81,87,92,98,104,110,116
                dw 121,127,132,137,143,148,153,158,163,168
                dw 172,177,182,186,190,194,198,202,206,210
                dw 213,217,220,223,226,229,232,235,237,239
                dw 241,243,245,247,249,250,251,252,253,254
                dw 255,255,256,256

costab          dw 256,256,256,255,255,254
                dw 253,252,251,249,248,246,244,242,240,238
                dw 236,233,231,228,225,222,218,215,212,208
                dw 204,200,196,192,188,184,179,175,170,165
                dw 160,156,150,145,140,135,129,124,118,113
                dw 107,101,95,90,84,78,72,65,59,53
                dw 47,41,35,28,22,16,9,3,0 ,-4 ,-10
                dw -16 ,-23 ,-29 ,-35 ,-41 ,-48 ,-54 ,-60 ,-66 ,-72
                dw -78 ,-84 ,-90 ,-96 ,-102 ,-107 ,-113 ,-119 ,-124 ,-130
                dw -135 ,-141 ,-146 ,-151 ,-156 ,-161 ,-166 ,-171 ,-175 ,-180
                dw -184 ,-189 ,-193 ,-197 ,-201 ,-205 ,-209 ,-212 ,-216 ,-219
                dw -222 ,-225 ,-228 ,-231 ,-234 ,-236 ,-239 ,-241 ,-243 ,-245
                dw -247 ,-248 ,-250 ,-251 ,-252 ,-253 ,-254 ,-255 ,-256 ,-256
                dw -256 ,-256 ,-256 ,-256 ,-256 ,-255 ,-255 ,-254 ,-253 ,-252
                dw -251 ,-249 ,-248 ,-246 ,-244 ,-242 ,-240 ,-237 ,-235 ,-232
                dw -230 ,-227 ,-224 ,-221 ,-217 ,-214 ,-210 ,-207 ,-203 ,-199
                dw -195 ,-191 ,-186 ,-182 ,-178 ,-173 ,-168 ,-163 ,-159 ,-154
                dw -148 ,-143 ,-138 ,-133 ,-127 ,-122 ,-116 ,-110 ,-105 ,-99
                dw -93 ,-87 ,-81 ,-75 ,-69 ,-63 ,-57 ,-51 ,-44 ,-38
                dw -32 ,-26 ,-19 ,-13 ,-7
                dw  0,6,13,19,25,31,38,44,50,56
                dw  62,69,75,81,87,92,98,104,110,116
                dw  121,127,132,137,143,148,153,158,163,168
                dw  172,177,182,186,190,194,198,202,206,210
                dw  213,217,220,223,226,229,232,235,237,239
                dw  241,243,245,247,249,250,251,252,253,254
                dw  255,255,256,256

                end

