;---------------------------------------------------------------------
; XORPROG - XOR program encryption, 148 bytes! - Tylisha C. Andersen
;---------------------------------------------------------------------
; Syntax:  XORPROG file.com

.model tiny
.code
.186
org 100h

;---------------------------------------------------------------------

main:   mov   cl, ds:[80h]      ; cx = command-line length (including
        xor   ch, ch            ; the carriage return at the end)
        inc   cx                ;
        mov   di, 81h           ; find the first non-space character
        mov   al, 20h           ;
        repe  scasb             ;
        lea   dx, [di-1]        ; dx = ptr to filename
        repne scasb             ; find next space
        mov   byte ptr [di-1], 0; set to zero
                                ;
        mov   ax, 3D02h         ; open the file
        int   21h               ;
        jc    error             ; jump if error
        xchg  bx, ax            ; bx = file handle
        mov   ah, 3Fh           ; read maximum of 60K bytes from the
        mov   cx, 0F000h        ; file into the buffer
        mov   dx, offset buffer ;
        int   21h               ; DOS call
        mov   cx, ax            ; cx, bp = num. of bytes read
        mov   bp, cx            ;
        not   ah                ; make sure some bits are set in the xor byte
        mov   [xorbyte],ah      ; set the xor byte in the decoder
                                ;
        mov   si, dx            ; si, di = buffer
        mov   di, dx            ;
m_1:    lodsb                   ; load byte
        xor   al, ah            ; xor with the xor byte
        stosb                   ; store byte
        loop  m_1               ; loop
                                ;
        mov   ax, 4200h         ; move back to the beginning of the file
        xor   dx, dx            ;
        int   21h               ;
        jc    error             ; jump if error
                                ;
        mov   ah, 40h           ; write encoded data back to file
        lea   cx, [bp+34]       ; cx = old length + 34 (decoder length)
        mov   dx, offset decoder;
        int   21h               ; DOS call
        jc    error             ; jump if error
                                ;
        mov   ah, 3Eh           ; close the file
quit:   int   21h               ; DOS call
        ret                     ; return
                                ;
error:  mov   ah, 9             ; output error string
        mov   dx, offset error$ ;
        jmp   quit              ; return

;---------------------------------------------------------------------

error$  db   'file access error', 13, 10, '$'
decoder db   060h, 0FAh, 0BEh, 00Fh, 001h, 0BFh, 000h, 0FEh
        db   057h, 0B9h, 013h, 000h, 0F3h, 0A4h, 0C3h, 0BEh
        db   022h, 001h, 0BFh, 000h, 001h, 0B9h, 000h, 0FDh
        db   0ACh, 034h
xorbyte db   000h, 0AAh, 0E2h, 0FAh, 061h, 0FBh, 0FFh, 0E6h

buffer:

end main
