/*
	MIDI.H

	Marc savary, 88-03-31

	Structures & defines for MIDI Supplement.

*/

#define MAX_MIDI_PITCH		0x3fff	/* max. pitch bend ... 2 ** 14 */

#define NR_MIDI_CHANNELS	16
#define ADLIB_CHANNEL		16

#define MPU_TICS	96				/* MPU-401 ticks par beat */

#define NR_SPLITS	N_ROLL_VOICES
#define NR_PLAGES	( 2* N_ROLL_VOICES)

#define MIDIVAR_FILL_SIZE	128
#define MIDI_VERSION		2

#define DEFAULT_MIDI_PRESET	255	/* preset # not defined */

#define LP_MEASURE	0
#define LP_BEAT	1
#define LP_TICK	2

struct plage_str {
	int	hautEntree;
	int deltaOrg;
	};

struct midi_vars {
	int		midiVersion_;
	int		recInChannel_[ N_ROLL_VOICES];
	int 	recOutChannel_[ N_ROLL_VOICES];
	int		playBackChannel_[ N_ROLL_VOICES];
	int 	hautSplits_[ NR_SPLITS];
	struct	plage_str plages_[ NR_PLAGES];
	int 	splitOfVoices_[ N_ROLL_VOICES];
	int 	busySplits_;
	int 	busyPlages_;
	char	loopLength_[ 3][ N_ROLL_VOICES];
	char	outProgChange_[ N_ROLL_VOICES];
	unsigned inQuantif_[ N_ROLL_VOICES];
	unsigned outQuantif_[ N_ROLL_VOICES];
	unsigned pitchRange_;
	float	minVelocity_;
	float	veloResolution_;
	char	inProgChange_[ N_ROLL_VOICES];
	int		syncIn_;
	char	midiFiller_[ MIDIVAR_FILL_SIZE];
	};

#define recInChannel	(midiVar.recInChannel_)
#define recOutChannel	(midiVar.recOutChannel_)
#define voiceToChannel	(midiVar.playBackChannel_)
#define hautSplits		(midiVar.hautSplits_)
#define plages			(midiVar.plages_)
#define splitOfVoices	(midiVar.splitOfVoices_)
#define busySplits		(midiVar.busySplits_)
#define busyPlages		(midiVar.busyPlages_)
#define loopLength		(midiVar.loopLength_)
#define quantif		(midiVar.inQuantif_)
#define outQuantif		(midiVar.outQuantif_)
#define outProgChange	(midiVar.outProgChange_)
#define inProgChange	(midiVar.inProgChange_)
#define pitchRange		(midiVar.pitchRange_)
#define minVelocity	(midiVar.minVelocity_)
#define veloResolution	(midiVar.veloResolution_)
#define midiVersion	(midiVar.midiVersion_)
#define syncIn			(midiVar.syncIn_)
#define midiFiller		(midiVar.midiFiller_)

extern struct midi_vars midiVar;


