/*
	16/06/87

	Sound-driver demonstration program.
*/


#define	fSDInit			0
#define	fSDRelTimeStart		2
#define	fSDSetState		3
#define	fSDGetState		4
#define	fSDFlush		5
#define	fSDSetMode		6
#define	fSDGetMode		7
#define	fSDSetRelVolume		8
#define	fSDSetTempo		9
#define	fSDSetTranspose		10
#define	fSDGetTranspose		11
#define	fSDSetActVoice		12
#define	fSDGetActVoice		13
#define	fSDPlayNoteDel		14
#define	fSDPlayNote		15
#define	fSDSetTimbre		16
#define	fSDSetPitch		17
#define	fSDSetTickBeat		18
#define	fSDNoteOn		19
#define	fSDNoteOff		20
#define	fSDTimbre		21



#define END		100			/* indicate the end of 'melodie' array */

int marimba3[] = {
 0x0001, 0x0005, 0x0005, 0x000d, 0x0001, 0x0000, 0x000a, 0x0005, 0x000e,
 0x0001, 0x0000, 0x0000, 0x0001, 0x0002, 0x0001, 0x0000, 0x000f, 0x0001,
 0x0000, 0x0009, 0x0003, 0x0000, 0x0001, 0x0000, 0x0000, 0x0001
};



char melodie[] = {
0, 1, 2,
2, 1, 2,
4, 3, 4,
7, 1, 4,
7, 1, 1,
4, 3, 4,
0, 1, 4,
4, 3, 2,
2, 1, 2,
0, 2, 1,

0,1,2,
4,1,2,
7,1,2,
12,3,2,
2,3,4,
5,1,4,
9,1,2,
12,3,2,
11,3,4,
9,1,4,
7,1,2,
5,1,1,
2,1,2,
4,1,1,
9,1,2,
7,3,2,
100, 100, 100
};


extern	char SoundCall();			/* interface to sound-driver */


main()
{
	int i;

	if( !GetSoundDrvVersion()) {		/* verify that sound-driver is installed */
		printf( "\n Sound-driver not installed!");
		exit( 1);
		}
	SoundCall( fSDInit);			/* reset sound-driver */
	SoundCall( fSDSetState, 0);		/* make shure that sound-driver is disabled */
	SoundCall( fSDSetMode, 0);		/* set to melodic mode */
	SoundCall( fSDSetTickBeat, 4);		/* 4 ticks by beats */
	SoundCall( fSDRelTimeStart, 0, 1);	/* start of music piece */
	SoundCall( fSDSetTempo, 100, 0, 1);	/* set tempo to 100 */
	SoundCall( fSDSetActVoice, 0);			/* use voice 0 */
	SoundCall( fSDSetTimbre, &marimba3[ 0], 0, 1);	/* set timbre voice */
/*
	Play all notes of 'melodie' array....
*/
	i = 0;
	while( 1) {
		if( END == melodie[ i])
			break;
		SoundCall( fSDPlayNote, (unsigned)melodie[ i], (unsigned)melodie[ i+1],
			(unsigned)melodie[ i+2]);
		i += 3;
		}
	SoundCall( fSDSetState, 1);			/* enable the sound-driver to play */
	while( SoundCall( fSDGetState))			/* wait until the last note */
		;
	printf( "\nDone!");
	exit( 0);
}

