10 REM		
20 REM			SOUND DRIVER BASIC INTERFACE EXAMPLE
30 REM
40 DEFINT A-Z
50 REM
60 FSDINIT         = 0
70 FSDRELTIMESTART = 2
80 FSDSETSTATE     = 3
90 FSDGETSTATE     = 4
100 FSDFLUSH        = 5
110 FSDSETMODE      = 6
120 FSDGETMODE      = 7
130 FSDSETRELVOLUME = 8
140 FSDSETTEMPO     = 9
150 FSDSETTRANPOSE  = 10
160 FSDGETTRANSPOSE = 11
170 FSDSETACTVOICE  = 12
180 FSDGETACTVOICE  = 13
190 FSDPLAYNOTEDEL  = 14
200 FSDPLAYNOTE     = 15
210 FSDSETTIMBRE    = 16
220 FSDSETPITCH     = 17
230 FSDSETTICKBEAT  = 18
240 FSDNOTEON       = 19
250 FSDNOTEOFF      = 20
260 FSDTIMBRE       = 21
270 REM
280 FIN = 100
290 S0 = 0: S1 = 0: S2 = 0: S3 = 0: S4 = 0: S5 = 0:	REM RESET ARGUMENTS
300 I = 0: MEM = 0: BYTE = 0
310 FUNCSIZE = 66:                                      REM CODE SIZE
320 DIM FUNC%( FUNCSIZE /2 +1):                         REM CODE ARRAY
330 DIM INSTRUM( 26):                                   REM TIMBRE DATA
340 REM 
350 REM			LOAD TIMBRE INTO ARRAY, FROM DATA
360 REM
370 MEM = VARPTR( INSTRUM(0))
380 FOR I = 1 TO 52: READ BYTE: POKE MEM, BYTE: MEM = MEM +1: NEXT I
390 REM
400 REM			LOAD CODE (SOUNDBAS.ASM) INTO FUNC% ARRAY
410 REM
420 MEM = VARPTR( FUNC%(0))
430 FOR I = 1 TO FUNCSIZE
440 READ BYTE
450 POKE MEM, BYTE
460 MEM = MEM +1
470 NEXT I
480 REM
490 REM			SET UP SOUND DRIVER
500 REM
510 S0 = FSDINIT: GOSUB 730:				REM INITIALIZE SD
520 S0 = FSDRELTIMESTART: S1 = 0: S2 = 1: GOSUB 730:   REM START TIME
530 S0 = FSDSETTEMPO: S1=100: S2=0: S3=1:  GOSUB 730:	REM TEMPO = 100
540 S0 = FSDSETACTVOICE: S1 = 0:           GOSUB 730:	REM SET ACTIVE VOICE
550 S0 = FSDSETTIMBRE: MEM = VARPTR( FUNC(0)):		REM SET INSTRUMENT
560 CALL MEM( S0, INSTRUM(0), S2, S3, S4, S5)
570 GOSUB 630:					REM LOAD SONG INTO SD
580 S0 = FSDSETSTATE: S1 = 1: GOSUB 730: REM START PLAYING SONG
590 S0 = FSDGETSTATE: GOSUB 730:               REM TEST IF FINISH
600 IF S0 <> 0 GOTO 590
610 STOP
620 REM			PLAY SONGS
630 S0 = FSDPLAYNOTE
640 READ S1: READ S2: READ S3
650 IF S1 = FIN THEN RETURN
660 GOSUB 730
670 GOTO 630
680 REM
690 STOP
700 REM
710 REM			SOUND DRIVER CALL
720 REM
730 MEM = VARPTR( FUNC%(0))
740 CALL MEM( S0, S1, S2, S3, S4, S5)
750 RETURN
760 REM
770 REM intrument marimba3
780 DATA &H01, &H00, &H05, &H00, &H05, &H00, &H0D, &H00, &H01
790 DATA &H00, &H00, &H00, &H0A, &H00, &H05, &H00, &H0E, &H00, &H01, &H00
800 DATA &H00, &H00, &H00, &H00, &H01, &H00, &H02, &H00, &H01, &H00, &H00
810 DATA &H00, &H0F, &H00, &H01, &H00, &H00, &H00, &H09, &H00, &H03, &H00
820 DATA &H00, &H00, &H01, &H00, &H00, &H00, &H00, &H00, &H01, &H00
830 REM
840 REM MACHINE CODE (SOUNDBAS.ASM)
850 DATA &H06, &H56, &H57, &H8B, &HEC, &H8B, &H5E, &H14, &H8B, &H37, &H8B
860 DATA &H5E, &H0A, &HFF, &H37, &H8B, &H5E, &H0C, &HFF, &H37, &H8B, &H5E
870 DATA &H0E, &HFF, &H37, &H8B, &H5E, &H10, &HFF, &H37, &H83, &HFE, &H10
880 DATA &H75, &H07, &H1E, &HFF, &H76, &H12, &HEB, &H06, &H90, &H8B, &H5E
890 DATA &H12, &HFF, &H37, &H16, &H07, &H8B, &HDC, &HCD, &H65, &H8B, &HE5
900 DATA &H8B, &H5E, &H14, &H89, &H07, &H5F, &H5E, &H07, &HCA, &H0C, &H00
910 REM
920 REM		SONG #1
930 DATA 0, 1, 2
940 DATA 2, 1, 2
950 DATA 4, 3, 4
960 DATA 7, 1, 4
970 DATA 7, 1, 1
980 DATA 4, 3, 4
990 DATA 0, 1, 4
1000 DATA 4, 3, 2
1010 DATA 2, 1, 2
1020 DATA 0, 2, 1
1030 REM 
1040 REM 		SONG #2
1050 DATA 0,1,2,4,1,2,7,1,2,12,3,2,2,3,4,5,1,4,9,1,2,12,3,2
1060 DATA 11,3,4,9,1,4,7,1,2,5,1,1,2,1,2,4,1,1,9,1,2,7,3,2
1070 DATA 100, 100, 100
