;
;									    
;  32DE Debugger v0.01, Copyright (c) 1995 Sami Kantoluoto.              
;  All rights reserved.						    
;									    
;
		.386P
;۲۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_PMODE_TEXT	Segment Para Public Use16 'CODE'
		Assume	cs:_PMODE_TEXT,ds:_PMODE_TEXT
;
Extrn           UnAssemble:Near,Instruction_Off:DWord,Instruction_Len:Byte
Extrn		UBuf:Byte,SegSize:Byte
Extrn           code_sel:word,data_sel:word,zdata_sel:word,codebase:dword
Extrn           LineFeed:Byte,PrintHex:Near,EXCP_RegTable:Word,EXCP_MSG02:Byte
;
Public		DEBUG_01PM,DEBUG_03PM
;
		Align	4
DB1_EAX 	dd	0
DB1_ECX 	dd	0
DB1_EDX 	dd	0
DB1_EBX 	dd	0
DB1_ESP 	dd	0
DB1_EBP 	dd	0
DB1_ESI 	dd	0
DB1_EDI 	dd	0
DB1_EFLAGS	dd	0
DB1_EIP 	dd	0
DB1_CS		dw	0,0
DB1_SS		dw	0,0
DB1_DS		dw	0,0
DB1_ES		dw	0,0
DB1_FS		dw	0,0
DB1_GS		dw	0,0
StateBytes	equ	$-(offset DB1_EAX)
;
DB2_EAX 	dd	0
DB2_ECX 	dd	0
DB2_EDX 	dd	0
DB2_EBX 	dd	0
DB2_ESP 	dd	0
DB2_EBP 	dd	0
DB2_ESI 	dd	0
DB2_EDI 	dd	0
DB2_EFLAGS	dd	0
DB2_EIP 	dd	0
DB2_CS		dw	0,0
DB2_SS		dw	0,0
DB2_DS		dw	0,0
DB2_ES		dw	0,0
DB2_FS		dw	0,0
DB2_GS		dw	0,0
;
RedrawScreen    db      0FFh
ModeType        db      0
;
ExceptionStack	Struc
ES_RetEIP	dd	0
ES_RetCS	dw	0,0
ES_ErrorCode	dd	0
ES_EIP		dd	0
ES_CS		dw	0,0
ES_EFlags	dd	0
ES_ESP		dd	0
ES_SS		dw	0
ExceptionStack	EndS
;
DEBUG_01PM:	; Trap...
		pushad
		push	gs fs es ds

		mov	ds,cs:data_sel
                mov     es,zdata_sel

		pop	DB1_DS DB1_ES DB1_FS DB1_GS
		pop	DB1_EDI DB1_ESI DB1_EBP DB1_ESP DB1_EBX DB1_EDX
		pop	DB1_ECX DB1_EAX

		mov	eax,[esp].ES_EFlags
		mov	bx,[esp].ES_SS
		mov	ecx,[esp].ES_ESP
		mov	bp,[esp].ES_CS
		mov	edx,[esp].ES_EIP

		mov	DB1_EFLAGS,eax
		mov	DB1_SS,bx
		mov	DB1_ESP,ecx
		mov	DB1_CS,bp
		mov	DB1_EIP,edx

		jmp	Debugger
;
DEBUG_03PM:	jmp	$
;
Debugger:       smsw    ax
                and     al,1
                mov     ModeType,al
                mov     SegSize,16
                lar     eax,dword ptr DB1_CS
                test    eax,00400000h
                jz      D_Cont
                mov     SegSize,32

D_Cont:         and     RedrawScreen,not 1
                jp      D_ScreenOK
                mov     ax,03h
                int     10h
                or      RedrawScreen,0FFh
D_ScreenOK:     and     RedrawScreen,not 2
                jp      D_DisasmScr_OK

                mov     edi,0B8000h

D_DisasmScr_OK: mov     bp,8
                mov     esi,offset EXCP_RegTable
                mov     edi,offset DB1_EAX
D_ShowGRegs:    push    bp
                movzx   edx,word ptr [esi]
                mov     ah,09h
                int     21h
                mov     ebp,[edi]
                mov     cl,8
                call    PrintHex
                mov     edx,offset EXCP_MSG02
                mov     ah,09h
                int     21h
                lea     esi,[esi+2]
                lea     edi,[edi+4]
                pop     bp
                dec     bp
                jnz     D_ShowGRegs

                mov     edx,offset LineFeed
                mov     ah,09h
                int     21h

                mov     bp,DB1_CS
                mov     cl,4
                call    PrintHex
                mov     dl,':'
                mov     ah,02
                int     21h
                mov     ebp,DB1_EIP
                mov     cl,4
                cmp     SegSize,32
                jne     D_Cont2
                add     cl,cl
D_Cont2:        call    PrintHex
                mov     ah,2
                mov     dl,' '
                int     21h

                push    DB1_CS
		push	DB1_EIP
		push	DB1_EIP
		call	UnAssemble
		mov	byte ptr ds:[di],'$'
		mov	edx,offset UBuf
		mov	ah,09h
		int	21h

D_WaitESC:      xor     ah,ah
		int	16h
		cmp	al,27
                je      D_Exit
                cmp     al,32
                jne     D_WaitESC
                and     byte ptr DB1_EFLAGS+1,not 1
D_Exit:         mov     eax,DB1_EFLAGS
		mov	[esp].ES_EFlags,eax

                cld
                push    ds
                pop     es
                mov     esi,offset DB1_EAX
                mov     edi,offset DB2_EAX
                mov     ecx,StateBytes/4
                rep     movs dword ptr es:[edi],ds:[esi]

		mov	eax,DB1_EAX
		mov	edx,DB1_EDX
		mov	ecx,DB1_ECX
		mov	ebx,DB1_EBX
		mov	ebp,DB1_EBP
		mov	esi,DB1_ESI
		mov	edi,DB1_EDI
		mov	gs,DB1_GS
		mov	fs,DB1_FS
		mov	es,DB1_ES
		mov	ds,DB1_DS

		db	66h
		retf
;
PrintStr:       ; DS:EDX = Str... (ASCIIZ) ;)
                ; ES:EDI = Dest... .,m-a.s,dmf
                ;     AH = Color
                cld
PS_MainLoop:    mov     al,ds:[edx]
                or      al,al
                jz      PS_Exit
                inc     edx
                stos    word ptr es:[edi]
                jmp     PS_MainLoop
PS_Exit:        ret
;
_PMODE_TEXT	EndS
;۲۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲۲
		End
