/*==========================================================================*\
| WNDWC20.H - header file for WNDWC20                                        |
|                                                                            |
|    This header file contains external declarations for the variables in    |
| WC20VAR.C.  It also contains the macros, enums, and typedefs used by       |
| the WNDWC modules.  If you change this file, it will not affect the        |
| WNDWC modules in the library (.LIB) file, unless you recompile the         |
| source code.  See the documentation for information about registering      |
| for the source code.                                                       |
|                                                                            |
|   Copyright (C) 1989 by James H. LeMay,  All rights reserved.              |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research              |
\*==========================================================================*/

#if !defined(egainfo) && !defined(egarows)

#include "qwikc20.h"                      /* auto-include if not included */

#endif

/* If you leave this macro undefined, it will save data space and about 2.5k
   of code.  Comment out the line below, and recompile the source code,
   if you are using only video page 0.
*/
#define MULTIPAGE

/* If you are NOT using virtual windows, comment out the line below and
   recompile the source code.
*/
#define ADDVIRTUAL

#define NOSHADOW 0x0000
#define BOTHSHADOWS 0x000C   /* SHADOWLEFT+SHADOWRIGHT */
#define WRITETOMASK 0x7000   /* 01110000b - (To mask out writeto modes) */

/* Change these to suit your data needs. */
#define MAXWINDOW  5          /* 1-254 : windows per video page */
#define MAXVIRTUALWINDOW  2   /* 0-254 : total number of virtual windows-1 */
#define MAXPAGEUSED  1        /* 0-maxpage : top video page number,
                                 usually 0.  This can be greater than an
                                 expected maxpage.
                              */

/* Place all of your window names needed for random-access here: */
enum windownames {
    WINDOW0,                  /* Reserved for the non-window area. */
    WINDOW1,
    WINDOW2,
    WINDOW3,
    WINDOW4,
    WINDOW5,
    AWINDOW,                  /* A name for non-unique windows. */
    FREEWINDOW                /* Reserved for a freed virtual windows stat. */
};

enum borders {
    BLANK_BORDER,
    SINGLE_BORDER,
    DOUBLE_BORDER,
    HDOUBLE_BORDER,
    VDOUBLE_BORDER,
    SOLID_BORDER,
    EVEN_SOLID_BORDER,
    THIN_SOLID_BORDER_1,
    THIN_SOLID_BORDER_2,
    LHATCH_BORDER,
    MHATCH_BORDER,
    HHATCH_BORDER,
    USER_BORDER_1,
    USER_BORDER_2,
    NO_BORDER = 255
};

enum brdrparts {
    BRDR_TL,
    BRDR_TH,
    BRDR_TR,
    BRDR_LV,
    BRDR_RV,
    BRDR_BL,
    BRDR_BH,
    BRDR_BR,
    BRDR_LT,
    BRDR_HL,
    BRDR_RT,
    BRDR_TT,
    BRDR_VL,
    BRDR_BT,
    BRDR_CL
};

enum brdracronyms {
    TL, TH, TR, LV, RV, BL, BH, BR, LT, HL, RT, TT, VL, BT, CL

/*        The first letters of the border acronyms mean:
            T = top or tee  B = bottom
            V = vertical    H = horiz
            L = left        R = right
            P = partition   C = cross
          The second letter is the same except for:
            T = tee         L = line
          Here they are in their relative positions:
            TL  TH  TT  TH  TR
            LV      VL      RV
            LT  HL  CL  HL  RT
            LV      VL      RV
            BL  BH  BT  BH  BR
*/

};

typedef char brdr_t[ BRDR_CL + 2 ];

enum dir_t {
    NO_DIR, UP, DOWN, VERY_TOP, TOP, BOTTOM, VERY_BOTTOM, FAR_LEFT, LEFT,
    RIGHT, FAR_RIGHT, CENTER, HORIZONTAL, VERTICAL
};

typedef struct {
    unsigned char wsrow, wscol, wsrows,
                  wscols, wsrow2, wscol2;     /* window w/border */
    unsigned char wrow, wcol, wrows, wcols,
             wrow2, wcol2;                    /* window only */
    int wndwattr, brdrattr, origattr;         /* original window attribute */
    int wsbrdr, wsline;
    int wsname;                               /* see windownames enum */
    unsigned char wswherer, wswherec;         /* window-relative */
    int wsmodes;
    int wscursor;                             /* cursor mode for the window */
    unsigned char ulcol, ulcols, ulrows;      /* peculiar underlay location */
    int ulbytes;                              /* size in bytes for underlay */
    int far *ulptr;                           /* for underlay */
    vscr_t vscr;                              /* screen stats for qwik */
    unsigned char refrow, refcol;             /* viewed corner in virtual wndw
                                                 or original wsrow & wscol for
                                                 hidden window */
    int viewbrdr;                             /* border viewed on the CRT */
    int vi;                                   /* virtual level index */
} wndwstat_t;

typedef struct {
    int linewi;
    int lineli;
    int overlaplength;
} linearray_t;

typedef struct {                   /* Area of union between two windows */
    linearray_t rowline, colline;
} unioncoord_t;

#define ucrowwi rowline.linewi
#define ucrowli rowline.lineli
#define ucrows rowline.overlaplength
#define uccolwi colline.linewi
#define uccolli colline.lineli
#define uccols colline.overlaplength

typedef unioncoord_t ucrarray_t[ MAXWINDOW+1 ];

typedef wndwstat_t wndwstats_t[ MAXWINDOW+1 ];

/* Margins for limiting movement with movewindow or vresizewindow */
typedef struct {
    unsigned char left_margin, right_margin, top_margin, bottom_margin;
} margin_t;

#ifndef __WC20VAR__          /* don't process this code if in WC20VAR.C */

extern brdr_t brdr[ USER_BORDER_2 ];

#endif

/* valid modes for setwindowmodes() */
#define RELMODE 0x0001       /* bit 0 - Window relative; temporary stats */
#define PERMMODE 0x0002      /* bit 1 - Can't be moved or removed, no underlay
                              */
#define SHADOWLEFT 0x0004    /* bit 2 - Shadow on the left side */
#define SHADOWRIGHT 0x0008   /* bit 3 - Shadow on the right side */
#define ZOOMMODE 0x0010      /* bit 4 - Zoom effect on make and accesswindow */
#define HIDDENMODE 0x0020    /* bit 5 - Create window while hidden */
#define VIRTUALMODE 0x0040   /* bit 6 - Create Virtual window as well */
#define CURSOROFFMODE 0x0080 /* bit 7 - Leave cursor off at all times */
#define SEETHRUMODE 0x0100   /* bit 8 - Doesn't clear screen inside window */
#define NOHIDEMODE 0x0200    /* bit 9 - Ignores request to hide window */
#define NOACCESSMODE 0x0400  /* bit 10 - Ignores request to access window */
#define NOMOVEMODE 0x0800    /* bit 11 - Ignores request to move/resize window
                              */

/* Other modes for program detection: */
#define TOCRTMODE 0x1000       /* bit 12 - Writing to CRT */
#define TOHIDDENMODE 0x2000    /* bit 13 - Writing to Hidden window */
#define TOVIRTUALMODE 0x4000   /* bit 14 - Writing to Virtual window */


#ifndef __WC20VAR__           /* don't process this code if in WC20VAR.C */

#ifdef ADDVIRTUAL
extern unsigned char startproc;   /* Originating function executing
                                     viewuncovered */
extern int startmodes;            /* Original writeto mode */
#endif

extern int shadowcolor;
extern char shadowchar;
extern unsigned char titleofs;  /* # of cols title placed offset from
                                   border */

/* Flags corresponding to the above modes.  Automatically set for the
   window you are in.
*/
extern char relflag, permflag, zoomflag, hiddenflag, virtualflag;
extern char cursoroff_flag, seethruflag, nohideflag, noaccessflag, nomoveflag;
extern char tocrtflag, tohiddenflag, tovirtualflag;

extern wndwstats_t wndwstat;
extern wndwstat_t tws;           /* Window stats on the top Level Index */
#define topwndwstat tws          /* another name for it - more verbose */

#ifdef ADDVIRTUAL
extern wndwstat_t tvs;          /* Optional virtual stats for top window. */
#define topvirtualstat tvs      /* another name for it - more verbose */
#endif

extern int li;              /* Top level index */
extern int hli;             /* Hidden level index */
extern int wi;              /* Window index to save top stat (HLI or LI) */
extern unsigned char pli;   /* Permanent window level index */
extern int cursordefault;   /* Default cursor mode for each window */
extern int windowmodes;     /* Logical sum of all window modes listed above */
extern margin_t margins;    /* Limits for moving or resizing windows */

#endif


typedef struct {
    wndwstats_t pagews;        /* equivalent to wndwstat */
    wndwstat_t pagetws;        /* equivalent to topwndwstat */

#ifdef ADDVIRTUAL
    wndwstat_t pagetvs;        /* equivalent to topvirtualstat */
#endif

    int pageli;             /* equivalent to li */
    int pagehli;            /* equivalent to hli */
    int pagewi;             /* equivalent to wi */
    unsigned char pagepli;  /* equivalent to pli */
    int pagecursor;
    int pagemodes;          /* equivalent to windowmodes */
    margin_t pagemargins;   /* equivalent to margins */
} pagestat_t;


#ifndef __WC20VAR__          /* don't process this code if in WC20VAR.C */

#ifdef MULTIPAGE
extern pagestat_t far *pagestat;
#endif

#ifdef ADDVIRTUAL
extern wndwstat_t far *virtualstat;
extern unsigned char virtualrows;   /* Default rows for virtual screen. */
extern unsigned char virtualcols;   /* Default cols for virtual screen. */
extern unsigned int virtualsize;    /* virtualcols * (virtualrow+2) * 2 */
#endif

extern char maxvalidpage;  /* The lesser of maxpage or MAXPAGEUSED */
extern char zoomdelay;     /* Delay in ms between each qbox for zoom effect */
extern char prefer_multitask;   /* Flag set when multitasking compatibility
                                   is preferred
                                */

/* For compatibility with Pascal versions, callgoof is implemented as a macro
   which provides a simple call to showgoof.
*/
#define callgoof(errornum) showgoof(errornum)

/*  ----------   Prototypes from WNDWC20.C   -----------  */

int heapok( unsigned long numbytes );
void setrowsandcolsat( unsigned char row, unsigned char col );
int getflag( int mode, int modes );
void getflags( int modes );
void saveqeosofs(void);
void setqeosofs(void);
void saveqscr(void);
void setqscr(void);
void gettopwndwstatat( unsigned i );
void savetopwndwstatat( unsigned i );
void savetoppagestatat( unsigned i );
void gettoppagestatat( unsigned i );
void savevirtualstat(void);
void savecursordata(void);
void saveanywndwstat(void);
void getunderlayat( void far *theul );
void saveunderlayat( void far *theul );
void writetotop(void);
void check_zenith(void);
void checkmultitask(void);
void initpages( char clearscr );
void initwindow( int wattr, int clearscr, char cursorok );
void setcursordefault( int cursormode );
void setwindowmodes( int sumofmodes );
void qbox( unsigned char row, unsigned char col, unsigned char rows,
           unsigned char cols, char clearscr );
void zoomqbox(void);
void shadowfill( unsigned char vertcol, unsigned char horizcol );
void addshadow(void);
void adjustmodes( int *writetomode, int *modes );
void setulsize( int rows, int cols, int *tempulbytes );
void selfcenter( unsigned char *row, unsigned char *col,
                 unsigned char rows, unsigned char cols );
int getnextvi(void);
void makevirtualwindow( int *modes );
void makehiddenwindow( unsigned char row, unsigned char col,
                       unsigned char rows, unsigned char cols, int modes );
void makecrtwindow( unsigned char row, unsigned char col, unsigned char rows,
                    unsigned char cols, int modes, int writetomode );
void makewindow( unsigned char row, unsigned char col, unsigned char rows,
                 unsigned char cols, int wattr, int battr, int brdrsel,
                 int windowname );
unsigned char gettitlerow( int toporbottom );
void titlewindow( int toporbottom, int justify, int titleattr, char *title );
void locatecursor(void);
void restoretcwindow(void);
void restorestat( int writetomodes );
void removewindow(void);

/*  ----------   Prototypes from WC20COM.C   -----------  */

void getstatfor( int windowname, int mode );
void windunion( int lcornerwi, int lengthwi, int lcornerli, int lengthli,
                linearray_t *lineofchars );
void unionmap( wndwstat_t *wsli, char far *mapptr, unioncoord_t *ucr, int li,
               char update );
void modupperunderlays( int far *tempolptr, char far *mapptr,
                        unioncoord_t *ucrs, int update );

/*  ----------   Prototypes from WC20WIN.C   -----------  */

void wwrite( unsigned char row, unsigned char col, char *astr );
void wwritec( unsigned char row, char *astr );
void wwrite_sub( unsigned char row, unsigned char col, int length,
                 char far *astr );
void wgotorc( unsigned char row, unsigned char col );
void wgotoeos(void);
void weostorc( unsigned char row, unsigned char col );
unsigned char wwherer(void);
unsigned char wwherec(void);
unsigned char weosr(void);
unsigned char weosc(void);
void wbrdrh( unsigned char row );
void wbrdrv( unsigned char col );
void wbrdrpart( unsigned char row, unsigned char col, int part );
void wlineh( unsigned char row, unsigned char col, unsigned char cols );
void wlinev( unsigned char row, unsigned char col, unsigned char rows );
void wlinepart( unsigned char row, unsigned char col, int part );
void scroll( unsigned char toprow, int dir );
void wscrollup(void);
void wscrolldown(void);
void winsline(unsigned char row);
void wdelline(unsigned char row);
void clrfield( unsigned char cols, int attr );
void wclrfield( unsigned char row, unsigned char col, unsigned char cols,
                int attr );
void wclrline( unsigned char row );
void wclreol( unsigned char row, unsigned char col, int attr );
void wclreos( int attr );
void wclrfieldeos( unsigned char cols, int attr );
void wclrtitle( int toporbottom );
void wclrscr(void);

/*  ----------   Prototypes from WC20VIR.C   -----------  */

void setvirtualsize( unsigned char rows, unsigned char cols );
void writetovirtual( int windowname );
void vviewrc( unsigned char row, unsigned char col );
void vviewrcrel( int numofrows, int numofcols );
void updateview( int far *tempolptr, int far *tempviewptr, int doupdate,
                 char far *mapptr, int mapbytes  );
void vupdatecoveredwindow( char doupdate );
void restorewriteto( char func );
int viewuncovered( char proc );
void vupdateview(void);
void vupdatetitles(void);
void vupdatecursor(void);
void vupdaterows( unsigned char row, unsigned char rows );
void vupdateviewandtitles(void);
void vupdatewindow(void);
void vscrollview( int numofrows, int numofcols );
void vresizewindow( int numofrows, int numofcols );
void vzoomwindow(void);

/*  ----------   Prototypes from WC20MGR.C   -----------  */

void writetocrt(void);
void writetohidden( int windowname );
void writetopage( char pagenum );
void writeandviewpage( char pagenum );
void hidewindow(void);
void show( int sli );
void showwindow( int windowname );
void accountforshadow( int far *tempulptr, int far *tempolptr );
void movewindow( int numofrows, int numofcols );
int getlevelindex( int windowname );
void swapunderlaydata( int far *tempulptr, int far *tempolptr,
                       char far *mapptr, int mapbytes );
void accesswindow( int windowname );
void replaceline( int index, unsigned char lastindex, int part, int oldbrdr,
                  int *abrdr, int newbrdr );
void changerow( unsigned char row, int parth, int parttee, int oldbrdr,
                int *abrdr, int newbrdr );
void changecol( unsigned char col, int partt, int partv, int partb,
                int parttee, int oldbrdr, int *abrdr, int newbrdr );
void changeborder( int newbrdr );
void restoreborder(void);

/*  ----------   Prototypes from SCANBRDR.C   -----------  */

void scanbrdr( void far *start, int numtoscan, int charattr, int far *offset,
               int far *matchcount );

/*  ----------   Prototypes from SCANMAP.C   -----------  */

void scanmap( void far *mappoint, int numtoscan, char levelindex,
              int far *offset, int far *matchcount );

/*  ----------   Prototypes from SWAPI.C   -----------  */

void swapi( int far *array1, int far *array2, int count );

/*  ----------   Prototypes from MOVE16.C   -----------  */

void move16( void far *source, void far *dest, int numofbytes );

/*  ----------   Prototypes from MOVEWORD.C   -----------  */

void movewords( int far *source, int far *dest, int numofwords );

/*  ----------   Prototypes from FILL16.C   -----------  */

void fill16( void far *dest, int count, char achar );

/*  ----------   Prototypes from GOOF.C   -----------  */

void showgoof( char errornum );

#endif                   /* not processed if in WC20VAR */

