
/**************************************************************************
  EXAMPLE.C

  Written by:  Eric Jorgensen (Feb, 1995)

  This code was written using Turbo C.  It is intended to demonstrate the
  use of Varmint's Audio Tools and to provide a example code for program
  who wish to use VAT.

                          This code is FREEWARE

  You are free to distribute without any restrictions as long as you
  charge no fee.


**************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <alloc.h>
#include "sound.h"
#include <math.h>


#define getbit(x,y)  ((x>>y) & 0x01)
#define setbit(x,y) x = x & (0x01<<y)
#define togbit(x,y) x = x ^ (0x01<<y)

                                  // function prototypes
void fmdemo(void);
void mididemo(void);
void sb_intro(void);
void dspdemo(void);


char    inst[9][11] =
  {
    { 0x03,0x01,0x00,0x00,0xF3,0xE4,0x64,0x35,0x00,0x01,0x00},  // Harpsichord
    { 0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x06,0x03,0x00},  // intro voice
    { 0x02,0x06,0x94,0x0A,0x80,0x80,0x00,0x00,0x00,0x00,0x00},  // intro voice
    { 0x00,0x04,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00},
    { 0x01,0x01,0x40,0x40,0x80,0x80,0x00,0x00,0x01,0x00,0x00},
    { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01},
    { 0xA5,0xB1,0xD2,0x80,0x81,0xF1,0x03,0x05,0x00,0x00,0x02},
    { 0x72,0x62,0x1C,0x05,0x51,0x52,0x03,0x13,0x00,0x00,0x0E},
    { 0x11,0x01,0x8A,0x40,0xF1,0xF1,0x11,0xB3,0x00,0x00,0x06}};

int vints[8] = {1,2,1,2,1,2,1,2}; // voice defs for introduction
                                  // Start/end frequencies for intro
WORD startfreq[8] = {0xa000,0x6000,0xa000,0x2000,0x1000,0x9000,0xa000,0x6000};
WORD endfreq[8] =   {0x0800,0x2800,0x4800,0x6800,0x8800,0xa800,0xc800,0xe800};

char *regname[11] = {             // register name list
  "Amp mod/ vib/ eg type/ keyscale/ multiple 1",
  "Amp mod/ vib/ eg type/ keyscale/ multiple 2",
  "Key scale level / oper out level 1",
  "Key scale level / oper out level 2",
  "attack/decay rate 1",
  "attack/decay rate 2",
  "sustain level / release rate 1",
  "sustain level / release rate 2",
  "Feedback / Algorythm (oper 1&2)",
  "Wave Form  Select (oper 1)",
  "Wave Form  Select (oper 1)"
  };

char hexchar[16] = {"0123456789ABCDEF"};  //  hexidecimal character list
SAMPLE *sound1,*sound2,*aha;
unsigned long int l1=1,l2=1,laha=1;

/**************************************************************************
  void main()

  DESCRIPTION:   Handles the main menu and sets things up

**************************************************************************/
void main()
{
  int i= 0;
  char r = 0,twirl[6]  = "|/-\\";

  if(SB_Setup()) {
    Go_Varmint();                            // Install  Varmint's tools

    sound1 = loadwave("doink.wav",&l1);     // Load up our sound effects
    sound2 = loadwave("wooeep.wav",&l2);
    aha = loadwave("aha.wav",&laha);
    if(!sound1 || !sound2 || !aha) {
      printf("ERROR loading sounds:  (%d,%d)\n",sound1,sound2);
      exit(0);
    }

    sb_intro();                              // Get their attention

    while(kbhit()) getch();
    while(r != 'Q') {                       // Main input loop

      clrscr();                             // CLear screen and draw menu
      textcolor(DARKGRAY);
      //cprintf("far core left %lu",farcoreleft());
      textcolor(WHITE);
      gotoxy(20,8);
      cprintf("Demonstration:  Varmint's Audio Tools\n\n");
      textcolor(YELLOW);
      gotoxy(30,10);
      cprintf("1) FM voice");
      gotoxy(30,11);
      cprintf("2) MIDI");
      gotoxy(30,12);
      cprintf("3) Sounds");
      gotoxy(30,14);
      cprintf("Q) quit");

      while(!kbhit()) {                     // Draw a twirling thing while
                                            // we wait for a keypress.
        gotoxy(35,16);
        cprintf("%c",twirl[++i%4]);
        gotoxy(30,14);
        msdelay(50);
      }
      r = toupper(getch());                 // grab some input

      if(r == '1') fmdemo();                // Do something with it
      else if(r == '2') {
        mididemo();
      }
      else if(r == '3') {
        dspdemo();
      }
    }
    Dropdead_Varmint();                     // Release Varmint's interrupt
  }
  else {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
    printf("(Is your 'BLASTER' environmen variable set up correctly?)\n");
  }

}

/**************************************************************************
  void dspdemo(void)

  DESCRIPTION:  Plays sound effects with Varmint's Audio Tools

**************************************************************************/
void dspdemo(void)
{
  char r = 0;
  DWORD tot = 0,num = 0,vc;

  DSP_overhead = 1;                           // turn on overhead checking

  clrscr();                                   // Clear screen and draw a menu
  textcolor(GREEN);
  gotoxy(25,8);
  cprintf("Sound effects demo menu");
  textcolor(YELLOW);
  gotoxy(25,10);
  cprintf("1,2,3 - Play a sound effect");
  gotoxy(25,11);
  cprintf("Q     - Quit");

  gotoxy(1,1);
  printf("CPU OVERHEAD: \nSAMPLES IN QUEUE: ");
  while(toupper(r) != 'Q') {         // input loop
    while(!kbhit()) {                // Wait for keystroke
      vc = vclock;
      while(vc == vclock);           // wait for the interrupt

      tot+= DSP_overhead;            // take an average every 40 interrupts
      num++;
      if(num == 40) {
        gotoxy(15,1);
        printf("%2.2lf%%  ",((double)tot/num)/50.0); // Show overhead
        gotoxy(19,2);
        printf("%d  \n",sounds_in_queue);       // Show # sounds playing
        num = 0;
        tot = 0;
      }
    }
    r = getch();                      // Get keystroke and act accordingly
    if(r == '1') playsound(sound1,l1);
    else if(r == '2') playsound(sound2,l2);
    else if(r == '3') playsound(aha,laha);
  }
}

/**************************************************************************
  void sb_intro(void)

  DESCRIPTION:  Cool introduction sith sound blaster music and sounds

**************************************************************************/
void sb_intro(void)
{
  int i,j;
  double fr;
  WORD f;

  clrscr();
  gotoxy(1,1);
  printf("Varmint's Audio Tools  (Version: %s)",VAT_VERSION);
  msdelay(500);

                                      // Cool introduction
  FM_Reset();
  for(i = 0; i < 2; i++) {
    playsound(aha,laha);              // Digital intro speach
    msdelay(13);
  }
  for(i = 0; i < 8; i++) {             // initialize music voices
    FM_SetVoice(i,inst[vints[i]]);
    FM_SetFreq(i,startfreq[i]);
    FM_SetVol(i,0x00);
    FM_KeyOn(i);
  }
  for(i = 0; i < 1000; i+= 1) {       // morph a big chord
    fr = i/1000.0;
    for(j = 0; j < 8; j++) {
      gotoxy(j*10+1,10);
      f = startfreq[j]+((double)endfreq[j]-(double)startfreq[j]) * fr;
      cprintf("%X  ",f);
      FM_SetFreq(j,f);
      FM_SetVol(j,fr*0x3f );
      FM_KeyOn(j);
    }
    msdelay(5);
    if(kbhit()) i = 1000;
  }

  if(!kbhit()) {
    for(i = 0; i < 8; i++) {          // Make sure all the notes are right
      FM_SetFreq(i,endfreq[i]);
      FM_KeyOn(i);
    }

    for(i = 0x3f ; i >= 0; i-= 1) {   // quiet down slowly
      for(j = 0; j < 8; j++) {
        FM_SetVol(j,i);
      }
      msdelay(i*2+40);
      if(kbhit() & i) i = 1;
    }
  }

  for(i = 0; i < 9; i++) {            // Silence them all
    FM_SetVol(i,0);                   // volume off
    FM_SetVoice(i,inst[0]);           // this instrument has a decay, so it
                                      // gets all the way quiet
    FM_SetFreq(i,1);                  // Low freq = quiet
  }

}
/**************************************************************************
  void mididemo(void)

  DESCRIPTION: Example function that loads and "plays" a  midi file

**************************************************************************/
void mididemo(void)
{
  int i,err;
  char *errstring[256],r=0;
  static MIDI *bach  = NULL;

  clrscr();                                    // clear screen
  FM_Reset();

  for(i = 0 ; i < 9; i++) {
    FM_SetVol(i,0);
    FM_SetVoice ( i,inst[0]) ;                 // initialize voice
  }
  if(!bach) {
                                              // load a midi file
    err = ReadMidi("bach.mid",&bach,(char *)errstring);
    if(err) {
      printf("MIDI read ERROR: %s\n",errstring);
      printf("Exit?\n");
      r = getch();
      if(r != 'n') return;
    }
  }

  //printf("FORMAT:  %d  TRACKS: %d   DIVISION: %d\n",
  //        bach->format,bach->num_tracks,bach->divisions);

  midi_data = bach;
  midi_reset = TRUE;

  textcolor(MAGENTA);
  gotoxy(25,2);
  cprintf("MIDI demo menu");                 // Draw the menu
  textcolor(CYAN);
  gotoxy(25,4);
  cprintf("V,v - Change music volume");
  gotoxy(25,5);
  cprintf("T,t - Change music tempo");
  gotoxy(25,6);
  cprintf("B   - Begin music");
  gotoxy(25,7);
  cprintf("S   - Stop Music");
  gotoxy(25,8);
  cprintf("R   - Reset midi");
  gotoxy(25,9);
  cprintf("Q   - Quit");


  while(toupper(r) != 'Q') {
    gotoxy(30,11);                            // print temppo and volume stats
    textcolor(WHITE);
    cprintf("Music Volume: %d  ",music_volume);
    gotoxy(30,12);
    cprintf("Music Tempo:  %.2f  ",midi_usertempo);

    while(!kbhit()) {
      gotoxy(1,1);
      //printf("D: %d",debugnum);
    }
    r = getch();                              // get keystroke

    if(r == 'V') {
      music_volume++;
      if(music_volume > 0x3f) music_volume = 0x3f;
    }
    else if(r == 'v') {
      if(music_volume > 0) music_volume--;
    }
    else if(r == 'T') {
      midi_usertempo *= 1.02;
      if(midi_usertempo > 10.0) midi_usertempo = 10.0;
    }
    else if(r == 't') {
      midi_usertempo *= 0.98;
      if(midi_usertempo < 0.1) midi_usertempo = 0.1;
    }
    else if(toupper(r) == 'B') {
      midi_on = TRUE;
    }
    else if(toupper(r) == 'S') {
      midi_on = FALSE;
    }
    else if(toupper(r) == 'R') {
      midi_reset = TRUE;
    }
  }
}


/**************************************************************************
  void bitprint(char byte)

  DESCRIPTION:  Prints individual bits and then a HEX value

**************************************************************************/
void bitprint(unsigned char byte)
{
  int i;

  cprintf("  ");
                                    // go through bits
  for(i = 7; i >= 0; i--) {
    if(getbit(byte,i)) {            // 1's are yellow
      textcolor(YELLOW);
      cprintf("1");
    }
    else {                          // 0's are dark grey
      textcolor(DARKGRAY);
      cprintf("0");
    }
  }

  textcolor(LIGHTBLUE);             // print the hex value
  cprintf("  %c%c",hexchar[byte/16],hexchar[byte%16]);
  textcolor(WHITE);
}



/**************************************************************************
  void fmdemo()

  DESCRIPTION:  Allows th user to mess around with instruments and
                play a few notes.


**************************************************************************/
void fmdemo(void)
{
  unsigned int i,cx,cy,voice=0,instrument = 0;
  int drawvoice = 1,rythm = 0;
  char r = 0;

  clrscr();                          // clear screen
  printf("FM demonstration screen");
  FM_Reset();
  for(i = 0; i < 9; i++) FM_KeyOff(i);

  gotoxy(1,16);
  cprintf("IJKL = cursor movement\r\n");
  cprintf("<space> = toggle bit\r\n");
  cprintf("numbers = play notes\r\n");
  cprintf("v = change voice\r\n");
  cprintf("n = Change instrument\r\n");
  cprintf("r = toggle rythm mode\r\n");
  cprintf("q = quit");

  _setcursortype(_SOLIDCURSOR);
  for( i = 0; i < 8; i++) {          // initialize voices
    FM_SetVoice ( i,inst[instrument]) ;
    FM_SetVol(i,0);
  }

  cx = 54;cy = 5;                    // init cursor position

  for(i = 0; i < 11; i++) {          // print register names
    gotoxy(50-strlen(regname[i]),i+5);
    textcolor(MAGENTA);
    cprintf("%s",regname[i]);
  }


  while(r != 'Q') {                  // main input loop
    if(drawvoice) {
      for(i = 0; i < 11; i++) {      // display instrument data
        gotoxy(52,i+5);
        bitprint(inst[instrument][i]);
      }
      for(i = 0; i < 9; i++) {
        FM_SetVoice ( i,inst[instrument]) ; // initialize new voice
      }
      drawvoice = 0;
      textcolor(LIGHTGRAY);
      gotoxy(52,4);
      cprintf("Instrument #%d ",instrument);
    }

    gotoxy(cx,cy);                   // put cursor in right spot

    while(!kbhit()){
    }

    r = toupper(getch());
    if(r >= '0' && r <= '9') {
      FM_KeyOff(voice);
      FM_SetVoice(voice,inst[instrument]);
      FM_SetNote ( voice, (r-'0'+3) * 8) ;
      FM_SetVol(voice,music_volume);
      FM_KeyOn(voice);
    }
    else if(r == 'I') {              // i,j,k,l = cursor movement
      cy = cy -1;
      if(cy<5) cy = 5;
    }
    else if(r == 'K') {
      cy = cy +1;
      if(cy >15) cy = 15;
    }
    else if(r == 'J') {
      cx = cx -1;
      if(cx<54) cx = 54;
    }
    else if(r == 'L') {
      cx = cx +1;
      if(cx>61) cx = 61;
    }
    else if(r == ' ') {              // space = toggle bit
      togbit(inst[instrument][cy-5],(7-(cx-54)));
      drawvoice = 1;
    }
    else if(r == 'N') {               // I = change instrument
      instrument++;
      if(instrument > 8) instrument = 0;
      drawvoice = 1;
    }
    else if(r == 'R') {              // r = toggle rythm mode
      if(rythm) rythm = 0;
      else rythm = 1;
      FM_RythmMode(rythm);           // do it
      FM_RythmOn(FM_HIHAT);
      gotoxy(1,2);                   // tell the user
      if(rythm) cprintf("Rythm Mode ON  (voices 6,7,8 only) ");
      else       cprintf("Rythm Mode OFF                     ");
    }
    else if(r == 'V') {              //  v = change voice
      FM_KeyOff(voice);
      FM_SetVol(voice,0);
      voice ++;
      if(voice > 8) voice = 0;
      gotoxy(1,3);
      cprintf("Voice: %d ",voice);
    }
    else if(r == 'W') {              // Frequency ramp
      for(i = 0; i < 0xf000; i+= 0x10) {
        FM_SetFreq(voice,i);
        FM_KeyOn(voice);
        msdelay(5);
      }
    }


  }
  for(i = 0; i < 9; i++) {
    FM_SetVol(i,0);
  }

}




