/****************************************************************************
*
*						  The Universal VESA TSR
*
*					Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: uvesa.c $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Main startup module for the Universal VESA TSR. Performs
*				all of the command line processing, card detection and
*				CPU detection.
*
*				MUST be compiled in the large memory model.
*
* $Id: uvesa.c 1.1 1993/03/07 04:08:09 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: uvesa.c $
* Revision 1.1  1993/03/07  04:08:09  kjb
* Initial revision
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "drivers.h"
#include "getopt.h"

/*---------------------------- Global Variables ---------------------------*/

int		driver,chipID,memory,dac;
int		_grResult;
int		_VESAFirst = false;
int		_ignoreSVGA = false;
extern 	char *version;

/* Routine to parse command line arguments */

void parseArguments(int argc,char *argv[]);

/* Routines to manage the TSR side of things */

bool isLoaded(void);
void goTSR(int driver,int chipID,int memory,int dac);

/*----------------------------- Implementation ----------------------------*/

typedef struct {
	ushort	attributes;
	uchar	winAAttr;
	uchar	winBAttr;
	ushort	winGran;
	ushort	winSize;
	ushort  startSegA;
	ushort	startSegB;
	ulong	bankSwitch;
	ushort	bytesPerLine;

	/* Optional VESA Info */

	ushort	width;
	ushort	height;
	uchar	cwidth;
	uchar	cheight;
	uchar	planes;
	uchar	bitsPerPixel;
	uchar	banks;
	uchar	memMode;
	uchar	bankSize;
	uchar	numPages;
	} VesaBuf;

void testISR(void)
/****************************************************************************
*
* Function:		testISR
*
* Description:	This routine will be called if testing is turned on
*				during the compilation of the TSR. You can put whatever
*				code you like into this routine, to test the VESA
*				interface on your system.
*
****************************************************************************/
{
#ifdef	TESTING
	int				i,*modes;
	struct REGPACK	regs;
	VesaBuf			buf;

	printf("\n\nInsert your own testing routines in here!\n\n");
	printf("List of available VESA modes:\n");
	regs.r_ax = 0x4F00;
	regs.r_di = (int)&buf;
	regs.r_es = (long)&buf >> 16;
	intr(0x10,&regs);
	modes = *((int**)(&(((char*)&buf)[14])));
	while (*modes != -1)
		printf("%X ",*modes++);
	printf("\n\n");

	for (i = 0x100; i <= 0x11B; i++) {
		regs.r_ax = 0x4F01;
		regs.r_cx = i;
		regs.r_di = (int)&buf;
		regs.r_es = (long)&buf >> 16;
		intr(0x10,&regs);
		if (regs.r_ax == 0x004F) {
			if (buf.attributes & 2) {
				printf("Mode: %X, %dx%d, %d bytesPerLine, %d plane, %d bit, %d banks, %d page\n",
					i,buf.width,buf.height,buf.bytesPerLine,buf.planes,
					buf.bitsPerPixel,buf.banks,buf.numPages);
				}
			else
				printf("No optional information\n");
			}
		}
#endif
}

void main(int argc,char *argv[])
{
	parseArguments(argc,argv);

    printf("UNIVESA - Universal SuperVGA VESA BIOS Extension Version 1.2\n");
	printf("          Release %s\n\n",version);
	printf("Copyright (C) 1993 Kendall Bennett\n\n");
    if (isLoaded()) {
        printf("Universal VESA TSR is already loaded - installation aborted.\n");
        exit(1);
        }
    if (driver <= grSVGA) {
		printf("SuperVGA not detected - installation aborted.\n");
		exit(1);
		}
	printf("Installing for: %s",MGL_driverName(driver));
	if (MGL_chipsetName(driver,chipID) != NULL)
		printf(" (%s)", MGL_chipsetName(driver,chipID));
	printf("\nDAC:            %s\n", MGL_dacName(dac));
	if (memory < 1024)
		printf("Memory:         %d Kb\n",memory);
	else
		printf("Memory:         %d Mb\n",memory / 1024);

	goTSR(driver,chipID,memory,dac);
}
