include qlib.inc
include string.inc
include stdio.inc
include process.inc
include os.inc
include time.inc
include dos.inc
include alloc.inc

.data
  s1 dd ?              ;for CPUID str
  s2 dd ?
  s3 dd ?
  db 0
  saved_cpuid dd ?     ;for CPUID EAX
.code
main proc
  mov ax,0eeffh
  int 31h

  callp print,"DOS Extender detected : "
  mov al,_dosXtyp
  mov dx,_dosXver

  .if al==DOSX_PMODEW
    callp printf,"PMODE/W v%d.%d\n",dh,dl
  .elseif al==DOSX_DOS4GW
    callp printf,"DOS/4GW v%d.%d\n",dh,dl
  .elseif al==DOSX_DOS32
    callp printf,"DOS32 v%d.%d\n",dh,dl
  .else
    callp print,"Unknown\n"
  .endif

  callp print,"OS detected : "
  mov al,_os_typ
  .if al==OS_DOS
    callp print,"DOS"
  .elseif al==OS_WIN
    callp print,"Win"
  .elseif al==OS_WIN95
    callp print,"Win 95/NT"
  .elseif al==OS_WINNT
    callp print,"Win NT"
  .elseif al==OS_DV
    callp print,"DesqView"
  .elseif al==OS_OS2
    callp print,"OS/2"
  .else
    callp print,"Unknown OS detected\n"
  .endif
  callp printf," v%i.%i\n",_os_ver_major,_os_ver_minor
  mov al,_os_typ
  .if al!=OS_DOS
    callp printf,"DOS v%i.%i\n",_dos_ver_major,_dos_ver_minor
  .endif

  callp coreleft
  callp printf,"Free RAM : %d bytes\n",eax

  callp print,"Server : "
  mov al,_pmmode
  .if al==SRV_RAW
    callp print,"RAW\n"
  .elseif al==SRV_XMS
    callp print,"XMS\n"
  .elseif al==SRV_VCPI
    callp print,"VCPI\n"
  .elseif al==SRV_DPMI
    callp print,"DPMI\n"
  .elseif al==SRV_UNKNOWN
    callp print,"Unknown\n"
  .else
    callp print,"bug?\n"
  .endif
  callp print,"Processor : "
  mov al,_processor
  .if al==3
    callp print,"80386\n"
  .elseif al==4
    callp print,"80486\n"
  .elseif al==5
    callp print,"80586 (ie: Pentium or K5)\n"
  .elseif al==6
    callp print,"80686 (ie: Pentium Pro or K6)\n"
  .endif
  push cs
  lar ax,wptr[esp]
  add esp,4   ;segments are pushed as 32bit entities (although they are still 16bit)
  shr ah,8-3
  and ah,3
  callp printf,"CPL=%i\n",ah

;test if CPUID is avail
  pushfd
  pop eax
  mov ebx,eax
  xor eax,200000h
  push eax
  popfd
  pushfd
  pop eax
  .if eax!=ebx
    callp printf,"CPUID supported\n"    ;0fh 0a2h
    xor eax,eax
    db 0fh,0a2h  ;CPUID
    ;EAX = capablities
    ;EBX-EDX-ECX = String
    callp printf,"  EAX = %d\n",eax
    mov s1,ebx
    mov s2,edx
    mov s3,ecx
    callp printf,"  CPUID str=%s\n",offset s1
    mov eax,1
    db 0fh,0a2h  ;CPUID
    mov     saved_cpuid,eax         ;save for future use
    and     eax, 0F00H              ; mask everything but family
    shr     eax, 8
    callp printf,"  CPU Type : %d\n",al
    mov     eax,saved_cpuid         ;restore data
    and     al,0fh
    callp printf,"  Stepping : %d\n",al
    mov     eax, saved_cpuid
    and     al, 0F0H          ; isolate model info
    shr     al, 4
    callp printf,"  Model    : %d\n",al
  .else
    callp printf,"CPUID not supported\n"
  .endif
  ret
main endp

end

