/*===========================================================================*\
| PULLDEMO.C - Full demonstration of pull-down menus.       ver 2.0, 04-15-89 |
|                                                                             |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <dir.h>
#include <string.h>

#include "pullc20.h"
#include "pulldemo.h"

char origpathname[68];

void displayscreen(void)
{
    wwrite( 1, 1, "PULLDEMO v2.0             Multi-level Pu"
                  "ll-down Menus       Copr 1989  J H LeMay" );
    showtopline();
    setwindowmodes( PERMMODE );
    makewindow( 3, 1, crt_rows-3, crt_cols, WHITE+BLUE_BG, LIGHTGRAY+BLACK_BG,
                DOUBLE_BORDER, WINDOW1 );
    setwindowmodes(0);
    titlewindow( TOP, LEFT, SAMEATTR, "1" );
    tws.wndwattr = YELLOW+BLUE_BG;
    wwritec( 2, "PULLC20.ARC - MULTI-LEVEL PULL-DOWN MENUS" );
    wwritec( 9, "This is Work Window 1." );
    tws.wndwattr = tws.origattr;
    wwritec( 4, "Use F1 everywhere for some descriptions." );
    wwritec( 5, "Use \"Quit\" to exit demo program.        " );
    wwritec( 6, "Be sure to try a CR at \"\" marked lines." );
    wwritec( 7, "Also try all the EnterData lines.       " );
    wwrite( 11, 9,
            "The following Data Entry fields have some arbitrary values" );
    wwrite( 12, 9,
            "and ranges.  Move the highlight and edit.  Press F1 for help." );
}

void main()
{
/*  qsnow = 0; */
    prefer_multitask=1;              /* Use multi-tasking MTVB if possible. */
    initpull( LIGHTGRAY, 0, 0 );     /* <<-- be sure you do this!! */
    strcpy( origpathname, "A:\\" );
    origpathname[0]+=getdisk();
    getcurdir( 0, origpathname+3 );
    strcpy( pathname, origpathname );
    displayscreen();
    gotokeydispatcher();      /* <<-- all keyboard entries go through here! */
    if(origpathname!=pathname) {
        setdisk(origpathname[0]-'A');
        chdir(origpathname);
    }
    accesswindow( WINDOW0 );
    wclrscr();
    wgotorc( crt_rows, 1 );
    setcursor( cursor_initial );
}
