/*
   This program just puts a small routine on the timer IRQ to increment a
   byte on screen. Three methods are demonstrated. The first is the most
   convenient, using a C function for the IRQ handler. The second allows you
   to set up a normal protected mode IRQ handler without worrying about it
   getting control from real mode. The third allows you to set up your own
   handler for real mode for minimum latency.
*/

/*
  INTERFACE
*/
#include "pmc.h"

extern DWORD irqrmiaddx;

void irqc (void);
void irqi (void);

/*
  CODE
*/

//
void __cdecl PMmain (void)
{
  SELOFF opmiv;
  SEGOFF ormiv;
  PTR p;

//----------------------------------------------------------------------------
// Set up a C function as an IRQ handler, wait for a keypress, then reset.

  dosputstr ("C function IRQ handler.\r\n");
  p = setirq (0, &ormiv, &opmiv, NULL, NULL, irqc, IRQC);
  getch ();
  resetirq (0, &ormiv, &opmiv, p);

//----------------------------------------------------------------------------
// Set up a normal IRQ handler, wait for a keypress, then reset.

  dosputstr ("Normal IRQ handler.\r\n");
  p = setirq (0, &ormiv, &opmiv, NULL, NULL, irqi, IRQI);
  getch ();
  resetirq (0, &ormiv, &opmiv, p);

//----------------------------------------------------------------------------
// Set up a normal protected mode IRQ handler and a seperate real mode IRQ
// handler, wait for a keypress, then reset.

  dosputstr ("Own real mode IRQ handler.\r\n");
  p = setirq (0, &ormiv, &opmiv, NULL, irqrmiaddx, irqi, IRQOWN);
  getch ();
  resetirq (0, &ormiv, &opmiv, p);

//----------------------------------------------------------------------------
// The same thing again, but just to demonstrate what that NULL parameter is.

  dosputstr ("Same thing.\r\n");
  p = lomalloc (IRQOWNLEN);
  setirq (0, &ormiv, &opmiv, p, irqrmiaddx, irqi, IRQOWN);
  getch ();
  resetirq (0, &ormiv, &opmiv, p);
}

/*
  C IRQ 0 handler function that increments a byte on the screen.
  Notes:
  ) Does not chain to the old handler.
*/
void irqc (void)
{
  (*(BYTE *)rlp (0xb8000)) ++;

  asm
  {
    mov al,20h
    out 20h,al
  }
}

