/* BANK.C banking functions module.

   Copyright (c) 1995 Lin Ke-Fong, Ethereal Software.
*/

#include <conio.h>
#include "mpvga.h"

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
void MPVGA_SetWriteBank (int Bank)

{
  int x;
  short int *Ptr;

  switch (MPVGA_ChipType) {

    case __Acer     : wrinx(GRC,0x10,Bank); break;

    case __Ahead    : {
      if (MPVGA_ChipVer == AH_B)
        modinx(GRC,0x0D,0xF0,Bank << 4);
      else {
        wrinx(GRC,0x0D,(Bank & 7) >> 1);
        if ((Bank & 1) > 0) {
          x = inp(0x3CC) | 0x20;
          outp(0x3C2,x);
        } else {
          x = inp(0x3CC) & 0xDF;
          outp(0x3C2,x);
        }
      }
      break;
    }

    case __ALG      : outp(0x3D7,Bank); break;

    case __Alliance : {
      outpw(SEQ,0x1210);
      setinx(SEQ,0x1C,8);
      modinx(SEQ,0x1B,7,1);

      Ptr = (void *) 0xA00C0;
      *Ptr = Bank << 4;

      clrinx(SEQ,0x1B,7);
      clrinx(SEQ,0x1C,8);
      break;
    }

    case __ARK      : wrinx(SEQ,0x15,Bank); break;

    case __ATI      : {
      modinx(IOAdr,0xB2,0x1E,Bank << 1);
      if (MPVGA_ChipVer >= ATI_GUP_3) modinx(IOAdr,0xAE,3,Bank >> 4);
      break;
    }

    case __Chips    : {
      if (MPVGA_ChipVer <= CT_457)
        wrinx(IOAdr,0x0B,Bank);
      else {
        if (MPVGA_ChipVer != CT_452) Bank <<= 2;
        wrinx(IOAdr,0x10,Bank << 2);
        if (MPVGA_ChipVer == CT_64300) modinx(IOAdr,0x0C,0x10,Bank >> 2);
      }
      break;
    }

    case __Cirrus54 : {
      if ((rdinx(GRC,0x0B) & 32) == 0) Bank <<=  2;
      wrinx(GRC,9,Bank << 2);
      break;
    }

    case __Cirrus64 : wrinx(GRC,0x0E,Bank << 4); break;

    case __Compaq   : {
      wrinx(GRC,0x0F,5);
      if (MPVGA_ChipVer >= CPQ_QV1024 && ((inp(0x23C7) & 0x10) > 0))
        x = 2; else x = 4;
      wrinx(GRC,0x45,Bank << x);
      if ((rdinx(GRC,0x40) & 1) > 0)
        wrinx(GRC,0x46,(Bank << x) * 8);
      else wrinx(GRC,0x46,Bank << x);
      break;
    }

    case __HMC      : modinx(SEQ,0xEE,0x70,Bank << 4); break;

    case __Matrox   : modinx(0x3DE,9,0x0F,Bank); break;

    case __MXIC     : modinx(SEQ,0xC5,0x0F,Bank); break;

    case __NCR      : wrinx(SEQ,0x18,Bank << 2); break;

    case __Oak      : {
      if (MPVGA_ChipVer <= OAK_083)
        modinx(0x3DE,0x11,0xF0,Bank << 4);
      else wrinx(0x3DE,0x24,Bank);
      break;
    }

    case __Primus   : outp(0x3D6,Bank); break;

    case __Realtek  : outp(0x3D7,Bank); break;

    case __S3       : {
      wrinx(CRTC,0x39,0xA5);
      wrinx(CRTC,0x38,0x48);

      if (MPVGA_ChipVer >= S3_864)
        wrinx(CRTC,0x6A,Bank);
      else {
        setinx(CRTC,0x31,9);
        modinx(CRTC,0x35,0x0F,Bank);
        if (MPVGA_ChipVer > S3_924) modinx(CRTC,0x51,0x0C,Bank >> 2);
      }

      wrinx(CRTC,0x38,0);
      wrinx(CRTC,0x39,0x5A);

      break;
    }

    case __Sierra   : outp(0x3CD,Bank << 1); break;

    case __SiS      : outp(0x3CD,Bank); break;

    case __Trident  : {
      if (MPVGA_ChipVer >= TR_9000C)
        outp(0x3D8,Bank);
      else {
        wrinx(SEQ,0x0B,0);
        rdinx(SEQ,0x0B);
        modinx(SEQ,0x0E,0x0F,Bank ^ 2);
      }
      break;
    }

    case __Tseng    : {
      if (MPVGA_ChipVer == ET_3000) {
        x = inp(0x3CD) & 0xF8;
        outp(0x3CD,x + (Bank & 7));
      } else {
        x = inp(0x3CD) & 0xF0;
        outp(0x3CD,x + (Bank & 0x0F));
        if (MPVGA_ChipVer != ET_4000) {
          x = inp(0x3CB) & 0xFC;
          outp(0x3CB,x + ((Bank >> 4) & 3));
        }
      }
      break;
    }

    case __UMC      : modinx(SEQ,6,0xF0,Bank << 4); break;

    case __Video7   : {
      if (MPVGA_ChipVer < V7_208A) {
        if ((Bank & 2) > 0) {
          x = inp(0x3CC) | 0x20;
          outp(0x3C2,x);
        } else {
          x = inp(0x3CC) & 0xDF;
          outp(0x3C2,x);
        }
        modinx(SEQ,0xF9,1,Bank);
        modinx(SEQ,0xF6,3,Bank >> 2);
      } else wrinx(SEQ,0xE8,Bank << 4);
      break;
    }

    case __WD       : {
      wrinx(GRC,9,Bank << 4);
      wrinx(GRC,0x0A,Bank << 4);
      if (MPVGA_ChipVer == WD_90c33)
        modinx(SEQ,0x14,0xC0,((Bank >> 4) & 1)*0xC0);
      break;
    }

    default : break;
  }
  return;
}


void MPVGA_SetReadBank (int Bank)

{
  int x;

  switch (MPVGA_ChipType) {

    case __Acer     : wrinx(GRC,0x11,Bank); break;

    case __Ahead    : {
      if (MPVGA_ChipVer == AH_B) modinx(GRC,0x0D,0x0F,Bank & 0x0F);
      break;
    }

    case __ALG      : outp(0x3D6,Bank); break;

    case __ARK      : wrinx(SEQ,0x16,Bank); break;

    case __ATI      : {
      if (MPVGA_ChipVer > ATI_18800) {
        modinx(IOAdr,0xB2,0xE1,((Bank & 7) << 5) + ((Bank & 8) >> 4));
        if (MPVGA_ChipVer >= ATI_GUP_3) modinx(IOAdr,0xAE,0x0C,Bank >> 2);
      }
      break;
    }

    case __MXIC     : modinx(SEQ,0xC5,0xF0,(Bank & 0x0F) << 4); break;

    case __NCR      : wrinx(SEQ,0x1C,Bank << 2); break;

    case __Oak      : {
      if (MPVGA_ChipVer <= OAK_083)
        modinx(0x3DE,0x11,0x0F,Bank);
      else wrinx(0x3DE,0x23,Bank);
      break;
    }

    case __Primus   : outp(0x3D7,Bank); break;

    case __Realtek  : outp(0x3D6,Bank); break;

    case __Sierra   : wrinx(SEQ,0x15,Bank << 1); break;

    case __SiS      : outp(0x3CB,Bank); break;

    case __Trident  : {
      if (MPVGA_ChipVer >= TR_9000C) outp(0x3D9,Bank);
      break;
    }

    case __Tseng    : {
      if (MPVGA_ChipVer == ET_3000) {
        x = inp(0x3CD) & 0xC7;
        outp(0x3CD,x + ((Bank & 7) << 3));
      } else {
        x = inp(0x3CD) & 0x0F;
        outp(0x3CD,x + ((Bank & 0xF) << 4));
        if (MPVGA_ChipVer != ET_4000) {
          x = inp(0x3CB) & 0xCF;
          outp(0x3CB,x + (Bank & 0x30));
        }
      }
      break;
    }

    case __UMC      : modinx(SEQ,6,0x0F,Bank & 0x0F); break;

    case __WD       : {
      wrinx(GRC,9,Bank << 4);
      if (MPVGA_ChipVer == WD_90c33) modinx(SEQ,0x14,0x40,Bank << 2);
      break;
    }

    default : break;
  }
  return;
}




