               /*Ŀ
                                                                        
                  gmenu() = PROGRAM TO DEMONSTRATE THE USE OF MENUS     
                            AND WINDOWS IN GRAPHICS MODE                
                                                                        
                 */

               /*Ŀ
                                                                        
                                       INCLUDES                         
                                                                        
                 */

#include <stdio.h>
#include <math.h>
#include <dos.h>

               /*Ŀ
                                                                        
                                 USER WRITTEN INCLUDES                  
                                                                        
                 */

#include "colors.h"
#include "gtools.h"
#include "gdraws.h"

               /*Ŀ
                                                                        
                      GLOBAL VARIABLES USED BY GRAPHICS FUNCTIONS       
                                                                        
                 */


enum vidTypes {mda, cga, ega, compaq, other};

int color = 2;
int background_color = 0;
int LINEWIDTH=1, OPERATOR=0, ANGLE, XCENTER, YCENTER;
unsigned long int PATTERN=0xFFFFFFFF;
char string[5][30]={{"Select choice with arrows -- "},
                   {"'Enter' to quit...           "},
                   {"Six pointed star             "},
                   {"Five pointed star            "},
                   {"Rotated rectangles           "}};




               /*Ŀ
                                                                        
                                  FUNCTION DEFINITIONS                  
                                                                        
                 */

int menu(int x1, int y1, int x2, int y2);
void save_restore (int x1, int y1, int x2, int y2, int type);
void wait(char title[]);        /* prompt to continue, wait for keypress */
void write_menu_line(int x,int y,char string[], int color);


               /*Ŀ
                                                                        
                                      MAIN PROGRAM                      
                                                                        
                 */




main()
{
        int i, j, k, x, y, oldx, oldy, midpoint,select;
        double xd,yd,ampl,aspect;
        char ch;

        cls (1);                                /*  clear screen */
        ch = getAdapter();
        if ((ch != 'V') && (ch != 'E'))
                printf("Cannot Run Demo -- EGA or VGA Not Installed!");
        else
        {
                setMode(16);    /* go to EGA high resolution mode */
                LINEWIDTH = 3;
                cls(1);
                drawRect(-310,225,310,-220,10);
                drawLine(-310,225,310,-220,10);
                drawLine(310,225,-310,-220,10);
                select = menu(2,2,37,8);

                if (select==1)
                {
                        LINEWIDTH = 2;
			drawPoly(11,-259, 90,-59, 90,-159,-90,-999);
			drawPoly(11,-259,-20,-159,160,-59,-20,-999);
                }
                if (select == 2)
                {
			fillOval(161,34,107,9,1.0);
			fillPoly(14,60,66,262,66,104,-55,161,140,218,-55,-999);
                }
                if (select == 3)
                {
                        LINEWIDTH = 1;
                        color=3;
		        XCENTER = -70;
        		YCENTER = 35;
	        	for (ANGLE=0; ANGLE<180; ANGLE+=15)
	        	{
		        	rotateRect(-220,100,80,-35,color);
	        	        color++;
        		}
                        wait("Rotated Rectangles");
                }
        }
}

void wait(char title[])         /* prompt to continue, wait for keypress */
{
        int tab,width;
        getMode(&width);        /* get width in columns */
        tab = (width - strlen(title))/2;        /* starting column for text */
        gotoxy(tab,0);
        writString(title,WHITE,0);
        tab = (width - 33)/2;   /* starting column for text */
        gotoxy(tab,24);
        writString("Press any key to continue demo...", WHITE,0);
        getch();
        cls(0);
}  /*-------------------------------*/


int menu(int x1, int y1, int x2, int y2)
{
        int i,j,select=2,temp,ch;

        save_restore(x1,y1,x2,y2,0);
        setWindow(x1,y1,x2,y2,4);
	for (i=0; i<3; i++)
	{
		for (j=y1*14; j<=y2*14+14; j++)
		{
			plot(x1*8+i,j,11);
                	plot((x2+1)*8-i,j,11);
		}
		for(j=x1*8+3; j<=x2*8+5; j++)
		{
			plot(j,y1*14+i,11);
                	plot(j,(y2+1)*14-i,11);
		}
	}
        write_menu_line(x1*8+10,y1*14+10,string[0],79);
        write_menu_line(x1*8+10,y1*14+24,string[1],79);
        write_menu_line(x1*8+10,y1*14+38,string[2],47);
        write_menu_line(x1*8+10,y1*14+52,string[3],79);
        write_menu_line(x1*8+10,y1*14+66,string[4],79);
        while ((ch = getch()) != 13)
        {
                if (ch == 0x00)
                        ch = getch() +256;
                switch(ch)
                {
                        case 336:       if (select < 4)
                                        {
                                                write_menu_line(x1*8+10,(y1 +
                                                        select)*14 + 10,
                                                        string[select],79);
                                                write_menu_line(x1*8+10,(y1+
                                                        select)*14 +10,
                                                        string[++select],47);
                                        }
                                        break;
                        case 328:       if (select > 2)
                                        {
                                                write_menu_line(x1*8+10,(y1 +
                                                        select)*14 + 10,
                                                        string[select],79);
                                                write_menu_line(x1*8+10,(y1 +
                                                        select)*14 + 10,
                                                        string[--select],47);
                                        }
                }
        }

        save_restore(x1,y1,x2,y2,1);
        return(select-1);
}
void save_restore (int x1, int y1, int x2, int y2, int type)
{
        #define DISPLAY_OUT(index,val)  {outp(0x3CE,index);\
                                         outp(0x3CF,val);}
        unsigned char exist_color;
        char far *base1;
        char far *base2;
        int x,y;

        DISPLAY_OUT(5,0x01);
        for (y=(y1-1)*14; y<=(y2+2)*14; y++)
        {
                for (x=(x1-1)*8; x<=(x2+1)*8; x+=8)
                {
                        base1 = (char far *) (0xA0000000L + ((long)y *
                                80L + ((long)x/8L)));
                        base2 = (char far *) (0xA8000000L + ((long)y *
                                80L + ((long)x/8L)));
                        if (type == 0)
                        {
                                exist_color = *base1;
                                *base2 = 0x00;
                        }
                        else
                        {
                                exist_color = *base2;
                                *base1 = 0x00;
                        }
                }
        }
        DISPLAY_OUT(5,0);
}

void write_menu_line(int x,int y,char string[], int color)
{
	int char_offset,p=0;

	while (string[p])
	{
		char_offset = (string[p] - 32) * 14;
		plot_char(x,y,char_offset,color,0);
		x += 8;
		p++;
	}
}
