/*****************************************************************************
* Definitions for the Poly3D program:					     *
*****************************************************************************/

#ifndef POLY_3D_H
#define POLY_3D_H

#include "irit_sm.h"
#include "genmat.h"
#include "iritprsr.h"
#include "cagd_lib.h"

/* Name	of generic matric transformation saved by this program:	*/
#define GENERIC_MAT_FILE  "generic#.mat"   /* Generic mat file name to save. */
#define GENERIC_GIF_FILE  "generic#.gif"   /* Generic gif file name to save. */
#define GENERIC_PS_FILE   "generic#.ps"	    /* Generic PS file name to save. */

/* The current NormalLength is divided by scaler to form real normal length: */
#define NORMAL_DEFAULT_LENGTH	10
#define NORMAL_SCALER_LENGTH	100

#define DEFAULT_COLOR		1      /* For objects with no color defined. */

#define VIEW_PERSPECTIVE	1			      /* View modes. */
#define VIEW_ORTHOGRAPHIC	2
#define DEFAULT_PERSPECTIVE_Z	-5.0		   /* Default Z focal point. */

#define TRANS_SCREEN	1     /* Screen, Object coords. transformation mode. */
#define TRANS_OBJECT	2

#define DEFAULT_NUM_OF_ISOLINES		10
#define DEFAULT_SAMPLES_PER_CURVE	6

/* Some external variables defined for all the programs: */

extern char
#ifdef __GL__
    *TransPrefPos,
    *ViewPrefPos,
#endif /* __GL__ */
#ifdef __MSDOS__
    *GlblViewWndwPos,
    *GlblTransWndwPos,
    *GlblStatusWndwPos,
    *GlblInputWndwPos,
    *GlblIntrSaveDisk,
#endif /* __MSDOS__ */
    GlblFirstDataFileName[];		    /* Hold name of first data file. */

extern int
#ifdef __MSDOS__
    GlblWindowFrameWidth,
    GlblViewFrameColor,
    GlblViewBackColor,                                                             GlblTransFrameColor,
    GlblTransBackColor,
    GlblStatusFrameColor,
    GlblStatusBackColor,
    GlblInputFrameColor,
    GlblInputBackColor,
    GlblDrawHeader,
    GlblSmoothTextScroll,
    GlblIntrSaveMethod,
#endif /* __MSDOS__ */
    GlblInternal,
    GlblMore,
    GlblDrawVNormal,
    GlblDrawPNormal,
    GlblNumEdges,
    GlblMouseExists,
    GlblMouseSensitivity,
    GlblJoystickExists,
    GlblGraphDriver,
    GlblClosedObject,
    GlblDrawSurfaceMesh,
    GlblNumOfIsolines,
    GlblSamplesPerCurve,
    GlblTransformMode,		      /* Screen, Object coords. trans. mode. */
    GlblViewMode,			   /* Perspective, Orthographic etc. */
    GlblDepthCue,				   /* Activate depth cueing. */
    GlblDrawSolid;			 /* Use hardware Z buffer rendering. */

extern RealType GlblNormalLen;		     /* Scaler for normals if drawn. */
extern MatrixType CrntViewMat;			/* This is the current view! */

/* And finally Poly3D module prototypes: */
IPPolygonStruct *ProcessSurfaces(CagdCrvStruct *Crvs, CagdSrfStruct *Srfs);
IPPolygonStruct *Surface2Polygons(CagdSrfStruct *Srf);
VoidPtr MyMalloc(unsigned size);
void MyFree(VoidPtr p);
void MyExit(int ExitCode);

/* PostScrp module: */
void SavePostScript(IPObjectStruct *Objects);

#endif /* POLY_3D_H */
