/*  exam3.c - Digital Sound Interface Kit V1.01a example code

    Copyright 1993,94 Carlos Hasan
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include "sound.h"
#include "ts.h"

word PeriodTable[12*4] =
    /* C   C#  D   D#  E   F   F#  G   G#  A   A#  B */
    { 856,808,762,720,678,640,604,570,538,508,480,453,
      428,404,381,360,339,320,302,285,269,254,240,226,
      214,202,190,180,170,160,151,143,135,127,120,113,
      107,101,95,90,85,80,75,71,67,63,60,56 };

char KeyTable[12*3] =
      "ZSXDCVGBHNJMQ2W3ER5T6Y7UI9O0P";

int main(void)
{
    DSMCard Card;
    DSMInst *Sample;
    int Key, Note, Chan;

    if (DSMLoadSetup(&Card)) {
        printf("Please run SETUP.EXE to configure.\n\n");
        return 1;
    }
    if (DSMInit(&Card)) {
        printf("Error Initializing the Sound System.\n\n");
        return 1;
    }
    if ((Sample = DSMLoadSample("DING.WAV",0L)) == NULL) {
        switch (DSMStatus) {
          case ERR_NORAM:  printf("Not enough system memory.\n"); break;
          case ERR_NODRAM: printf("Not enough card memory.\n"); break;
          case ERR_NOFILE: printf("File not found.\n"); break;
          case ERR_FORMAT: printf("Invalid file format.\n"); break;
          case ERR_ACCESS: printf("File damaged.\n"); break;
        }
        DSMDone();
        return 1;
    }
    DSMSetupVoices(9,128);

    TSInit();
    TSSetRate(70);
    TSSetRoutine(DSMPoll);

    printf("\n");
    printf("     C# D#    F# G# A#    C# D#    F# G# A#    C# D#   \n");
    printf("                         \n");
    printf("                         \n");
    printf("   SD  GHJ  23  567  90  \n");
    printf("             \n");
    printf("   Z X C V B N M Q W E R T Y U I O P \n");
    printf("   \n");
    printf("    C  D  E  F  G  A  B  C  D  E  F  G  A  B  C  D  E  \n");
    printf("\n");
    printf("   Press keys to play the sample and ESC to exit.      \n");

    Chan = 0;
    while ((Key = toupper(getch())) != 27) {
        for (Note = 0; Note < 12*3; Note++) {
            if (Key == KeyTable[Note]) {
                /* play chord C-E-G */
                DSMPlaySample(Chan,Sample);
                DSMPlaySample(Chan+1,Sample);
                DSMPlaySample(Chan+2,Sample);
                DSMSetPeriod(Chan,PeriodTable[Note]);
                DSMSetPeriod(Chan+1,PeriodTable[Note+4]);
                DSMSetPeriod(Chan+2,PeriodTable[Note+7]);
                Chan = (Chan+3) % 9;
            }
        }
    }

    TSDone();
    TSRestoreTime();

    DSMFreeSample(Sample);
    DSMDone();
    return 0;
}
