/*
  ͻ
                                                                          
                                  Spin 2                                  
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float sind(float a)
{
  return sin(a * piover180);
}

float cosd(float a)
{
  return cos(a * piover180);
}

typedef char name[13];

FILE *Out_File;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(Out_File,"ͻ\n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                                Spin 2                                  \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                       by Christopher D. Watkins                        \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"ͼ\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"STATS\n");
  fprintf(Out_File,"   XRES    = %d\n",xresolution);
  fprintf(Out_File,"   YRES    = %d\n",yresolution);
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"FRAMES\n");
  fprintf(Out_File,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"ENVIRONMENT\n");
  fprintf(Out_File,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(Out_File,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(Out_File,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(Out_File,"   RDEPTH  =    3\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMPS\n");
  fprintf(Out_File,"   REFLAMP = FALSE\n");
  fprintf(Out_File,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   DISTEFF =    0.050\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"OBSERVER\n");
  fprintf(Out_File,"   FLENGTH =    2.800\n");
  fprintf(Out_File,"   OBSPOS  =    0.000 -660.000  220.000\n");
  fprintf(Out_File,"   ROTATE  =    0.000\n");
  fprintf(Out_File,"   TILT    =   16.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"SKY\n");
  fprintf(Out_File,"   HORCOL  =    0.100    0.100    0.100\n");
  fprintf(Out_File,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(Out_File,"   CLOUDS  = FALSE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = PLASTICTILE\n");
  fprintf(Out_File,"   TEXTURE = CHECKER\n");
  fprintf(Out_File,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(Out_File,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   GLOSS   =    8.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(Out_File,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TILE    =    0.012\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = CHROME\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   DIFRFL  =    0.500    0.500    0.500\n");
  fprintf(Out_File,"   SPCRFL  =    0.300    0.300    0.300\n");
  fprintf(Out_File,"   GLOSS   =   30.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"GROUND\n");
  fprintf(Out_File,"   MATL    = PLASTICTILE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     =  350.000 -350.000  350.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     = -350.000 -350.000  350.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  Byte frame;
  float phase;
  float x1, y1, z1;
  float rad1, hgt1;
  float dx1, dy1;
  float zoffset;

  phase = 0.0;
  rad1 = 30.0;
  zoffset = rad1;
  for (frame = 1; frame <= numberofframes; frame++)
  {
    writestudio();
    x1 = 0.0;
    y1 = 0.0;
    z1 = zoffset;
    hgt1 = 45.0;
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",rad1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"CYLINDER\n");
    fprintf(Out_File,"   BASELOC = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   BASERAD = %3.3f\n",rad1);
    fprintf(Out_File,"   APEXLOC = %3.3f %3.3f %3.3f\n",x1,y1,z1 + hgt1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    z1 = zoffset + hgt1;
    hgt1 = 250.0;
    dx1 = cosd(phase);
    dy1 = sind(phase);
    x1 = hgt1 / 2.0 * dx1;
    y1 = hgt1 / 2.0 * dy1;
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",rad1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",-x1,-y1,z1);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",rad1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"CYLINDER\n");
    fprintf(Out_File,"   BASELOC = %3.3f %3.3f %3.3f\n",-x1,-y1,z1);
    fprintf(Out_File,"   BASERAD = %3.3f\n",rad1);
    fprintf(Out_File,"   APEXLOC = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    dx1 = cosd(phase + 90.0);
    dy1 = sind(phase + 90.0);
    x1 = hgt1 / 2.0 * dx1;
    y1 = hgt1 / 2.0 * dy1;
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",rad1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",-x1,-y1,z1);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",rad1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"CYLINDER\n");
    fprintf(Out_File,"   BASELOC = %3.3f %3.3f %3.3f\n",-x1,-y1,z1);
    fprintf(Out_File,"   BASERAD = %3.3f\n",rad1);
    fprintf(Out_File,"   APEXLOC = %3.3f %3.3f %3.3f\n",x1,y1,z1);
    fprintf(Out_File,"   MATL    = CHROME\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"BOUNDINGSPHERETEST\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"ENDFRAME\n");
    phase = phase + (90.0 / numberofframes);  /*  90 because of symmetry  */
  }
}

void main()
{
  strcpy(filename,"Spin2.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  Out_File=fopen(filename, "wt");
  writeheader();
  make();
  fclose(Out_File);
}