/*
  ͻ
                                                                          
                              Newton's Cradle                             
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float SinD(float a)
{
  return sin(a * piover180);
}

float CosD(float a)
{
  return cos(a * piover180);
}

typedef char name[32];

FILE *textdiskfile;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 28;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                            Newtons Cradle                              \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    3\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.250\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 -900.000  290.000\n");
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   15.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PLASTICTILE\n");
  fprintf(textdiskfile,"   TEXTURE = CHECKER\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(textdiskfile,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TILE    =    0.012\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CHROME\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.500    0.500\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   GLOSS   =   30.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   25.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDMIRROR\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.050    0.050\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.100    0.100\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =   25.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = PLASTICTILE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000    0.000  500.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000  -1000.000  70.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  float phase;
  Word frame;
  float xp, zp;

  phase = 0.0;
  for (frame = 1; frame <= numberofframes; frame++)
  {
    writestudio();

	  /*  Stand  */

    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = -150.000  150.000 0.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC = -150.000  150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = -150.000  150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = -150.000 -150.000 0.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC = -150.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = -150.000  -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = 150.000 150.000 0.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC = 150.000 150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = 150.000  150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = 150.000 -150.000 0.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC = 150.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = 150.000  -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = -150.000 150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =  150.000 150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = -150.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =  150.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");

	  /*  2 stable orbs  */

    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =  -30.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =  -30.000  150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =  -30.000    0.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    2.500\n");
    fprintf(textdiskfile,"   APEXLOC =  -30.000    0.000  40.000\n");
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     =  -30.000    0.000  40.000\n");
    fprintf(textdiskfile,"   RADIUS  =   30.000\n");
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =   30.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =   30.000  150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =   30.000    0.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    2.500\n");
    fprintf(textdiskfile,"   APEXLOC =   30.000    0.000  40.000\n");
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     =   30.000    0.000  40.000\n");
    fprintf(textdiskfile,"   RADIUS  =   30.000\n");
    fprintf(textdiskfile,"   MATL    = REDMIRROR\n");

	  /*  Left Orb  */

    if (((frame >= 1) && (frame <= 7)) || ((frame >= 22) && (frame <= 28)))
    {
      xp = -90.0 + 140.0 * CosD(180.0 + 90.0 + 90 * CosD(180.0 + phase));
      zp = 180.0 + 140.0 * SinD(180.0 + 90.0 + 90 * CosD(180.0 + phase));
    }
    else
    {
      xp = -90.0;
      zp = 40.0;
    }
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =  -90.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =  -90.000  150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =  -90.000    0.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    2.500\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 0.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 0.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   30.000\n");
    fprintf(textdiskfile,"   MATL    = REDMIRROR\n");

	  /*  Right Orb  */

    if ((frame >= 8) && (frame <= 21))
    {
      xp = 90.0 + 140.0 * CosD(180.0 + 90.0 + 90 * CosD(180.0 + phase));
      zp = 180.0 + 140.0 * SinD(180.0 + 90.0 + 90 * CosD(180.0 + phase));
    }
    else
    {
      xp = 90.0;
      zp = 40.0;
    }
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =   90.000 -150.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    5.000\n");
    fprintf(textdiskfile,"   APEXLOC =   90.000  150.000 180.000\n");
    fprintf(textdiskfile,"   MATL    = BRASS\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =   90.000    0.000 180.000\n");
    fprintf(textdiskfile,"   RADIUS  =    2.500\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 0.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 0.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   30.000\n");
    fprintf(textdiskfile,"   MATL    = CHROME\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"ENDFRAME\n");
    phase = phase + (360.0 / numberofframes);
  }
}

void main()
{
  strcpy(filename,"NEWTCRAD.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}