
;Ŀ
;                                                                   
;                                           
;                                                         
;                                                   
;                                                           
;                                                   
;                                                                   
;      2MFKIT 2.0  -  (C) Abril 1994 Ciriaco Garca de Celis.       
;                                                                   
;        FICHERO CON CODIGO ENSAMBLADOR LINKABLE CON 2MF.C          
;                                                                   
;        Con cdigo del sector de arranque, el cdigo de 2M         
;        que ser almacenado en los sectores de los disquetes       
;        y algunas funciones de utilidad codificadas en ASM.        
;                                                                   
;  Proceso:                                                         
;                                                                   
;    TASM    2MFKIT  /m5 /mx                                        
;                                                                   
;    El fichero 2MFBOOT.DB que se carga con INCLUDE debe obtenerse  
;    previamente a partir de 2MFBOOT.ASM con ayuda de 2MFBMAKE.BAS  
;                                                                   
;

_DATA          SEGMENT WORD PUBLIC 'DATA'
               ASSUME  CS:_DATA, DS:_DATA

               PUBLIC  _BootPrg,    _BootPrgLong
               PUBLIC  _Boot2mCode, _Boot2mLong
               PUBLIC  _biosdsk,    _PicoRetardo


; ------------ Cdigo del sector de arranque

_BootPrg:      CLI
               XOR   AX,AX
               MOV   SS,AX
               MOV   SP,7C00h          ; SS:SP inicializado
               MOV   AX,07C0h
               PUSH  AX
               ADD   AX,20h
               PUSH  AX
               POP   ES
               POP   DS
               XOR   SI,SI
               XOR   DI,DI
               MOV   CX,100h
               CLD
               REP   MOVSW             ; auto-reubicar este cdigo
               MOV   BX,DS:[68]        ; constante de reubicacin
               LEA   AX,[BX+OFFSET boot_ini - OFFSET _BootPrg]
               PUSH  ES
               PUSH  AX
               RETF                    ; saltar a boot_ini reubicado

boot_ini:      STI
               MOV   SI,OFFSET boot_txt - OFFSET _BootPrg
               CALL  print
               MOV   BX,1Eh*4
               LDS   SI,DWORD PTR SS:[BX]
               PUSH  DS                ; *
               PUSH  SI                ; **
               XOR   DI,DI
               MOV   SS:[BX],DI
               MOV   SS:[BX+2],ES
               MOV   CX,11
               REP   MOVSB             ; copiar tabla base disco a RAM
               PUSH  ES
               POP   DS
               MOV   AL,DS:[24]
               MOV   [DI-7],AL         ; sectores/pista correctos
               XOR   AX,AX
               MOV   ES,AX
               MOV   BX,7C00h          ; ES:BX = 0000:7C00
               MOV   ES:[BX+1FEh],AX   ; boot an no vlido
               MOV   AX,0201h          ; leer un sector
               MOV   CX,DS:[22]
               ADD   CX,2              ; el primer sector de la FAT2
               XOR   DX,DX             ; cabezal 0 y unidad A:
               CMP   CX,10             ; disquete de alta densidad?
               JB    skip_code         ; (botar del disco duro)
               PUSH  CX
               INT   13h               ; cargar sector real de boot
               POP   CX
               MOV   BX,SS:[413h]
               SUB   BX,5
               MOV   AX,64
               MUL   BX
               MOV   ES,AX
               PUSH  BX                ; ***
               XOR   BX,BX
               MOV   AX,205h           ; leer 5 sectores
               INC   CX                ; cilindro 0 y 2 sector FAT2
               XOR   DX,DX             ; cabezal 0 y unidad A:
               INT   13h
               POP   BX                ; ***
skip_code:     POP   SS:[1Eh*4]        ; **  restaurar INT 1Eh
               POP   SS:[1Eh*4+2]      ; *
               CMP   WORD PTR ES:[2558],0AA55h  ; cdigo vlido?
               JNE   err_boot          ; fallo al cargar 2M SuperBOOT
               MOV   SS:[413h],BX      ; rebajar memoria libre
               PUSH  ES                ; *
               MOV   AH,8
               MOV   BL,0
               MOV   DL,0
               INT   13h               ; tipo de unidad A:?
               MOV   AL,BL
               MOV   AH,0
               CMP   DL,2
               JB    ins_sb
               PUSH  AX
               MOV   AH,8
               MOV   BL,0
               MOV   DL,1
               INT   13h               ; tipo de unidad B:?
               POP   AX
               MOV   AH,BL
ins_sb:        POP   ES                ; *
               MOV   ES:[2558],ES           ; segmento del CALL FAR
               CALL  DWORD PTR ES:[2556]    ; instalar SuperBOOT
               MOV   AX,201h           ; leer un sector
               XOR   DX,DX             ; cabezal 0 y unidad A:
               MOV   ES,DX
               MOV   CX,1              ; el sector 1 del cilindro 0
               MOV   BX,8000h          ; acceso de lectura slo para
               PUSH  AX                ; quitar error "disco cambiado"
               INT   13h
               POP   AX
               MOV   BX,7C00h
               PUSH  ES                ; apilar direccin 0:7C00h
               PUSH  BX
               CMP   WORD PTR ES:[BX+3],"M2"
               JNE   exec_boot         ; el BOOT virtual no es 2M
hd_boot:       MOV   DL,80h            ; primer disco duro
               INT   13h               ; cargar tabla de particiones
exec_boot:     CMP   WORD PTR ES:[7DFEh],0AA55h
               JNE   intenta_hd?
               XOR   DX,DX             ; conviene DX=0 para Microsoft
               RETF                    ; ejecutar particin / BOOT
intenta_hd?:   AND   DL,DL
               JZ    hd_boot           ; BOOT no vlido, probar HD

err_boot:      MOV   SI,OFFSET no_boot_txt - OFFSET _BootPrg
               CALL  print
               MOV   AH,0
               INT   16h               ; esperar tecla
               INT   19h               ; volver a arrancar

print:         ADD   SI,DS:[68]
putchar:       CLD
               LODSB
               AND   AL,AL
               JZ    retorno
               MOV   AH,0Eh
               MOV   BX,7
               INT   10h               ; imprimir carcter
               JMP   putchar
retorno:       RET

boot_txt       DB    13,10,"2M SuperBOOT 2.0",13,10,0
no_boot_txt    DB    13,10,"No botable!",13,10,0

_BootPrgLong   DW    $-OFFSET _BootPrg


; ------------ Rutina de acceso a disco va BIOS. No se utiliza la
;              funcin biosdisk() del compilador porque en algunas
;              versiones del mismo hace tonteras que no debe. As,
;              adems, se puede llamar a INT 13h con CALL (bueno,
;              con RETF) para que dentro de WINDOWS 2MF /M no de
;              problemas; adems, la funcin de formateo de 2M
;              requiere SI="2M" al llamar.

_biosdsk       PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  SI
               PUSH  DI
               PUSHF                   ; estructura para futuro IRET
               PUSH  CS
               LEA   AX,bdsk_ret
               PUSH  AX
               XOR   AX,AX
               MOV   ES,AX
               PUSH  ES:[13h*4+2]      ; INT 13h -> pila
               PUSH  ES:[13h*4]
               MOV   AH,[BP+6]
               MOV   DL,[BP+8]
               MOV   DH,[BP+10]
               MOV   CH,[BP+12]
               MOV   CL,[BP+14]
               MOV   AL,[BP+16]
               LES   BX,DWORD PTR [BP+18]
               MOV   SI,"2M"
               RETF                    ; ejecutar INT 13h
bdsk_ret:      POP   DI
               POP   SI
               POP   BP
               MOV   AL,AH             ; resultado
               MOV   AH,0
               RET
_biosdsk       ENDP


; ------------ Pequeo retardo de medio milisegundo.

_PicoRetardo   PROC  FAR
               PUSH  AX
               PUSHF
               POP   AX
               OR    AH,70h
               PUSH  AX
               POPF
               PUSHF
               POP   AX
               AND   AH,0F0h
               CMP   AH,0F0h           ; es PC/XT?
               JE    xt
               MOV   CX,33             ; 181193180*33*1000 = 0.5 ms
wrf:           IN    AL,61h
               AND   AL,10h
               CMP   AL,AH
               JE    wrf          ; esperar pulso refresco memoria
               MOV   AH,AL
               LOOP  wrf
xt:            POP   AX
               RET
_PicoRetardo   ENDP


; ------------ Cdigo 2M para grabar en los 5 sectores ocultos de los
;              disquetes de alta densidad al formatear.

_Boot2mCode:   INCLUDE 2MFBOOT.DB

_Boot2mLong    DW    $-OFFSET _Boot2mCode

_DATA          ENDS

               END
