'SCRNSUBS.BAS

DEFINT A-Z


SUB ScrnInit
  '
  ' Initialization.  Determines screen mode, whether checking
  ' for horizontal & vertical retrace is necessary, and determines
  ' screen segment address.
  '
  SHARED ScrnMode, ScrnSegment, ScrnRetrace

  CALL GetVid(ScrnMode)             'Get screen mode.

  IF (ScrnMode < 7)         _
  THEN ScrnSegment = &HB800 _
  ELSE ScrnSegment = &HB000

  ScrnRetrace = (ScrnSegment = &HB800)
END SUB 'ScrnInit


SUB SaveScreenArea(UpperLeftRow, UpperLeftCol, NumberOfRows, NumberOfCols, _
  SaveText$, SaveAttr$)
  '
  ' Saves the contents of the screen.
  ' No bounds checking is performed.
  ' Screen defined must be within the actual screen space.
  ' Number of rows or columns must be > 0.
  '
  SHARED ScrnRetrace, ScrnSegment

  NumberOfChars = NumberOfRows * NumberOfCols
  SaveText$ = STRING$(NumberOfChars, 0)
  SaveAttr$ = STRING$(NumberOfChars, 0)
  ScreenDisplacement = ((UpperLeftRow - 1) * 80) + (UpperLeftCol - 1)
  SavePtr = 0
  FOR i = 1 TO NumberOfRows
	 CALL ReadVid(NumberOfCols, Dummy%, STRSEG(SaveText$),_
	STRPTR(SaveText$), STRSEG(SaveAttr$), STRPTR(SaveAttr$), SavePtr, _
	ScrnSegment, ScreenDisplacement + ((i - 1) * 80))
    SavePtr = SavePtr + NumberOfCols
  NEXT
END SUB 'SaveScreenArea



SUB WriteScreenArea (UpperLeftRow, UpperLeftCol, NumberOfRows, _
	 NumberOfCols, Text$, Attr$)
  '
  ' Writes the contents of the screen variables.
  ' No bounds checking is performed.
  ' Screen defined must be within the actual screen space.
  ' Text$ and Attr$ must both be NumberOfRows * NumberOfCols long.
  ' Number of rows and number of columns must be > 0.
  '
  SHARED ScrnRetrace, ScrnSegment

  ScreenDisplacement = ((UpperLeftRow - 1) * 80) + (UpperLeftCol - 1)
  SavePtr = 0
  FOR i = 1 TO NumberOfRows
	 CALL WriteVid(NumberOfCols, Dummy%, STRSEG(Text$), STRPTR(Text$),_
	STRSEG(Attr$), STRPTR(Attr$), SavePtr, _
		ScrnSegment, ScreenDisplacement + ((i - 1) * 80))
    SavePtr = SavePtr + NumberOfCols
  NEXT
END SUB 'WriteScreenArea


SUB WriteVid(N%, Dummy%, SegSource%, PtrSource%, SegScratr%, PtrScratr, _
	 StringDisp%, DestSeg%, Disp%) PUBLIC

	 Disp% = Disp% * 2
	 FOR i% = StringDisp% TO StringDisp% + N% -1
		  DEF SEG = SegSource%
		  t% = PEEK(PtrSource% + i)
		  DEF SEG = SegScratr
		  a% = PEEK(PtrScratr% + i)
		  DEF SEG = DestSeg%
		  POKE Disp%, t%
		  INCR Disp%
		  POKE Disp%, a%
		  INCR Disp%
	 NEXT i%
	 DEF SEG
END SUB											'SUB WriteVid


SUB ReadVid(N%, Dummy%, SegSource%, PtrSource%, SegScratr%, PtrScratr%, _
	 StringDisp%, DestSeg%, Disp%) PUBLIC

	 Disp% = Disp% * 2
	 FOR i% = StringDisp% TO StringDisp% + N% - 1
		  DEF SEG = DestSeg%
		  t% = PEEK(Disp%)
		  INCR Disp%
		  DEF SEG = SegSource%
		  POKE(PtrSource% + i%), t%
		  DEF SEG = DestSeg%
		  a% = PEEK(Disp%)
		  INCR Disp%
		  DEF SEG = SegScratr%
		  POKE (PtrScratr + i%), a%
	 NEXT i%
	 DEF SEG
END SUB											'SUB ReadVid



SUB GetVid(VidMode)
  '
  'Returns VidMode, the current video mode.
  '
  REG 1, &H0F00                     'AH = 15
  CALL INTERRUPT &H10               'video services
  VidMode = REG(1) AND &H00FF       'AL
END SUB 'GetVid



SUB SetVid(VidMode)
  '
  ' Sets the current video mode to VidMode.
  ' VidMode must be a valid video mode.
  '
  REG 1, VidMode                    'VidMode to AL, 0 to AH (service 0)
  CALL INTERRUPT &H10               'video services
END SUB 'SetVid



SUB CurSize(StartScan, EndScan)
  '
  ' Sets the cursor size thus:
  '   StartScan is the starting scan line.
  '   EndScan is the ending scan line.
  ' Important note: Cursor size will be implemented in next CurPos call.
  '
  REG 3, StartScan * &H100 + EndScan        'CH = StartScan, CL = EndScan
  REG 1, &H0100                             'AH = 1, set-cursor-size
  CALL INTERRUPT &H10                       'video services
END SUB 'CurSize



SUB CurPos(Row, Column)
  '
  ' Sets the cursor position in display page 0 at Row, Column position.
  ' Important note: Row and Column start with 0.
  '
  REG 4, Row * &H100 + Column               'DH = row, DL = column
  REG 2, 0                                  'BH = display page 0
  REG 1, &H0200                             'AH = 2 (service #)
  CALL INTERRUPT &H10                       'video services
END SUB 'CurPos

'ASM3A.BAS
DECLARE SUB GetStrLoc()


SUB QPrint(byval Ver%, byval Hor%, A$, byval Attr%)

!			push		ds			;save the good stuff
!			push		di			;because we're gonna destroy it
!			push		si
!			mov		ax,Ver%			;put the vertical position into ax
!			mov		dl,160			;put 160 into di
!			mul		dl			;multiply ax by 160
!			sub		ax,160			;subtract 160 from ax
!			push		ax			;save it
!			mov		ax,Hor%			;put horizontal position into ax
!			mov		dl,2			;put 2 into dl
!			mul		dl			;multiply ax by 2
!			mov		bx,ax			;put horizontal offset into bx
!			pop		ax			;put vertical into ax
!			add		ax,bx			;add them together
!			dec		ax
!			dec		ax			;and subtract 2
!			push		ax			;push the value
!			pop		di			;pop it into di register
!			mov		ax,&Hb800		;put video segment into ax
!			push		ax			;and push it
!			pop		es			;and pop it into es
!			lds		si,a$			;get the address in a$'s handle
!			mov		ax,ds:[si]		;put the handle into ax
!			push		ax			;push the handle
!			call		GetStrLoc		;find the location of the string
!			push		ax			;push the offset
!			push		dx			;push the segment
!			pop		ds			;pop the segment
!			pop		si			;pop the offset
!			mov		ah,Attr%		;the color attribute will be needed
forloop:
!			mov		al,ds:[si]		;get a character from the string
!			mov		es:[di],al		;poke the attribute into vidram
!			inc		di			;increment to the next vidram position
!			mov		es:[di],ah		;poke the attribute into vidram
!			inc		di
!			inc		si			;increment to the next string position
!			loop		forloop			;loop until cx = 0
!			pop		si			;restore the good stuff
!			pop		di
!			pop		ds

END SUB                                'SUB QPRINT



FUNCTION Attribute%(Foregrd, Backgrd, Intense, Blink)

	 Attribute% = (Blink * 128)+(Backgrd * 16)+(Intense * 8)+Foregrd

END FUNCTION		                     'FUNCTION Attribute



SUB DrawBox(topRow%, topCol%, numberRows%, numberCols%, filled%, border%, _
	 shadow%, title$, Attr%)

SELECT CASE border%
	 CASE 0
		  Box$ = "       "
	 CASE 2
		  Box$ = "ɻ ȼ"
	 CASE 3
		  Box$ = "ڿİ"
	 CASE 4
		  Box$ = "ɻͰȼ"
	 CASE 5
		  Box$ = "ڿı"
	 CASE 6
		  Box$ = "ɻͱȼ"
	 CASE 7
		  Box$ = "ڿĲ"
	 CASE 8
		  Box$ = "ɻͲȼ"
	 CASE ELSE
		  Box$ = "ڿ "
END SELECT

IF shadow% THEN
	IF numberRows% > 22 THEN numberRows% = 22
	IF numberCols% > 76 THEN numberCols% = 76
END IF

rightCol%  = topCol% + numberCols%
bottomRow% = topRow% + numberRows%
horizLength%=rightCol%-topCol%-1
horizLine$=STRING$(horizLength%,MID$(Box$,4,1))

IF shadow% THEN MakeShadow topRow%, topCol%, bottomRow%, rightCol%

QPRINT topRow%, topCol%, MID$(Box$,1,1) + horizLine$ + MID$(Box$,2,1), Attr%
QPRINT bottomRow%, topCol%, MID$(Box$,6,1) + horizLine$ + MID$(Box$,7,1), _
	 Attr%

FOR vertLine%=topRow%+1 TO bottomRow%-1
	IF filled% THEN
		QPRINT vertLine%, topCol%, MID$(Box$,3,1) + _
			 STRING$(horizLength%,MID$(Box$, 5, 1)), Attr%
		QPRINT vertLine%, rightCol%, MID$(Box$,3,1), Attr%
	ELSE
		QPRINT vertLine%, topCol%, MID$(Box$,3,1), Attr%
		QPRINT vertLine%, rightCol%, MID$(Box$,3,1), Attr%
	END IF
NEXT vertLine%

IF LEN(title$) <> 0  THEN
	 QPrint topRow%, (((rightCol% - topCol%) - LEN(title$))/2) + topCol%, _
	 title$, Attr%
END IF

END SUB							'Sub DrawBox


SUB Message(mString$, row%, shadow%, border%, filled%, title$, _
	 mStringAttr%, boxAttr%)

	lc%=((80-LEN(mString$))\2)-3
	rc%=80-lc%
	tc%=10:bc%=14

	DrawBox row%, lc%, 4, rc% - lc%, filled%, border%, _
	 shadow%, title$, boxAttr%
	QPRINT tc% + 2, lc% + 4, mString$, mStringAttr%

END SUB






SUB MakeShadow(topRow%, topCol%, bottomRow%, rightCol%)

horizLength%=(rightCol% + 2)-topCol%
ShadowAttr% = Attribute%(7, 0, 0, 0)

'FOR vertLine%=topRow%+1 TO bottomRow%+1
QFILL topRow% + 1, topCol% + 2, bottomRow% + 2, rightCol% + 3, 8, 0
'	QPRINT vertLine%, topCol% + 2, SPACE$(horizLength%), ShadowAttr%
'NEXT vertLine%

'COLOR fgColor%, bgColor%

END SUB										   'Sub MakeShadow


SUB CenterText (Row%, Col%, Wid%, Hgt%, Text$, Attr%)


CenterRow% = (Hgt% \ 2) + Row%
CheckText% = LEN(Text$)
CntrText%  = CheckText%\ 2
Cntr% = (Wid% + 2) \ 2 + Col%
StartCol% = Cntr% - CntrText%


QPRINT CenterRow%, StartCol%, Text$, Attr%

END SUB                                'Sub CenterText

SUB Slide

!			mov			cx,80
forloop1:
!			push			cx
!			mov			cx,1999		;the number of times to loop
!			mov			ax,&hb800	;the video segment
!			push			ax		;push the video segment
!			pop			es		;pop it to es
!			xor			di,di		;zero the di register
forloop2:
!			mov			ax,es:[di+2]	;get the character+attr from vidram
!			mov			es:[di],ax	;put it one position backwards
!			inc			di
!			inc			di
!			loop			forloop2	;loop 2000 times per screen
!			pop			cx
!			loop			forloop1	;loop 80 times

END SUB  							'SUB SLIDE


SUB LocateCursor(Row, Col, CursorOn, StartScan, EndScan)
  '
  ' For EGA compatibility, replaces the BASIC locate because BASIC gives an
  ' illegal function call if Row > 25.
  ' Any value which is -1 means that the value of the previous call is used.
  '
  STATIC Row1, Col1, CursorOn1, StartScan1, EndScan1
  IF Row       <> -1 THEN Row1       = Row
  IF Col       <> -1 THEN Col1       = Col
  IF CursorOn  <> -1 THEN CursorOn1  = CursorOn
  IF StartScan <> -1 THEN StartScan1 = StartScan
  IF EndScan   <> -1 THEN EndScan1   = EndScan
  IF Row1 = 0 THEN Row1 = 1
  IF Col1 = 0 THEN Col1 = 1
  CALL CurSize(StartScan1, EndScan1)
  IF CursorOn1 THEN                     'Cursor on:
    CALL CurPos(Row1 - 1, Col1 - 1)     '  Position on screen.
  ELSE                                  'Cursor off:
    CALL CurPos(43, Col1 - 1)           '  Position off screen.
  END IF
END SUB 'LocateCursor

SUB QFILL(byval WinTop%, byval WinLeft%, byval WinBottom%, byval WinRight%, byval Attr%, Byval FillChar%)

!	push	ds					;save the good stuff
!	push	di					;because we're gonna destroy it
!	push	si

!	mov	cx,WinBottom%	;calculate the number of times to iterate
!	sub	cx,WinTop%

!	mov	ax,WinTop%		;put top of window into AX
!	mov	dl,160			;put 160 into dl
!	mul	dl					;multiply ax by 160 (Mul only multiplies AX)
!	sub	ax,160 			;subtract 160 from ax
!	push	ax					;save it
!	mov	ax,WinLeft% 	;put top horizontal position into ax
!	mov	dl,2				;put 2 into dl
!	mul	dl					;multiply ax by 2 (mul only works on AX)
!	mov	bx,ax				;put horizontal offset into bx
!	pop	ax					;put vertical into ax
!	add	ax,bx				;add them together
!	dec	ax
!	dec	ax					;and subtract 2
!	push	ax					;push the value
!	pop	di					;pop it into di register
!	push	ax					;push it again for later <<<<<<<<<<<<<
								' we'll add 160 to it and iterate
!	mov	ax,&HB800 		;and put video segment into ax
!	push	ax					;and push it
!	pop	es					;and pop it into es

!	mov	bh,attr%			;the color attribute will be needed
!	mov	bl,fillchar%	;the character for filling
forloop1a:					'cx=number of lines.
!	push 	cx					;this is for looping how many lines
!       mov	cx,WinRight%    ;calc the width of the window to
!	sub	cx,WinLeft%		;find out how many times to iterate
forloop2a:					'a label for looping
!	cmp	bl,0				;is our fillchar 0?
!	je	doattr				;don't replace the screen char if it is
!	mov	es:[di],bl		;put the character into video ram
doattr:
!	inc	di					;increment the di pointer
!	cmp	bh,0           ;is the attribute 0?
!	je	noattr          	;don't change screen if it is
!	mov	es:[di],bh		;poke the attribute into vidram
noattr:
!	inc	di					;increment to the next vidram position
!	loop	forloop2a		;loop until cx=0
!	pop	cx             ;go to the next loop level
!	pop	ax					;get the original write position
!	add	ax,160			;add bytes to get the next screen line
!	push	ax					;push it
!	pop	di					;pop a new di pointer for the screen
!	push	ax					;push it back for later
!	loop	forloop1a      ;and iterate to the next

!	pop	ax					;clean up

!	pop	si					;restore the good stuff
!	pop	di
!	pop	ds

END SUB