;
; *** Listing 13-26 ***
;
; Replacement code for ClearHighBits in Listing 13-25.
; This version performs 64K rather than 0 repetitions
; when CX is 0.
;----------------------------------------------------------
; Clears the high bit of each byte in an array.
;
; Input:
;	BX = pointer to the start of the array to clear
;	CX = number of bytes to clear (0 means 64K)
;
; Output: none
;
; Registers altered: AX, BX, CX, DX
;
ClearHighBits:
;
; Calculate the offset in the partial in-line code to which
; to jump in order to perform CX modulo 4 repetitions (the
; remaining repetitions will be handled by full passes
; through the loop).
;
	dec	cx	;# of reps - 1, since 1 to 4
			; (rather than 0 to 3) repetitions
			; are performed on the first,
			; possibly partial pass through
			; the loop
			
	mov	ax,cx
	and	ax,3	;# of repetitions modulo 4
	inc	ax	;(# of reps modulo 4)+1 in order to
			; perform 1 to 4 repetitions on the
			; first, possibly partial pass
			; through the loop
	mov	dx,ax
	shl	ax,1
	add	ax,dx	;(((# of reps - 1) modulo 4)+1)*3
			; is the # of bytes from the
			; the end of the partial
			; in-line code to branch to
			; in order to handle the
			; # of repetitions that
			; must be handled in the
			; first, possibly partial
			; loop
	mov	dx,offset InLineBitClearEnd
	sub	dx,ax	;point back just enough
		     	; instruction bytes from
		     	; the end of the in-line
		     	; code to perform the
		     	; desired # of repetitions
	shr	cx,1 	;divide by 4, since we'll do
	shr	cx,1 	; 4 repetitions per loop
	inc	cx   	;account for the first,
		     	; possibly partial pass
		     	; through the loop
	mov	al,not 80h
			;pattern with which to clear
			; high bits
	jmp	dx	;finally, branch to perform
			; the desired # of repetitions
;
; Partial in-line code to clear the high bits of 4 bytes per
; pass through the loop.
;
ClearHighBitsLoop:
	rept	4
	and	[bx],al		;clear the high bit of this
				; byte
	inc	bx		;point to the next byte
	endm
InLineBitClearEnd:
	loop	ClearHighBitsLoop
	ret
