\ 128 line wide file viewer, requires EGA, good for viewing NEGA.C
\ Written by Tylisha C. Andersen

O           equ <offset>;
B           equ <byte ptr>;
W           equ <word ptr>;

.model tiny;
.186;

\---------------------------------------------------------------------
.data;

fontcomp    equ   this byte;
    dw 0,0,35584,47779,53757,49147,50525,20703,62015,56,15904,14562;
    dw 29440,63423,16,7537,4343,0,8,16,63487,61439,255,59156,40,60415;
    dw 55064,6655,23256,2128,40331,4119,19204,62672,4128,53835,9461;
    dw 21520,17782,4368,15812,28876,12304,58300,568,2417,31991,20996;
    dw 41108,2600,56235,37970,18693,18836,3088,0,14343,28942,63241,58495;
    dw 2417,4338,8452,18184,1148,15904,2082,8192,33342,32,8192,16399;
    dw 0,41022,40,7200,47183,63519,61981,1080,0,0,16896,32784,2080,421;
    dw 64,20992,62869,2684,6513,2062,8,1060,4624,11426,20618,8458,32768;
    dw 0,8513,16388,17412,17416,4112,15504,12489,8192,16958,16,0,256;
    dw 4,60,0,0,0,4104,17416,4128,11667,26665,49676,33808,7200,2195;
    dw 8233,37662,10520,3080,48977,2081,34562,51589,3080,14723,18441;
    dw 5900,9352,2064,6547,18473,37644,8477,3080,64,4,8192,512,2048;
    dw 40992,8322,2,57345,120,1092,4164,37648,8200,1040,11667,22568;
    dw 37644,10557,4680,14743,18473,37660,2337,3136,9623,18473,34588;
    dw 2233,7744,47495,16392,37648,2349,3144,48532,18473,18194,33808;
    dw 7200,33809,18473,37900,18865,4688,8580,16392,62494,10661,4680;
    dw 42452,18537,37650,10533,3144,14743,16424,37648,9765,1624,14743;
    dw 18473,37650,2329,3080,51239,4162,37892,10661,3144,42388,18474;
    dw 37896,12197,4680,39316,18473,37906,8857,1040,34839,8232,34590;
    dw 2081,7232,4224,4226,9986,16904,7184,147,0,0,0,7680,66,64,0,51460;
    dw 3640,9604,18633,28,51492,3136,42000,18665,14,51236,3192,14417;
    dw 8324,8,59172,33353,9604,18633,530,33809,7200,33792,2401,33938;
    dw 10793,4704,4166,8324,28,10557,4680,9472,18633,18,51492,3144,9472;
    dw 19150,16,59172,16968,9472,16584,16,57632,7216,4418,8388,4,10533;
    dw 3656,9472,18474,8,12069,4680,9472,12329,18,10021,33353,1280,4324;
    dw 16670,33824,1056,66,8324,17416,33800,4128,16563,0,0,18708,7752;
    dw 41347,16647,1156,10661,3656,41985,30920,1804,51588,3640,33796;
    dw 14537,1550,51460,3640,1027,14537,14,59168,33857,41991,30920,1036;
    dw 51364,3192,9222,30920,524,49800,3600,34823,4290,1550,49672,3600;
    dw 41988,30921,25362,51492,4728,41217,28904,30,64009,8060,48547;
    dw 20554,1814,51620,3144,41988,18633,1548,51492,3144,42247,18473;
    dw 1550,10533,3656,42244,19239,1154,59813,7752,42244,18473,8478;
    dw 59168,33856,14417,41092,21534,18268,1040,9623,23753,10257,17052;
    dw 5137,33793,14537,270,49800,3600,41985,18633,268,10661,3656,47266;
    dw 18441,41490,2980,4712,40017,96,20736,16412,0,4098,16521,12,2108;
    dw 64,15360,2049,37888,16661,1860,5012,52291,257,16904,1040,10280;
    dw 43170,40960,43530,40,658,4233,27684,9371,14041,30395,47067,8557;
    dw 16904,33808,2081,28738,8580,49673,33904,37970,27045,74,1280,19065;
    dw 2304,28866,21124,42373,19049,37970,10661,74,58629,19049,34130;
    dw 30880,20992,41108,120,2337,28864,0,512,33904,2081,7232,8448,16392;
    dw 124,0,31746,8580,16904,33820,0,31744,8448,16904,33916,2081,7282;
    dw 21124,42388,18989,36946,15536,0,62736,18989,33106,31920,0,62721;
    dw 19053,36946,11701,74,61441,124,33106,28085,8522,61441,124,37970;
    dw 31904,0,61953,33916,0,32005,21066,41108,60,2081,7280,0,29192;
    dw 33820,0,15621,21066,42388,19069,2337,31986,8580,16392,112,0,7170;
    dw 65412,65535,65535,0,65295,59391,52793,40051,52793,40051,65511,61695;
    dw 0,9544,55396,57344,10553,5194,8688,16424,16,62741,2600,34967,8329;
    dw 30,63012,72,4608,9879,8,41512,2064,9456,18630,24606,10557,3144,9072;
    dw 10261,12315,35080,3176,10752,21735,4096,59178,2132,14704,16392;
    dw 24590,10533,4680,15600,15,8448,61449,7952,6244,16416,24606,153;
    dw 7688,34856,4178,8580,18952,2128,15904,2,20480,18945,40,2129,160;
    dw 0,8,16,0,4096,8448,18152,3152,5216,160,4864,16412,0,7168,14567;
    dw 0,0,0;

\---------------------------------------------------------------------

nomem$      db    'not enough memory to load',          13, 10, '$';
syntax$     db    'syntax:  VIEW <file>',               13, 10, '$';
notfound$   db    'file not found',                     13, 10, '$';
null_str    db    0;

\---------------------------------------------------------------------
.data?;

font        db    2048 dup(?);      \ the font buffer

max_lines   dw    ?;                \ maximum number of lines to load
num_lines   dw    ?;                \ number of lines in file
first_line  dw    ?;                \ pointer to first line

buf_size    equ   8192;             \ buffer size

            db    2 dup(?);         \ spaces to precede filename
filename    db    128 dup(?);       \ file name
buffer      db    buf_size dup(?);  \ disk buffer

handle      dw    ?;                \ file handle
buffer_pos  dw    ?;                \ position in buffer
buffer_end  dw    ?;                \ end of data in buffer

\---------------------------------------------------------------------
.code;
org 100h;

start:      .main;

\---------------------------------------------------------------------
\ exit conditions from main
\---------------------------------------------------------------------

m_error:                            \ print out string & exit to DOS
    ah = 9; !21h; ax = 4C00h; !21h;

m_nomem:                            \ not enough memory
    dx = O(nomem$); .m_error;
m_syntax:                           \ syntax error
    dx = O(syntax$); .m_error;
m_notfound:                         \ file not found
    dx = O(notfound$); .m_error;

\---------------------------------------------------------------------
\ main - main procedure
\---------------------------------------------------------------------

main:
    sp = O(stack_top);              \ set new stack position

    bx = O(stack_top+15) > 4;       \ shrink memory to minimum
    ah = 4Ah; !21h; <<m_nomem;

    ah = 48h; bx = (-1); !21h;      \ allocate all free memory
    ah = 48h; !21h;

    first_line = ax;                \ set first line segment
    bx > 3 - 40; <=m_nomem;         \ get max line count
    max_lines = bx;                 \ set max line count

    cx === [bx+39];                 \ cx = total line count

    {                               \ for each line,
        es = ax; B es:[0] = 0;      \ set it to a null-string
        ax + 8;                     \ next line
    }-.;                            \ loop

\-----------------------------------------------------------

    =ds; es=;                       \ es = ds;
    cl = ds:[80h]; &ch; cx+;        \ cx = command line length

    di = 81h; al = ' '; == *-?;     \ find first non-space
    si === [di-1];                  \ si = pointer to filename
    B [si] - 0Dh? ==m_syntax;       \ no file specified?

    <> *-?; b [di-1] = 0;           \ find next space, add null

    di = O(filename);               \ di = filename buffer
    ah = 60h; !21h;                 \ convert to full path

    W [filename-2] = 2020h;         \ set preceding bytes to spaces

\-----------------------------------------------------------

    dx = O(filename); ax = 3D00h;   \ open file
    !21h; <<m_notfound;
    handle = ax;                    \ save handle

    bp = first_line;                \ bp = segment of first line

    ax = buf_size;                  \ init buffer variables
    buffer_pos = ax; buffer_end = ax;
    num_lines = 0;                  \ line counter = 0

    {
        es = bp; &di;               \ es:di = line
        cx = 127;                   \ 127 max. chars

        {
            =.getchar; <<;          \ get character
            al - 13? ==;            \ cr = done with line
            al - 10?                \ check for line feed
            <>{                     \ if not a line feed, then
                ?==;                \ maxed out, don't store
                *=; cx-;            \ store char, dec maximum
            };
        }.;                         \ loop

        al = 0; *=;                 \ add null-terminator
                                    \ doesn't affect flags
        num_lines+; <<;             \ increment line counter, jump if EOF

        bp + 8;                     \ next line
        ax = num_lines - max_lines? \ too many lines?
    }<<;                            \ loop if not

\-----------------------------------------------------------

    bx = handle; ah = 3Eh; !21h;    \ close the file

    =ds; es=;                       \ es = ds

    si = O(fontcomp); di = O(font); \ si = compressed font, di = font buffer
    bp = 256;                       \ bp = size

    .{                              \ skip this block
m_decstore:
        al > 3; ax & 1F1Fh;         \ shift al and mask to 5 bits
        **=; .=;                    \ store 2 bytes and return
    };

    {                               \ for each of 256 chars:
        =**; bx == ax;              \ bl:bh:cl:ch:dl = 5 byte font char
        =**; cx == ax;              \ 8 x 5 bits per line
        =*;  dx == ax;

        ah = bl; al = bh; ax > 3;   \ ax = bytes 0 and 1
        =.m_decstore;               \ store bytes 0 and 1
        ah = bh; al = cl; ax > 1;   \ ax = bytes 2 and 3
        =.m_decstore;               \ store bytes 2 and 3
        ah = cl; al = ch; ax < 1;   \ ax = bytes 4 and 5
        =.m_decstore;               \ store bytes 4 and 5
        ah = ch; al = dl; ax < 3;   \ ax = bytes 6 and 7
        =.m_decstore;               \ store bytes 6 and 7

        bp-;                        \ loop
    }<>;

\---------------------------------------------------------------------
\ main key loop handling starts here
\---------------------------------------------------------------------

    ax = 10h; !10h;                 \ set video mode 10h (640x350)

    si = O(null_str); al = (-1);    \ clear line 42 to white
    dx = 42; =.putline;             \ al = -1 = reverse video

    si = O(filename-2);             \ put filename in title line
    dx = (-1); =.putline;           \ dx = -1 = title line

    bp = (-1); =.k_home;            \ jump to 'home' key

\-----------------------------------------------------------

m_done:                             \ restore video mode, exit to DOS
    ax = 3; !10h; ax = 4C00h; !21h;

\-----------------------------------------------------------

k_keyloop:
    &ah; !16h; ah - 01h? ==m_done;  \ wait for a key, quit if ESC

    ah - 48h? ==k_up;               \ key UP?
    ah - 50h? ==k_down;             \ key DOWN?
    ah - 49h? ==k_pgup;             \ key PGUP?
    ah - 51h? ==k_pgdn;             \ key PGDN?
    ah - 47h? ==k_home;             \ key HOME?
    ah - 4Fh? ==k_end;              \ key END?

    .k_keyloop;                     \ invalid key, loop

\-----------------------------------------------------------

k_up:
    bp? ==k_keyloop;                \ already at top?
    =.scrolldn; bp-;                \ scroll screen down (move up)

    ax = bp * 8 + first_line;       \ ax = first line of screen
    es = ax; &si;                   \ es:si = line
    dx = 2; &al; =.putline;         \ display on top line (2)
    .k_keyloop;                     \ loop

\-----------------------------------------------------------

k_down:
    ax = num_lines--;               \ ax = max line position
    bp - ax? >=k_keyloop;           \ already at bottom?
    =.scrollup; bp+;                \ scroll screen up (move down)

    ax = bp * 8 + first_line;       \ ax = last line of screen
    ax + (39*8); es = ax; &si;      \ es:si = line

    dx = 41; &al; =.putline;        \ display on bottom line (41)
    .k_keyloop;                     \ loop

\-----------------------------------------------------------

k_pgup:
    bp? ==k_keyjmp;                 \ already at top?
    bp - 40; <<{ &bp; }; .k_redraw; \ move up 40 lines and redraw

\-----------------------------------------------------------

k_pgdn:
    ax = num_lines - 41;            \ ax = max line position - 41
    bp - ax? >=k_keyjmp;            \ already at bottom?
    bp + 40; .k_redraw;             \ move down 40 lines and redraw

\-----------------------------------------------------------

k_home:
    bp? ==k_keyjmp;                 \ already at top?
    &bp; .k_redraw;                 \ move to top and redraw

\-----------------------------------------------------------

k_end:
    ax = num_lines - 40;            \ ax = max line position - 40
    bp - ax? >>k_keyjmp;            \ already at bottom?
    bp = ax; .k_redraw;             \ move to end and redraw

\-----------------------------------------------------------

k_redraw:
    di = bp * 8 + first_line;       \ di = first line of screen

    dx = 2; &si; &al;               \ first line is line 2, white on black

    cx = 40;                        \ for each of 40 lines:
    {
        es = di; =.putline;         \ es = line, display line
        di + 8; dx+;                \ next line
    }-.;                            \ loop

k_keyjmp:                           \ jump to key loop
    ..k_keyloop;

\---------------------------------------------------------------------
\ getchar - read one character from the file, buffered
\---------------------------------------------------------------------
\ in:  assumes ds = cs
\ out: al = character, carry = EOF

getchar:
    pusha;                          \ save registers

    si = buffer_pos - buffer_end?   \ si = position in buffer
    >>={                            \ if end of buffer, then
        si - buf_size? <<g_done;    \ buffer not full = EOF (jb = jc)

        ah = 3Fh; bx = handle;      \ try to read in next buffer
        cx = buf_size; dx = O(buffer);
        !21h; <<g_done;             \ carry = EOF

        buffer_end = ax;            \ set end position
        &si; buffer_pos = si;       \ set buffer position
    };

    al = buffer[si];                \ load byte
    buffer_pos+; &;                 \ inc buffer pos, clear carry flag

g_done:
    bp = sp; [bp+14] = al;          \ set al value on return
    popa; .=;                       \ restore registers

\---------------------------------------------------------------------
\ putline - put a line of text on the screen
\---------------------------------------------------------------------
\ in:  es:si = string, dx = y-position, al = xor byte (0 or -1)
\      y-position -1 = draw the title line

putline:
    pusha; =ds =es;                 \ save all registers
    =es; ds=;                       \ ds:si = string
    =0A000h; es=;                   \ es = video memory

    dx * 640; di = dx;              \ dx, di = offset
    cx = (640/2);                   \ cx = size of 8 scanlines
    ah = al;                        \ ax = xor-value
    dx? <{                          \ if dx was negative, then
        dx = 240; &di;              \ use title position & larger size
        cx = (1120/2);              \ for a 3-line border on each side
    };

    <> **=;                         \ clear the line
    di = dx;                        \ di = offset

    bp = ax; &bx;                   \ bp = xor value, zero bx

    {
        =si =di;                    \ save si, di
        &dx; cl = 11;               \ clear bit buffer, shift = 11 (16 - 5)

        {
            =*; al? ==;             \ load byte, break if null
            &ah; ax < 3; bx + ax;   \ bx = font byte pointer
            ch = cs:font[bx];       \ ch = font byte
            bx - ax;                \ fix bx

            al = ch; &ah;           \ ax = font byte
            ax < cl; dx | ax;       \ shift and or into bit buffer

            cl - 5;                 \ adjust shift value
            <<{                     \ if bit buffer full, then
                al = dh; dx < 8;    \ shift 8 bits out of the bit buffer
                cl + 8;             \ into al, and adjust the shift value
                ax ^ bp; *=;        \ xor and write to video memory
            };
        }.;                         \ loop

                                    \ flush bit buffer:
        al = dh; ah = dl;           \ ax = dx (bytes reversed)
        ax ^ bp; **=;               \ xor and write to video memory

        si= di=;                    \ restore si, di
        di + 80;                    \ next scanline on screen
        bx+; bx - 8?                \ increment line counter
    }<<;                            \ loop while not done

    ds= es=; popa; .=;              \ restore registers and return

\---------------------------------------------------------------------
\ scrolldn - scroll all but the top 2 & bottom 1 lines down by 1 line
\---------------------------------------------------------------------

scrolldn:
    pusha; =ds =es;                 \ save all registers
    ds = es = ax = 0A000h;          \ ds, es = video memory
    -;                              \ moves are backwards

    si = (2*640+24960-2);           \ scroll the screen down
    di = (3*640+24960-2);
    cx = (24960/2); <> **=**;

    +;                              \ fix direction flag
    ds= es=; popa; .=;              \ restore registers and return

\---------------------------------------------------------------------
\ scrollup - scroll all but the top 2 & bottom 1 lines up by 1 line
\---------------------------------------------------------------------

scrollup:
    pusha; =ds =es;                 \ save all registers
    ds = es = ax = 0A000h;          \ ds, es = video memory

    si = (3*640); di = (2*640);     \ scroll the screen up
    cx = (24960/2); <> **=**;

    ds= es=; popa; .=;              \ restore registers and return

\---------------------------------------------------------------------
.data?;

stack_buf   db    1024 dup(?);      \ stack buffer
stack_top:
    
end start;
