;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Keyboard Handler 1.0 for real mode.
;   Port of Tran's Excellent PMODE 2.4 Keyboard Handler.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;

                .286p
                .model medium, pascal
                jumps

                .code

;
;   Definitions
;


pint    equ     09h                             ; patch interrupt


;
;   kbinit() - initialize keyboard interrupts
;   pass:       nothing
;   returns:    nothing
;

                public kbinit

kbinit          proc pascal
                push ds es

                mov al,pint                     ; interrupt to patch
                mov ah,35h                      ; get interrupt address
                int 21h
                mov word ptr oldvct,bx          ; save it
                mov word ptr oldvct[2],es

                mov al,pint                     ; interrupt to patch
                mov ah,25h
                mov bx,seg kbhandler
                mov ds,bx
                mov dx,offset kbhandler
                int 21h                         ; install our handler

                pop es ds
                ret
kbinit          endp


;
;   kbdnit() - de-initialize keyboard interrupts
;   pass:       nothing
;   returns:    nothing
;

                public kbdnit

kbdnit          proc pascal
                push ds

                mov dx,word ptr oldvct          ; get old interrupt address
                mov ax,word ptr oldvct[2]
                mov ds,ax
                mov al,pint                     ; interrupt to patch
                mov ah,25h
                int 21h                         ; restore old interrupt

                pop ds
                ret
kbdnit          endp


;
;   kbget() - wait for keystroke, return scan code
;   pass:       nothing
;   returns:    al - scan code of last key pressed
;               ah - shift state bits: 0=SHIFT, 1=ALT, 2=CTRL
;

                public kbget

kbget           proc pascal
kbgetwait:
                cmp cs:kbhit,0
                je kbgetwait
                mov cs:kbhit,0
                mov ax,word ptr cs:kbchar
                ret
kbget           endp


;
;   kbgetn() - return scan code of last key pressed
;   pass:       nothing
;   returns:    al - scan code of last key pressed
;               ah - shift state bits: 0=SHIFT, 1=ALT, 2=CTRL
;

                public kbgetn

kbgetn          proc pascal
                mov al,0
                cmp cs:kbhit,0
                je kbgetnd
                mov cs:kbhit,0
                mov ax,word ptr cs:kbchar
kbgetnd:
                ret
kbgetn          endp


;
;
;   replacement interrupt handler
;
;

kbhandler       proc far
                ;sti                             ; enable interrupts
                pushf
                push ax bx ds                   ; save registers

                mov ax,seg kbhandler
                mov ds,ax                       ; setup data segment

                mov ah,0
                in al,60h                       ; get scan code
                mov bx,ax                       ; save it
                mov al,1                        ; assume key on
                test bx,80h                     ; key pressed?
                jz kbhand1                      ; yes, skip
                mov al,0                        ; else key released
kbhand1:
                and bx,7fh                      ; make index into key table
                mov kbtbl0[bx],al               ; set / clear in key table
                or al,al                        ; any key?
                jz new_intd                     ; no, quit
                mov ah,kbtbl0[2ah]
                or ah,kbtbl0[36h]               ; or shift key statuses
                mov bh,ah
                shl bh,7                        ; move to translation position
                add bl,bh                       ; add translation amount
                and bx,0ffh
                mov al,kbxtbl[bx]               ; get translated key
                or al,al                        ; is supported?
                jz new_intd                     ; no, quit
                mov kbchar,al                   ; otherwise store character
                mov kbhit,1                     ; indicate key pressed
                mov al,kbtbl0[1dh]              ; get control status
                shl al,1
                or al,kbtbl0[38h]               ;   and alt status
                shl al,1
                or al,ah                        ;   and shift status
                mov kbshift,al                  ; save control keys state

new_intd:
                ;cli
                mov al,20h                      ; send End-Of-Interrupt signal
                out 20h,al                      ; to the 8259 Int. Controller
                pop ds bx ax
                popf
                ;cli
                sti
                iret
kbhandler       endp


;
;
;   DATA (STORED IN CODE SEGMENT)
;
;

oldvct          dd ?                            ; old interrupt handler

kbtbl0          db  80h dup(0)                  ; non-sticky keyboard table
kbchar          db  0                           ; last key that was hit
kbshift         db  0                           ; shift states for last key
kbhit           db  0                           ; 0=no key hit, 1=key available

kbxtbl          db  0,14,'1234567890-=',16,15,'qwertyuiop[]',13,0
                db  'asdfghjkl;''`',0,'\zxcvbnm,./',0,'*',0,32,0f6h
                db  1,2,3,4,5,6,7,8,9,10,0f3h,0,19,25,21,'-',23,'5'
                db  24,'+',20,26,22,17,18,0,0,0,11,12,27h dup(0)
                db  0,14,'!@#$%^&*()_+',16,15,'QWERTYUIOP{}',13,0
                db  'ASDFGHJKL:"~',0,'|ZXCVBNM<>?',0,'*',0,32,0f6h
                db  1,2,3,4,5,6,7,8,9,10,0f3h,0,19,25,21,'-',23,'5'
                db  24,'+',20,26,22,17,18,0,0,0,11,12,27h dup(0)

                end

