; Sierpinski Triangle  - by Tylisha C. Andersen

Ideal
Model Tiny
Codeseg
P186
Org 100h

start:      mov   al, 12h           ; set video mode 12h
            int   10h
            mov   di, 3             ; set di = 3 (tricky)

loop1:      imul  bp, 9421          ; generate random number
            inc   bp
            mov   ax, bp            ; dx:ax = bp
            xor   dx, dx
            div   di                ; divide by 3
            dec   dx                ; check result
            jz    p2
            jns   p1

            add   si, 480           ; move to bottom part
            sub   cx, 320

p1:         add   cx, 640           ; move to right part

p2:         shr   cx, 1             ; shrink by 2
            shr   si, 1

            mov   ax, 0C0Fh         ; put pixel, in white
            mov   dx, si
            int   10h

            mov   ah, 1             ; check for key, loop
            int   16h
            jz    loop1

            xchg  ax, di            ; set video mode 3
            int   10h               ; remember, di = 3
            ret

End Start


