comment %

Routine to convert a null-terminated decimal string to register value.
Donated to the public domain by the author, Mikko Hyvarinen (2:229/229.5).

%
.386
jumps
locals

cseg segment para use16 public 'code'
assume cs:cseg, ds:cseg, ss:cseg

org 100h

main:
    push cs
    pop ds
    xor esi, esi
    mov si, offset test1
    call dec2reg
    ; now we have that value in eax. you can verify that by single-stepping
    ; the code in your debugger
    mov ax, 4c00h
    int 21h

dec2reg proc near
    ; input:
    ;   ds:esi = pointer to string
    ; output:
    ;   eax = value
    xor eax, eax
    push ebx esi
@@begin:
    xor ebx, ebx
    mov bl, byte ptr [esi]
    or bl, bl
    jz @@end
    sub bl, '0'
    add eax, ebx
@@loop:
    inc esi
    xor ebx, ebx
    mov bl, byte ptr [esi]
    or bl, bl
    jz @@end
    lea eax, [eax+4*eax]
    sub bl, '0'
    shl eax, 1
    add eax, ebx
    jmp @@loop
@@end:
    pop esi ebx
    ret
dec2reg endp

test1 db '145', 0

cseg ends

end main
