; PUSHPOP.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	pushpos, poppos, sub_push, add_push
extrn	locate:near, rowcount:near

include	dataseg.inc
extrn	rows:byte
extrn	push_mode:byte
extrn	cursor:dword
extrn	push_offset:dword
extrn	dirty_bits:byte
extrn	file_row:dword
extrn	count_start:dword
count_bytes	equ	dword ptr count_start+4
@curseg	ends

include	codeseg.inc
pushpos	proc	near
	mov	eax,cursor
	mov	push_offset,eax
	mov	push_mode,0FFh
	ret
pushpos	endp

poppos	proc	near
	cmp	push_mode,0
	je	short exit
	xor	eax,eax
	mov	count_start,eax
	inc	eax
	mov	file_row,eax
	mov	eax,push_offset
	mov	count_bytes,eax
	mov	cursor,eax

	mov	dh,rows
	shr	dh,1			; move cursor to middle of screen
	mov	esi,eax
	call	locate			; compute new top_of_screen
	or	dirty_bits,00100001b	; redraw top line & screen
	call	rowcount

exit:	clc
	ret
poppos	endp

sub_push	proc	near
	cmp	push_mode,0
	je	short no_push
	push	eax
	push	ecx
	mov	ecx,eax		; bytes to be deleted
	mov	eax,cursor

; no action if position in file > push_offset
	cmp	eax,push_offset
	ja	short adjust_done

; determine if saved position is to be deleted
; need push_offset > last character deleted
	add	eax,ecx		; EAX = offset of last char deleted
	dec	eax
	cmp	eax,push_offset
	cmc
	adc	push_mode,0	; turn push_mode off
	sub	push_offset,ecx

adjust_done:
	pop	ecx
	pop	eax
no_push:
	ret
sub_push	endp

add_push	proc	near
	cmp	push_mode,0
	je	no_push
	push	eax
	push	ecx
	mov	ecx,eax
	mov	eax,cursor

; no action if position in file > push_offset
	cmp	eax,push_offset
	ja	adjust_done

	add	push_offset,ecx
	jmp	adjust_done

add_push	endp

@curseg	ends
	end
