; LOAD.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; This subroutine prompts for a new filename.  If the
; file exists, it replaces the previous file in the buffer.

include	model.inc

public	load, edit_filename
extrn	qfname:near, tprintce:near
extrn	strchr:near
extrn	strnchr:near, tedit:near
extrn	clearkey:near, getkey:near
extrn	pickfile:near, $tpick:near
extrn	strrchr:near
extrn	error:near

extrn	new:near
extrn	readfile:near
extrn	yesno_message:near

temp_filename	equ	byte ptr [ebp-64]

include	dataseg.inc
extrn	filename:dword
extrn	dirty_bits:byte, rows:byte, warning:byte, inverse:byte
extrn	verify_msg:byte, key_status:byte
load_mess	db ' Load: ',0
load_len	equ $-load_mess-1
no_match	db 'no matching files',0
@curseg	ends

include	codeseg.inc
load	proc	near
	enter	64,0
	cld
	mov	esi,filename		; point to existing filename

; copy filename to temporary buffer
l0:	lea	edi,temp_filename
	push	ss
	pop	es
	mov	ecx,64/4
	rep	movsd

	test	dirty_bits,10000000b	; has the file has been changed?
	jz	short l1
	mov	ah,warning
	lea	esi,verify_msg
	call	yesno_message
	cmp	al,'N'
	je	exit

l1:
prompt_for_load:
	mov	esi,offset load_mess
	call	edit_filename
	cmp	ax,27			; Esc key?
	je	exit

; qualify the filename
l2:	mov	ebx,esi		; DS:[EBX] points to filename
	call	qfname
	mov	edi,ebx
	push	ds
	pop	es
	cld
	rep	movsb		; copy qualified filename to buffer
	mov	al,cl
	stosb

; look for wildcard characters
	lea	ebx,temp_filename	; DS:[EBX] points to filename
	mov	al,'?'		; look for wildcard characters
	call	strchr		; returns with CX = string length
	jnc	short load01	; if CF = 0, found the '?' character
	mov	al,'*'		;  else look for '*'
	call	strnchr
	jc	short load02		; no wildcards if CF = 1
load01:
; print qualified filespec
	mov	esi,ebx
	mov	dh,rows
	inc	dh
	mov	dl,load_len
	mov	ah,inverse
	call	tprintce
	call	wildfile
	cmp	ax,0Dh
	jne	prompt_for_load	; continue if Enter pressed

load02:
	and	dirty_bits,01111111b
	mov	ebx,filename
	push	dword ptr [ebx]
	call	new
	mov	ebx,filename
	pop	dword ptr [ebx]
	lea	edx,temp_filename
	call	readfile
	jc	l1		; ask for new filename if error

; copy temporary filename to file buffer
	mov	edi,filename
	lea	esi,temp_filename
	push	ds
	push	ds
	pop	es		; ES:[EDI] -> filename buffer
	push	ss
	pop	ds		; DS:[ESI] -> temporary buffer
	mov	ecx,64/4
	rep	movsd
	pop	ds
	or	dirty_bits,1
exit:
	clc
	leave
	ret

load	endp

edit_filename:
	mov	key_status,0FFh	; guarantee prompt redraw
	mov	dh,rows
	inc	dh		; last row of screen
	xor	dl,dl
	mov	ah,inverse
	call	tprintce	; print prompt string
	add	dl,cl
	lea	esi,temp_filename
	mov	ecx,63
	mov	al,ch		; zero
	call	tedit
	ret

wildfile	proc	near
	push	ebx
	push	edx
	push	es
	mov	esi,ebx			; [ESI] points to filespec mask
	mov	edi,ebx

; look for path spec
	mov	al,'\'
	call	strrchr
	jc	short w0		; no path spec
	add	edi,eax			; point to '\'
	inc	edi			; point past '\'

w0:
	mov	ecx,16
	mov	dx,0320h
	xor	ebx,ebx
	lea	eax,$tpick
	call	pickfile
	jc	short w1
	cmp	ax,27		; Esc?
	je	short w9
	mov	esi,ebx
	cld
	push	ds
	pop	es
	rep	movsb
	push	eax
	mov	al,cl
	stosb			; tack on a terminal NUL
	pop	eax

; release buffer
w9:	push	eax
	mov	esi,ebx
	sys	RelMemNear
	pop	eax

wexit:
	pop	es
	pop	edx
	pop	ebx
	ret
wildfile	endp

w1:
	lea	edx,no_match
	call	error
	jmp	wexit

@curseg	ends
	end
