; DEL_CHAR.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; This deletes the character at the cursor
; by shifting the remainimg characters forward

include	model.inc

public	del_char, save_char
extrn	display_bottom:near
extrn	sub_push:near

CR	equ	0Dh
LF	equ	0Ah

include	dataseg.inc
extrn	filesiz:dword, cursor:dword
extrn	dirty_bits:byte
extrn	cur_posn:word, save_column:byte

extrn	undo_length:dword
extrn	undo_buffer:dword
@curseg	ends

include	codeseg.inc
del_char	proc	near
	cld
	push	es
	mov	ecx,filesiz
	mov	esi,cursor
	mov	edi,esi
	cmp	esi,ecx		; are we at the end of the file?
	jae	short no_del	; if yes, then don't delete

	push	ds
	push	fs
	pop	ds
	lodsb
	pop	ds

	call	save_char	; save it for UNDO function

; don't get next character if at end of buffer
; will cause exception if deleting last character in buffer
	cmp	esi,filesiz
	jae	short shorten_file

	push	fs
	pop	es
	mov	ah,es:[esi]	; look at the next character also
shorten_file:
	push	eax		; save character we're deleting
	dec	filesiz		; shorten the file by one
	sub	ecx,esi

	push	ds
	push	fs
	pop	ds
	rep	movsb		; move the file down one notch
	pop	ds

	mov	eax,1
	call	sub_push	; adjust push offset if nessesary
	pop	eax		; get the character back we deleted
	cmp	al,cr		; did we delete a CR?
	je	short combine
	or	dirty_bits,11000100b
				; current line is dirty
no_del:	clc
	pop	es
	ret

combine:cmp	ah,lf		; is the next char LF?
	jne	short no_del_lf
	call	del_char	; delete the line feed
no_del_LF:
	call	display_bottom	; repaint bottom of screen
	mov	dx,cur_posn
	mov	save_column,dl	; save the cursor column
	clc
	pop	es
	ret

del_char	endp

; add a character to the undo buffer

save_char:
	mov	ebx,undo_length
	cmp	ebx,128
	jae	short no_save	; no room
	inc	undo_length	; one more saved character
	add	ebx,undo_buffer	; add offset of buffer
	mov	[ebx],al
no_save:
	ret

@curseg	ends


; UNDO
;
;  restores any characters which have recently been deleted

public	undo
extrn	insert_string:near

include	codeseg.inc
undo	proc	near
	xor	eax,eax
	xchg	eax,undo_length		; get buffer length
	test	eax,eax
	jz	short exit
	mov	esi,undo_buffer		; address of undo buffer
	call	insert_string
exit:	clc
	ret
undo	endp

@curseg	ends
	end
