':*********************************** ':* PROGRAM CHASM    Version 2.01   * 
$':*                                 * 9
.':* CHeap ASseMbler for the IBM PC. * d
8':*                                 * 
B':* Begun 6/15/82 by Dave Whitman   * 
L':*********************************** 
V': 
`':main program 
j'    P   :initialize t'  :wipe out transient code =~'    "chasm.ovl",',ALL, Pr _'   M   :set up sym table '   '   :pass 1: build sym table '   (   :pass 2: generate obj code & listing '   "L   :clean up ' ':******************************************* D':* SUBROUTINE PASSONE                      * w':* Adds user-defined symbols to sym table. * ':******************************************* ': 'PASS   'LOCTR      :0-255 reserved for p.s. prefix  (LINENUM   
(  () 6( :get source line, initialize P(    |)   :getline a(( :parse it x2(    )  :parse <( :if label, enter in sym table F(    LABEL$  ""   x-  :newentry P( :if op, decode, & update loctr Z(    OP$  ""   0   :update_loctr 3d( :progress report @n(    M Gx(  M( v(:********************************* (:* SUBROUTINE PASSTWO            * (:* Generates obj code & listing. * (:********************************* (: ( K  :pass2_init (: )(  () M( :get source line, initialize g(    |)   :getline z( :parse line (    )   :parse ) :phase error? )    LABEL$  ""   .  :check_phase ) :if op, update loctr, generate obj. code 2")    OP$  ""   0   :update_loctr Z,) :output obj. code & listing line r6)    LJ  :output @) :progess report J)    M T)  ^):wipe out msg h)  X  (): Y  :  ,:  O):  Y,X r) |):******************************************** M):* SUBROUTINE GETLINE                       * ):* Gets line of source code for processing. * ):* and initializes for new iteration.       * ):******************************************** ): ) #, INPLINE$ )LINENUM  LINENUM   E)NEEDOFFSET  NONE: DSFLAG  FALSE T)OBJLEN   Z) ):***************************************************** ):* SUBROUTINE PARSE                                  * ):* Parses input line for any label, op, or operands. * N*:***************************************************** V*: t*LINEPTR  : LINEPTR2   &*LABEL$  "": OP$  "": SOURCE$  "": DEST$  "" 0*: :*:set endptr to end of code D*  ENDPTR  (INPLINE$,";")              :just before comment ]N*   ENDPTR    ENDPTR  (INPLINE$)  :no comment, set to eol eX*: ~b*:no code? (return) l*   ENDPTR    p+ v*: *:convert to all caps *   + *: *:label (if any) *   (DELIM$,(INPLINE$,))   * '*     ,  :getfield =*    LABEL$  FLD$ E*: T*:op-code m*   ,  :getfield *    FOUND  p+ *    OP$  FLD$ *:save ptr to start of operands +  OPDPTR  LINEPTR +: +:destination operand (if any)  +   ,  :getfield -*+    FOUND  p+ @4+  DEST$  FLD$ H>+: gH+:source operand (if any) R+   ,  :getfield \+    FOUND  p+ f+  SOURCE$  FLD$ p+ z+: +:internal subroutine caps +:Scans inpline$ up to comment field, ?+:converting l.c. chars. to u.c.. Skips over strings. T+ I    ENDPTR p+  C$  (INPLINE$,I,) +  :skip strings +     C$  "'"  + +      STRGEND  (I,INPLINE$,C$) +       STRGEND    I  STRGEND:  + +  :convert j+     (C$)  a  (C$)  z  C$  ((C$)   ):                  (INPLINE$,I,)  C$ t+   I z+ ,:***********************************************************  ,:* SUBROUTINE GETFIELD                                     * C,:* Starting at lineptr, trys to return next field in FLD$. * $,:* Sets found if sucessful. Moves lineptr past field.      * .,:*********************************************************** 8,: B,:find next non-delimiter or run off end L,  LINEPTR  ENDPTR MV,    (DELIM$,(INPLINE$,LINEPTR,))    t, j`,   LINEPTR  LINEPTR   sj,    t,:if past end, not found ~,  LINEPTR  ENDPTR   , ,   FOUND  FALSE ,    ,: ,:strings terminated by ' !,  (INPLINE$,LINEPTR,)  "'"  , L,   STRGEND  (LINEPTR,INPLINE$,"'") g,    STRGEND    , ,     LINEPTR2  STRGEND   ,      2- ,: ,:otherwise, find next delimter or go 1 past end , LINEPTR2  LINEPTR  -  LINEPTR2  ENDPTR <
-    (DELIM$,(INPLINE$,LINEPTR2,))    2- [-   LINEPTR2  LINEPTR2   d-    l(-: ~2-:copy field <- FLD$  (INPLINE$,LINEPTR,LINEPTR2LINEPTR) F-: P-:move lineptr past field, set found & return  Z- LINEPTR  LINEPTR2  d- FOUND  TRUE  n-  R x-:**********************************************  -:* SUBROUTINE NEWENTRY                        *  -:* Adds new symbol to sym table with default  *  -:* attributes. (may be changed by pseudo-ops) * *!-:********************************************** 2!-: S!-:already in table? (error) j!-  TARGET$  LABEL$ !-  .     :operand_lookup !-   FOUND  . !-   ERRS  ERRS   !-   #,"****Error: Duplicate definition of ";LABEL$;" in ";LINENUM "-    "-: *".:table full? (error) G".  NUMSYM  MAXSYM  @. ^".   ERRS  ERRS   "".   #, "****Error: Too many user symbols in "; LINENUM ",.    "6.: "@.:else make new entry "J. NUMSYM  NUMSYM   "T. SYM$(NUMSYM)  LABEL$ #^. VAL1(NUMSYM)  LOCTR 0#h. SYMTYPE(NUMSYM)  NEAR 8#r.: >#|. g#.:********************************* #.:* SUBROUTINE CHECK_PHASE        * #.:* Label value same both passes? * #.:********************************* #. OP$  "EQU"  . $.TARGET$  LABEL$ ,$. .  :operand_lookup 4$.: k$. (SYMTYPE(TABLEPTR)  (NEAR  MEM))  FALSE  . $.   VAL1(TABLEPTR)  LOCTR  . $.    ERRS  ERRS  : #, "****Phase Error" $. $.:************************************************* 8%/:* SUBROUTINE OPERAND_LOOKUP                     * q%/:* Trys to find TARGET$ in sym table.  If there, * %/:* sets FOUND true, & TABLEPTR to its'position.  * %&/:*************************************************  &0/:scan table for symbol &:/   TABLEPTR    NUMSYM P&D/     SYM$(TABLEPTR)  TARGET$  / :found c&N/     TABLEPTR k&X/: &b/:failure exit point &l/  FOUND  FALSE &v/   &/:sucess exit point &/  FOUND  TRUE &/   '/:********************************************************* W'/:* SUBROUTINE LOOKUP_OP                                  * '/:* Given op-code in op$, & operand types in dtype &      * '/:* stype, trys to find op in opcode table. If sucessful, * (/:* sets found true, & opptr to its' position.            * [(/:********************************************************* (/:binary search for good starting pt. (/ MOVE  NUMOP: ST  MOVE (/  MOVE   (/   MOVE  MOVE 
)0    OP$  OPCODE$(ST)  ST  ST  MOVE : ST  ST  MOVE #)0    ST    ST   D)0    ST  NUMOP  ST  NUMOP M) 0    U)*0: )40:scan for entry matching all 3 fields )>0  OPPTR  ST  NUMOP )H0    OPCODE$(OPPTR)  OP$  0   :failed )R0    OPCODE$(OPPTR)  OP$  z0  *\0    (SRCTYPE(OPPTR)  STYPE)  FALSE  z0 P*f0    (DSTTYPE(OPPTR)  DTYPE)  FALSE  z0 g*p0    0 :found! v*z0    OPPTR *0:failure exit *0 FOUND  FALSE *0  *0:successful exit *0 FOUND  TRUE *0  +0:*************************************** 2+0:* SUBROUTINE UPDATE_LOCTR             * a+0:* Decodes operation & advances loctr. * +0:* On pass 2, generates obj. code.     * +0:*************************************** +0: +0:set operand types & values ,1  :destination operand 6,1   TARGET$  DEST$:  <2   :type_operand N,1   DTYPE  TARGTYPE f,$1   DVAL1  TARGVAL1 ~,.1   DVAL2  TARGVAL2 ,81  :source operand ,B1    :special case: RET op ,L1      OP$  "RET"  STYPE  PROCTYPE(STKTOP):  1 -V1    :normal source <-`1     TARGET$  SOURCE$:  <2   :type_operand V-j1     STYPE  TARGTYPE p-t1     SVAL1  TARGVAL1 -~1     SVAL2  TARGVAL2 -1: -1:find op in op table (not there: error) -1 TARGET$  OP$ -1  /   :lookup_op  .1  FOUND  
2 .1    PASS     W.1   ERRS  ERRS  : #,"****Syntax Error: ";OP$;DTYPE;STYPE .1    ((ACUM8  ACUM16  REG8  REG16  SEG  CS)                                 (DTYPE  STYPE))   2 /1      (STYPE  (NONE  IMMED8  IMMED16))  FALSE   2 +/1        ("BW",(OP$,))     2 H/1         DIAG  DIAG   /1         #,"****Diagnostic: Specify word or byte operation" / 2    /
2 FLAG  OFLAG(OPPTR) /2: /2:branch for mach ops & pseudo-ops to update loctr 0(2  FLAG  MACHOP   8; :  b> 022 Y0<2:********************************************************* 0F2:* SUBROUTINE TYPE_OPERAND                               * 0P2:* Sets TARGTYPE to reflect TARGET$'s type.  Sets        * 1Z2:* TARGVAL1 to its' value. If the operand is a register, * ]1d2:* sets TARVAL2 to its' val2. If an offset appears,      * 1n2:* NEEDOFFSET gets the its' type, and OFFSET its' value. * 1x2:********************************************************* 12: 12:any operand? 22  (TARGET$)    2 /22   TARGTYPE  NONE 822    M22:in sym table? l22  .   :operand_lookup 22   FOUND  2 22   TARGTYPE  SYMTYPE(TABLEPTR) 22   TARGVAL1  VAL1(TABLEPTR) 22    TABLEPTR  PREDEF  TARGVAL2  VAL2(TABLEPTR) 32    32:number? 233  4   :test_number G33   FOUND  63 a33   TARGTYPE  NUMTYPE z3"3   TARGVAL1  NUMVAL 3,3    363:direct mem. ref.? 3@3  5   :memref 3J3   FOUND  r3 3T3   TARGTYPE  MEM 3^3   TARGVAL1  MEMADDR 4h3    4r3:offset off register? @4|3  d7   :parse_disp_off_reg U43   FOUND  3 n43   TARGTYPE  MEMREG 43   TARGVAL1  REGVAL 43    43:offset? 43  9 :offset 43   FOUND  3 43   TARGTYPE  OFFSETYPE 53   TARGVAL1  OFFSETVAL 
53    53:charactor? '53  : <53   FOUND  &4 `54    TARGTYPE  IMMED8  IMMED16 {54    TARGVAL1  CHARVAL 54     5&4:string? 504  (TARGET$,)  "'"  X4 5:4   TARGTYPE  STRING 5D4    5N4: "6X4:not found? assume near label or mem ref. (error on pass 2) 6b4  PASS    #,"****Error: Undefined symbol ";TARGET$:                  ERRS  ERRS   6l4 TARGTYPE  NEAR  MEM 6v4 64:******************************************* 74:* SUBROUTINE TEST_NUMBER                  * ;74:* Trys to interpret TARGET$ as a number.  * n74:* If sucessful, sets FOUND true, NUMVAL   * 74:* to its' value and NUMTYPE to its' type. * 74:******************************************* 74: 74FOUND  FALSE 84TN$  TARGET$  :working copy 84: ,84:hex number? J84  (TN$,)  "H"  z5 ]84  :lop off H |85   TN$  (TN$,(TN$)) 85  :scan for non-hex digits (exit) 85   I   8 5    I    (TN$) 8*5     C$  (TN$,I,) 945      ("0123456789ABCDEF",C$)     9>5      I 09H5  :get value O9R5   NUMVAL  ("&H"  TN$) i9\5  :set type, return v9f5    5 ~9p5: 9z5:decimal number? 95  :scan for non-dec digits (exit) 95    I    (TN$) 95     C$  (TN$,I,) :5      ("0123456789-+",C$)     %:5      I 8:5  :get value P:5   NUMVAL  (TN$) X:5: k:5:sucess exit }:5 FOUND  TRUE :5  ((NUMVAL))     NUMTYPE  IMMED16  IMMED8                        : NUMTYPE  IMMED16 :5 ;5:******************************************** O;6:* SUBROUTINE MEMREF                        * ;6:* Trys to interpret target$ as a direct    * ;6:* mem ref.  If sucessful, sets FOUND true, * ;$6:* & MEMADDR to the address referanced.     * <.6:******************************************** '<86: G<B6MR$  TARGET$  :save copy O<L6: `<V6:brackets? <`6  (MR$,)  "["  (MR$,)  "]"   <j6: <t6:strip off brackets <~6 TARGET$  (MR$,,(MR$)) <6:try to interpret as addr. =6  :might be number ,=6    4   :test_number C=6     FOUND  6 ]=6     MEMADDR  NUMVAL t=6      F7 :exit |=6: =6  :or might be symbol =6    .  :operand_lookup =6     FOUND  7 >6      (SYMTYPE(TABLEPTR)  IMMED16)  FALSE  7 *>6       MEMADDR  VAL1(TABLEPTR) C> 7        F7 :exit K>
7: _>7:failure exit r>7 FOUND  FALSE >(7 TARGET$  MR$ >27  ><7: >F7:sucessful exit >P7 TARGET$  MR$ >Z7  ?d7:***************************************************** >?n7:* SUBROUTINE PARSE_DISP_OFF_REG                     * {?x7:* Trys to parse TARGET$ as an offset off a register * ?7:* If sucessful, sets FOUND true, sets NEEDOFFSET    * ?7:* to the offset's type, and OFFSET to it's value .  * 2@7:***************************************************** :@7: \@7PDOR$  TARGET$  :save copy d@7: x@7:special case @7  TARGET$  "[BP]"  REGVAL  : NEEDOFFSET  IMMED8: OFFSET  :               N9 @7: @7:parse reg spec. A7 :set ptr to candidate )A7  PTR  (TARGET$,"[") RA7   PTR    v9  :no disp, exit lA8 :isolate candidate A8  REG$  (PDOR$,(PDOR$)PTR) A8 :valid reg. spec? A"8   REG$  "[BP]"  REGVAL  :  h8 A,8  TARGET$  REG$ 
B68   .  :operand_lookup >B@8    FOUND  SYMTYPE(TABLEPTR)  MEMREG  v9 WBJ8   :save reg value wBT8    REGVAL  VAL1(TABLEPTR) B^8: Bh8:now parse disp. Br8 :isolate candidate B|8  DISP$  (PDOR$,PTR) B8 :valid disp? B8  TARGET$  DISP$ C8   :might be symbol 4C8     .   :operand_lookup YC8      FOUND  8   :not sym C8     (SYMTYPE(TABLEPTR)  (IMMED16  IMMED8))  FALSE  8 C8      NEEDOFFSET  SYMTYPE(TABLEPTR) C8      OFFSET  VAL1(TABLEPTR) C8       N9 	D8   :or number (D8     4   :test_number @D8      FOUND  9 _D8      NEEDOFFSET  NUMTYPE yD9      OFFSET  NUMVAL D9           N9 D9   :or offset D&9     9 :offset D09      FOUND  v9 D:9      NEEDOFFSET  OFFSETYPE ED9      OFFSET  OFFSETVAL "EN9:sucess exit 7EX9 TARGET$  PDOR$ IEb9 FOUND  TRUE PEl9  dEv9:failure exit yE9 TARGET$  PDOR$ E9 FOUND  FALSE E9  E9:*************************************************** 	F9:* SUBROUTINE OFFSET                               * DF9:* Trys to interpret TARGET$ as an offset operand. * F9:* If sucessful, set FOUND, set OFFSETYPE          * F9:* immed16, and TARGVAL1 to the label's offset.    * F9:*************************************************** F9: G9OS$  TARGET$ G9: GG9 (OS$,)  "OFFSET("  FOUND  FALSE:  \G: PASS    : dG:: yG::isolate label G :  TARGET$  (TARGET$,,(TARGET$)) G*:: G4::look it up G>:   . :operand_lookup GH:: HR: FOUND  (SYMTYPE(TABLEPTR)  (MEM  NEAR))  : 2H\:  ERRS  ERRS   sHf:  #, "****Error: Illegal or undefined argument for Offset" Hp:  OFFSETVAL   Hz:   : H:: H:OFFSETVAL  VAL1(TABLEPTR) H:: H:FOUND  TRUE H:OFFSETYPE  IMMED16 H:TARGET$  OS$ I: 2I::*************************************** aI::* SUBROUTINE CHAR                     * I::* Trys to interpret TARGET$ as a char * I::*************************************** I:FOUND  FALSE I: (TARGET$)     J; (TARGET$,)  "'"   *J; (TARGET$,)  "'"   >J;   FOUND  TRUE cJ$;   CHARVAL  ((TARGET$,,)) iJ.; J8;:************************************* JB;:* SUBROUTINE MACHOP                 * JL;:* Updates loctr based on op length. * KV;:* On pass 2, generates obj. code.   * JK`;:************************************* RKj;: hKt; =  :op_type pK~;: ~K;:opcode K; LOCTR  LOCTR   K;  PASS     >  :build_opcode K;: K;:2nd op byte? L;  (OPVAL(OPPTR)   )  (OPVAL(OPPTR)   )  ; .L;   LOCTR  LOCTR   iL;    PASS    OBJLEN  OBJLEN  : OBJ(OBJLEN)  
  qL;: L;:room for m. byte disp. (must go here, modebyte modifys offset) L;  NEEDOFFSET  NONE  
< ?M;    (NEEDOFFSET  IMMED8)  LOCTR  LOCTR                                    : LOCTR  LOCTR   GM <: M
<:if direct addr. mode byte, leave room for address M<  (FLAG  (NEEDMODEBYTE  NEEDEXT))  FALSE  2< M<    (DTYPE  STYPE)  MEM  LOCTR  LOCTR   M(<: 	N2<:extension byte? /N<<  (FLAG  NEEDEXT)  FALSE  d< HNF<   LOCTR  LOCTR   qNP<    PASS     ?   :build_ext yNZ<: Nd<:mode byte? Nn<  (FLAG  NEEDMODEBYTE)  FALSE  < Nx<   LOCTR  LOCTR   N<    PASS     L@  :build_modebyte O<: O<:8 bit disp.? ?O<  (FLAG  NEEDISP8)  FALSE  < XO<   LOCTR  LOCTR   O<    PASS     ^B  :build_disp8 O<: O<:16 bit disp.? O<  (FLAG  NEEDISP16)  FALSE  < O<   LOCTR  LOCTR   
P<    PASS     :C :build_disp16 P<: )P<:immediate byte? RP=  (FLAG  NEEDIMMED8)  FALSE  "= kP=   LOCTR  LOCTR   P=    PASS     D P"=  WORD  ((FLAG  NEEDIMMED)  FALSE)  J= P,=   LOCTR  LOCTR   P6=    PASS     D   :build_immed8 Q@=: QJ=:immediate word(s)? QQT=  (WORD)  ((FLAG  NEEDIMMED)  FALSE)  |= Q^=    DTYPE  IMMED16  LOCTR  LOCTR   : LOCTR  LOCTR   Qh=    PASS     D  :build_immed16 Qr=: Q|=:mem. addr.?  R=  (FLAG  NEEDMEM)  FALSE  = R=   LOCTR  LOCTR   @R=    PASS     BE  :mem_addr HR=: NR= zR=:************************************ R=:* SUBROUTINE OP_TYPE               * R=:* Decides between word & byte ops. * R=:************************************ S=: @S= (DTYPE  STYPE)  (REG16  ACUM16  SEG  CS)  > mS= (DTYPE  STYPE)  (REG8  ACUM8)  D> uS=: S> (OP$,)  "B"  D> S>: S>:word S&> WORD  TRUE S0>  S:>: SD>:byte SN> WORD  FALSE SX>   Tb>:********************************************** VTl>:* SUBROUTINE PSEUDO-OP                       * Tv>:* Branches to routines to handle each pseudo * T>:* op using the value field as an index.      * T>:**********************************************  U>: 2U> OPVAL(OPPTR)  E, F, F, NH, 4I, I wU>:                      EQU    ORG    DB     DS     PROC   ENDP }U> U>:********************************************************** V>:* SUBROUTINE BUILD_OPCODE                                * CV>:* Builds opcode, stores it in obj. Increments objlength. * V>:********************************************************** V>: V>OBJLEN  OBJLEN   V>OBJ(OBJLEN)  OPVAL(OPPTR) V?: V?:add reg. field if requested W?  (FLAG  ADDREG)  FALSE  f? +W ?   :segment reg. [W*?     DTYPE  (SEG  CS)  R  DVAL2:  R? qW4?   :normal reg. W>?     (FLAG  DIRECTION)  R  SVAL2 : R  DVAL2 WH?: WR?   OBJ(OBJLEN)  OBJ(OBJLEN)  R W\?: Wf?:auto word bit? Xp?  (FLAG  AUTOW)  FALSE  ? HXz?    WORD  OBJ(OBJLEN)  OBJ(OBJLEN)   PX?: gX?:auto count bit? X?  (FLAG  AUTOC)  FALSE  ? X?    STYPE  CL  OBJ(OBJLEN)  OBJ(OBJLEN)   X?: X? Y?:************************************************** AY?:* SUBROUTINE BUILD_EXTENSION_BYTE                * {Y?:* Builds an opcode extension byte.  The ext. val * Y?:* is extracted from bits 3-5 of the flag word.   * Y?:************************************************** Y?: Z?:get ext. Z@ MASK  8  .Z@ EXT  FLAG  MASK 6Z@: mZ$@:define proper operand as ext. & build mode byte Z.@   FLAG  DIRECTION  DVAL2  EXT : SVAL2  EXT Z8@   L@  :build_modebyte ZB@ [L@:*************************************************************** V[V@:* SUBROUTINE BUILD_MODE_BYTE                                  * [`@:* Given direction flag, memreg values in dval1 and sval1 and  * [j@:* reg values in dval2 and sval2, builds an addressing mode    * +\t@:* byte.  If necessary, also builds displacement byte(s).      * r\~@:*************************************************************** z\@: \@OBJLEN  OBJLEN   \@: \@:special case: direct mem. addressing? \@  ((DTYPE  STYPE)  MEM)  FALSE  @ #]@    DTYPE  MEM   M  SVAL2 : M  DVAL2 @]@     OBJ(OBJLEN)    M b]@      BE  :build_mem_addr m]@      u]@: ]@:normal mode byte ]@ :operands in normal or reverse order? ] A   FLAG  DIRECTION  M  SVAL1  DVAL2 : M  DVAL1  SVAL2 ^
A: ^A OBJ(OBJLEN)  M !^A: 8^(A:offset byte(s)? @^2A: ^^<A NEEDOFFSET  NONE  A f^FA: y^PA:8 bit disp. ^ZA OFFSET    OFFSET    A ^dA  OBJ(OBJLEN)  OBJ(OBJLEN)  @  :set mod field ^nA  :crunch neg. offset to 8 bits *_xA     OFFSET    OFFSET  OFFSET    D_A  OBJLEN  OBJLEN   __A  OBJ(OBJLEN)  OFFSET g_A   o_A: _A:16 bit disp. _A OBJ(OBJLEN)  OBJ(OBJLEN)    :set mod field _A OBJLEN  OBJLEN   _A :convert to hi/low form `A    NUMLOW  OFFSET:  A  :hi/low 7`A OBJ(OBJLEN)  NUMLOW R`A OBJ(OBJLEN)  NUMHIGH X`A `A:************************************************ `B:* SUBROUTINE HI/LOW                            *  aB:* Splits 16 bit number in numlow, into two     * 8aB:* byte-sized componants in numhigh and numlow. * pa"B:************************************************ a,BH$  (NUMLOW) a6BH$  ((H$),"0")  H$ a@BNUMLOW   ("&H"  (H$,)) aJBNUMHIGH  ("&H"  (H$,)) aTB !b^B:********************************************* VbhB:* SUBROUTINE BUILD_DISP8                    * brB:* Calculates the disp. from the present     * b|B:* loc to the loc given as an operand.       * bB:* Prints error message if disp. exceeds 127.* *cB:********************************************* 2cB: IcB:calculate disp. `cB D  DVAL1  LOCTR hcB: zcB:check size cB  (D)    B cB   D    dB    PASS    #,"****Error: Too far for short jump":                     ERRS  ERRS   dB: (dB:if neg. crunch to 8 bits CdB  D    D  D    KdC: bdC:build obj. code {dC OBJLEN  OBJLEN   d&C OBJ(OBJLEN)  D d0C d:C:******************************************** dDC:* SUBROUTINE BUILD_DISP16                  * 2eNC:* Builds 16 bit displacement. Prints error * feXC:* msg. for negative disps not on CALL ops. * ebC:******************************************** elC: evC:calculate disp. eC D  DVAL1  LOCTR eC: 3fC OP$  "JMP"  D  #, "****Diagnostic: Could use JMPS" :        DIAG  DIAG   ;fC: IfC:legal? lfC  D    OP$  "CALL"  C yfC   D   fC    PASS    #,"****Error: Illegal reverse long jump":                  ERRS  ERRS   fC: fC:build obj. code gC NUMLOW  D:  A  :hi/low 4gC OBJLEN  OBJLEN   PgC OBJ(OBJLEN)  NUMLOW kgD OBJ(OBJLEN)  NUMHIGH qgD gD:************************************ g D:* SUBROUTINE BUILD_IMMED16         * g*D:* Builds word(s) of immediate data * !h4D:************************************ )h>D: UhHD DTYPE  IMMED16  IVAL  DVAL1:  fD hRD STYPE  IMMED16  IVAL  SVAL1:  fD h\D hfD:internal subroutine immed16 hpDNUMLOW  IVAL:  A   :hi/low hzDOBJLEN  OBJLEN   iDOBJ(OBJLEN)  NUMLOW iDOBJ(OBJLEN)  NUMHIGH "iD LiD:********************************** viD:* SUBROUTINE BUILD_IMMED8        * iD:* Builds byte of immediate data. * iD:********************************** iD: iD DTYPE  IMMED8  IVAL  DVAL1:  D (jD STYPE  IMMED8  IVAL  SVAL1:  D .jD FjD:int. sub. immed8 ijD IVAL    IVAL    $E xjE  IVAL   jE   PASS    ERRS  ERRS  : #,"****Error: Data too long" jE: j$EOBJLEN  OBJLEN   j.EOBJ(OBJLEN)  IVAL j8E !kBE:********************************* JkLE:* SUBROUTINE MEMREF             * skVE:* Builds a memory address word. * k`E:********************************* kjE: ktE:get addr. in hi/low form k~E  DTYPE  MEM  NUMLOW  DVAL1 : NUMLOW  SVAL1 lE  A lE:build word 0lE OBJLEN  OBJLEN   LlE OBJ(OBJLEN)  NUMLOW glE OBJ(OBJLEN)  NUMHIGH mlE lE:*************************** lE:* SUBROUTINE EQU          * lE:* Handles equ pseudo-op.  * lE:*************************** mE: mE (LABEL$  "")   F cm F   PASS    ERRS  ERRS: #,"****Error: EQU without symbol" km
F   smF: mF PASS    xF m(F: m2F DTYPE  (NEAR  MEM)  dF   :pass 1 default if not found m<F  ERRS  ERRS   (nFF  #, "****Error: EQU with forward referance in ";LINENUM 0nPF   8nZF: QndFVAL1(NUMSYM)  DVAL1 mnnFSYMTYPE(NUMSYM)  DTYPE snxF nF:************************** nF:* SUBROUTINE ORG         * nF:* Handles org pseudo-op. * nF:************************** oF: !oF:set loctr to new value 4oF LOCTR  DVAL1 :oF [oF:************************* |oF:* SUBROUTINE DB         * oF:* Handles db pseudo-op. * oF:************************* oF: oF PASS    "G oG:label? set type to mem %pG  LABEL$  ""  SYMTYPE(NUMSYM)  MEM -pG: Zp"G:scan operand area, building obj. code p,G LINEPTR  OPDPTR: LINEPTR2  OPDPTR p6G  LINEPTR  ENDPTR p@G  :get operand pJG    ,  :get_field pTG     FOUND  G  :exit q^G  :branch for byte value or string AqhG   TARGET$  FLD$:  4 :test_number uqrG     FOUND  (NUMTYPE  IMMED8)  FALSE  G q|G      G  :build_byte qG      G qG    (FLD$,)  "'"  G qG      H  :build_stg qG      G rG  :if not byte or string, error on pass 2 rG    PASS    #,"****Error: unrecognized operand ";FLD$:                 ERRS  ERRS   rG   rGLOCTR  LOCTR  OBJLEN rG rG:subroutine build_byte rGOBJLEN  OBJLEN   rGOBJ(OBJLEN)  NUMVAL rG sH:subroutine build_stg JsHFLD$  (FLD$,,(FLD$)) :strip off 's asH I    (FLD$) {s&H  OBJLEN  OBJLEN   s0H  OBJ(OBJLEN)  ((FLD$,I,)) s:H   I sDH sNH:************************* sXH:* SUBROUTINE DS         * tbH:* Handles ds pseudo-op. * 4tlH:************************* <tvH: ftHDSFLAG  TRUE  :signal this is a ds tH PASS    H :skip type setting second time tH: tH:label? set type to mem tH  LABEL$  ""  SYMTYPE(NUMSYM)  MEM tH: 
uH:set output code @uH  STYPE  IMMED8  DSVAL  SVAL1 : DSVAL   HuH: vuH:on pass 2, generate obj. code directly uH  PASS    I uH    I    DVAL1 uH      BYTE$  (DSVAL):  # uH      I uI: vI:advance loctr, update bytesgen ;vI LOCTR  LOCTR  DVAL1: BYTESGEN  BYTESGEN  DVAL1 Cv I: Iv*I lv4I:*************************** v>I:* SUBROUTINE PROC         * vHI:* Handles proc pseudo-op. * vRI:*************************** v\I: vfI STKTOP  MAXSTK  I wpI   PASS    I (wzI    ERRS  ERRS   _wI    #, "****Error: Procedures nested too deeply" gwI   owI: wI:push new proc type for returns wI STKTOP  STKTOP   wI PROCTYPE(STKTOP)  DTYPE wI wI:******************** 
xI:* SUBROUTINE ENDP  * &xI:* Pops proc stack. * BxI:******************** JxI: axI STKTOP    8J xxJ   PASS    $J xJ    ERRS  ERRS   xJ    #, "****Error: ENDP without PROC" x$J   x.J: x8JSTKTOP  STKTOP   xBJ yLJ:************************************ ByVJ:* SUBROUTINE OUTPUT                * ny`J:* Outputs obj code & listing line, * yjJ:* given code in obj(objlength).    * ytJ:************************************ y~J: yJ:update number of bytes generated zJ BYTESGEN  BYTESGEN  OBJLEN UzJ DSFLAG  H$  (LOCTRDVAL1) : H$  (LOCTROBJLEN) szJH$  ((H$),"0")  H$ zJ#, ) H$; zJ:first 6 bytes zJ I   zJ #, ) zJ  I   zJ    I  OBJLEN  K zJ    BYTE$  (OBJ(I)):  # 4{J   H$  (OBJ(I)):  (H$)    H$  "0"  H$ D{J   #, H$; U{J   I  I   ^{ K    f{
K: {K:source (truncate if necessary) {K #, ) {(K #,  "####"; LINENUM; {2K #, () (INPLINE$, LWIDTH) {<K: |FK:rest of obj. code |PK  I  OBJLEN 3|ZK    I      #, ) W|dK    BYTE$  (OBJ(I)):  # |nK   H$  (OBJ(I)):  (H$)    H$  "0"  H$ |xK   #, H$; |K   I  I   |K    |K OBJLEN    #, |K |K:*************************** }K:* SUBROUTINE PASSTWO_INIT * =}K:*************************** E}K: ]}K:reset input file x}K  #:  SC$   AS # }K: }KPASS   }KLOCTR    }LLINENUM   }	LBYTESGEN   }L: }L }"L:************************ ~,L:* SUBROUTINE FINALPROC * ,~6L:* Cleanup              * L~@L:************************ T~JL: ~TL STKTOP    ERRS  ERRS  : #,"****Error: missing ENDP" ~^L: ~hL#,: #,: #, ERRS; "Error(s) detected" ~rL#, DIAG; "Diagnostic(s) offered" .wL#,: #, BYTESGEN; "Bytes of object code generated" D|L:dump sym table OL  L oL:return printer to normal L  L$  "lpt1:"  #, PMODEOFF$ L:hang onto screen listing L  L$  "scrn:"  L L   : :  , L    ) "Hit any key to exit" O); +L   C$  :  C$  ""  L 8L    , >L cL:***************************** L:* SUBROUTINE DUMP_SYM_TABLE * L:***************************** M: ـM#,: #, "SYMBOL TABLE DUMP:" MI  PREDEF   &MF$   "\        \!\  \\  \"  :format 50MPERLINE  LWIDTH  (F$) H:M I  NUMSYM zDM  H$  (VAL1(I)): H$  ((H$),"0")  H$ NM  #,  F$; SYM$(I); " ";  H$; "    "; XM  I  I   ށbM   (IPREDEF)  PERLINE    #, lM   vM#, M "M:************************************* OM:* SUBROUTINE PROGESS REPORT         * |M:* Maintains reassuring msg. on scrn * M:************************************* M: ނMX  (): Y  :  ,:  ,:  ); 	M PASS     "First"; :  "Second"; AM " pass in progress. Lines processed = "; LINENUM; [M O);:  ,:  Y,X aM M:**************************************** M:* SUBROUTINE SET_UP_SYMBOL_TABLE       * N:* Sets up sym table, & opens obj. file * !N:**************************************** )N: W N#, PREDEF, MAXSYM:  #, C$:  #, C$ *N SYM$(MAXSYM), VAL1(MAXSYM), VAL2(PREDEF), SYMTYPE(MAXSYM) 4N: ΄>N I    PREDEF  :# of pre-defined syms HN  #, SYM$(I), VAL1(I), VAL2(I), SYMTYPE(I) 	RN   I \NNUMSYM  PREDEF %fN: .pN # TzN O$ AS # :  #, AS BYTE$ ZN P:********************************** Z:* SUBROUTINE INIT                * ؅d:* Initializes all but sym table. * n:********************************** 
x: í AZ +ERRS  : DIAG   3: E:title page P   h:define constants s   :open files    :op table    :listing header ̆   ҆Ď :************************************************* D:* SUBROUTINE TITLE                              * }":* Prints title page, & waits for user response. * ,:************************************************* 6: @ ,,:  P:  : :  ,, Jđ )"";(8,"");" Tđ )""E)" >^đ )"" )"CHASM  version 2.01"E)" Rhđ )""E)" rđ )"")"Cheap Assembler for the IBM PC"E)" |đ )""E)" 䈆đ )"      If you have used this program and found it of      *đ )"   value, your $20 contribution will be appreciated.     >đ )""E)" eđ )"")"David Whitman"E)" đ )"")"2 North Park Street"E)" đ )"")"Apartment L"E)" đ )"")"Hanover, NH  03755"E)" đ )""E)" =đ )"   You are encouraged to copy and share this program.    Qđ )""E)" pđ ) "";(8,"");"": đ ) "Hit any key to continue...":: I$  :  I$  ""   :  :**************************** 	:* SUBROUTINE SET_CONSTANTS * -&:**************************** <0:general m: TRUE  : FALSE  : DELIM$  " ,"  () uD: N:flag values X:bits 3-5 reserved for ext. values b MACHOP  : AUTOW  : ADDREG  @: NEEDEXT   2l NEEDISP8   : NEEDISP16   : NEEDMODEBYTE   : NEEDIMMED8    tv NEEDIMMED   : DIRECTION    : NEEDMEM   @: AUTOC    |: :operand types ׌ ACUM8  : ACUM16  : REG8  : REG16  : MEMREG  : CS     SEG  @: MEM  : IMMED8   : IMMED16   : NONE    K STRING   : NEAR   : FAR    : CL   @ S: a:arrays MAXOBJ  2:  OBJ(MAXOBJ) MAXSTK  
:  PROCTYPE(MAXSTK): STKTOP   Ŏ :***************************************************** 0:* SUBROUTINE OPEN_FILES                             * m:* Prompts user for i/o filenames, then opens files. * :***************************************************** : ƕ   8 Ȏ : ڎ*:input file 4  ,: "Source code file name? [.asm] ", S$ &>  S$  ""  :  4 KH :if no extension, add default R     (S$,".")                                                                 SC$  S$  ".asm"                                                          : SC$  S$: S$  (S$,(S$,".")) )\    SC$   AS # 4f  , wp "Direct listing to Printer (P), Screen (S), or Disk (D)?",L$ z  L$  ""  :  f ͐    ("PpSsDd",L$)    :  f  :invalid response     L$  "P"  L$  "p"  L$  "lpt1:" :    :printer? N    L$  "S"  L$  "s"  L$  "scrn:" :    :screen? o      ,:  (O);:  ,      "Name for listing file? [";S$;".lst] ";       "",L$       L$  ""  L$  S$  ".lst"  :default to source name     L$  OUTPUT AS # .Ƒ#, :test listing device A:object file w  ,:  "Name for object file?  [";S$;".com] ";   "",O$  :default to source file name.com В    O$  ""  O$  S$  ".com"  :will open after symtable setup Ǖ      :kill error trapping )$ : :  /.ǎ G8:**************** _B:*Error Handler * wL:**************** V: `ǋ   5  j eǋ ((  4)  (  \))   œj   ,:  t   SC$; " not found.  Press Esc to exit, anything else to continue."; 0~  SC$  :  SC$  ""  ~ J   SC$  ()   g   ,:  ,:  (P);    ,:  (0); :  ,:  4 : ǋ          #:  ,:     "Printer not available.  Press any key to continue.";    L$   :  L$  ""   ;    ,:  ,:  (O); a    ,8:  ();:  ,:  p oǕ      :***********************  :* SUBROUTINE OP_TABLE * ̕
:*********************** ԕ: :put reassuring message on screen " X  (): Y  :  ,:  , K  ) "*Set-up in progress*" O); ]  ,:  Y,X e: Ⱥ "chasm.dat"   AS # (:note: c$ used to skip data comments 2: ؖ<ȅ#, NUMOP:  #,C$:  #, C$ FȆ OPCODE$(NUMOP), OPVAL(NUMOP), SRCTYPE(NUMOP) .PȆ DSTTYPE(NUMOP), OFLAG(NUMOP) 6Z: JdȂ I    NUMOP n  #, OPCODE$(I),OPVAL(I),DSTTYPE(I),SRCTYPE(I),OFLAG(I) x   #, C$    I Ȏ ɗ:************************* ꗠ:* SUBROUTINE HEADER     * :* Prints listing header.* ,:************************* 4: VLWIDTH  O  :default width ^: r:title & date  D$  (,)  "/"  (,,)  "/"   (,) ՘ #, SC$ LWIDTH(D$)) D$:#,:#, ݘ: :printer set up?   L$  "lpt1:"  T U   :for NEC 8023 printer, remove quotes for auto condensed mode "   :similar code may be substituted for other printers. ,  LWIDTH  :  #, LWIDTH   ڙ6  #, ()  "Q" :pmodeon @  PMODEOFF$  ()  "N" J: T:column headings J^ #,"LOC")"OBJ")"LINE")"SOURCE":#, Rh: XrɎ   @  PMODEOFF$  ()  "N" J: T:colu