;From Jerry Coffin - Printing Numbers
;
;The conversion is fairly simple: you divide the number by the base you
;want to convert it to, and the remainder is the least significant digit.
;Repeat the division on the result, and the remainder gives you the next
;least significant digit.  Keep repeating this process until the result
;of the division is 0.

.model small, c

BASE = 10   ; The base for the conversion.  E.g. set to 2 for decimal.
            ; currently won't work with BASE>10

.data?

output_buffer db 16 dup(?)

.code
utoa proc
;
; Convert an unsigned integer in AX to ASCII.
;
; expects input in AX.
; pointer to output in DI
; destroys CX and DX
;
    pushf
    mov cx, BASE
    mov di, offset output_buffer+9
    mov [di], 0
    test ax, ax
    jnz start_loop
    mov [di], '0'
    ret
outloop:
    div cx
    add dl, '0'
    mov [di], dl
start_loop:
    dec di
    xor dx, dx
    test ax,ax
    jnz outloop
    inc di
    ret
utoa endp

;This creates a string with a 0 byte as its terminator, but that part's
;quite easy to change if you wish to do so.  As-is, this treats numbers
;as unsigned.  To treat them as signed, you generally want to check
;whether they're negative, and if so, set a flag indicating that they're
;negative.  Then negate the number, and create your output like usual.
;Finally, check the flag to see whether the number's negative, and if so,
;add a '-' character to the beginning of the buffer.
