;From: Jon Slaughter <lobo@iamerica.net>
;Bootloader: Not limited to root directory.

COMMENT ^

Here's some code for a loader that does not require the system files to
be in the root directory. It doesn't seem to work when the disk is
quickformated(data starts at the 35th logical sector for some reason,
and even though I do not hard code anything, it still doesn't work
right). It doesn't update int 1eh because I'm not sure if its needed?
Its very simple:

load up the fat
load up the root director file
scan for a file and load in memory at location bx.


since a directory is really just a file that holds its information, I
just "replace" the root directory in memory with the the new directory.
Well, its almost that simple. All I ask is that if any modification are
made or that another boot loader/straper/etc.. is create based on this
one, is to send me a copy of the source(or, atleast the image). I do
have one question to add:

how can I calculate the segment of a unknown segment? (doesn't make
send, does it :))

SEG1 SEGMENT USE16 PARA 
	;cs = seg seg1

	; how can I find the segment of SEG2 without using the SEG 	; operator?
I've gotten pretty close, but...


	mov	eax,	cs
	shl	eax,	4
	add	eax,	SEG1_SIZE
	mov	ebx,	eax
	and	ebx,	0Fh
	add	eax,	ebx
	shr	eax,	4

SEG1_SIZE EQU $
SEG1 ENDS
; I don't think I compensated for the space inbetween here... since its
; aligned on a paragraph.
SEG2 SEGMENT PARA
SEG2 ENDS

COMMENT ENDS ^

; if you make this code any better, or make a better loader after getting
; the idea from this code, send me a copy at: lobo@iamerica.net.
; Thanks.

.386p                           ; enable 386p+ instructions


;LOADER_SEG      EQU     7C00h   ; BOOTSTRAP
LOADER_SEG      EQU     100h    ; COM

; segments where the stack, FAT, Directory entry, and file to load
; will be placed.
STACK_SEG       EQU     5000h                   
STACK_SIZE      EQU     1000h

FAT_SEG         EQU     6000h
FAT_OFS         EQU     0000h
DIR_SEG         EQU     7000h
DIR_OFS         EQU     0000h
FILE_SEG        EQU     3000h
FILE_OFS        EQU     0000h

RETRY_COUNT     EQU     5


FIXUP_INT1E     MACRO
        xor     ax,     ax
        mov     es,     ax
        mov     di,     1Eh*4
        les     di,     ds:[di]
      
ENDM


LOAD_FAT_AND_ROOT       MACRO
        mov     bp,     [BOOT_RECORD.SECTORS_PER_FAT]   ; # of sectors to load(size of fat)
        mov     ax,     [BOOT_RECORD.RESERVED_SECTORS]  ; where fat starts
        mov     cx,     ax                              ; save ax
        mov     ax,     bp
        xor     bx,     bx                              ; clear bx
        mov     bl,     [BOOT_RECORD.FATS_ON_DISK]
        mul     bx
        add     ax,     cx
        push    ax                                      ; save ax
        ; ax = DIR START
        ; ax = ax * bx + cx; SECTORS_PER_FAT * FATS_ON_DISK + RESERVED_SECTORS

        ; ax = ROOT DIR START
        mov     ax,     cx                              ; get back fat start

        mov     bx,     FAT_SEG         ; fat segment to receive data
        mov     es,     bx              ; duh
        mov     bx,     FAT_OFS         ; offset
        call    read_sector             ; touchdown!


        xor     dx,     dx              ; intel sucks
        mov     ax,     [BOOT_RECORD.ROOT_DIR_ENTRIES]
        mov     [DIR_FILES],    ax
        shl     ax,     5               ; bp * 32
        div     [BOOT_RECORD.BYTES_PER_SECTOR]

        ; ax = ROOT_DIR_ENTRIES * 32 / BYTES_PER_SECTOR

        mov     bp,     ax              ; bp = size of ROOT DIR
        inc     bp                      ; roundish DIR size
        pop     ax                      ; get back ax
        push    ax                      ; save ax
        add     ax,     bp              ; ax + bx = data start

        dec     ax
        dec     ax
        mov     [DATA_START],   ax      ; ax = DIR start; BX = DIR SIZE
        pop     ax                      ; get back ax

        mov     bx,     DIR_SEG         ; bx->es = DIR SEG
        mov     es,     bx              ; eh?
        mov     bx,     DIR_OFS         ; bx = DIR OFS
        call    read_sector             ; reception

ENDM

;************************************
;DESC: converts a linear sector into a data sector
;IN: ax = linear sector
;OUT: ax = linear sector + DATA_START
;SAVES: NONE
;MISC: 
;************************************

SECTOR_TO_CLUSTER       MACRO
        add     ax,     [DATA_START]
        sub     ax,     2
ENDM


;************************************
;DESC: extracts 12-bits from the FAT
;IN: ax = linear sector
;OUT: ax = next index/cluster to load
;SAVES: NONE
;MISC: 
;************************************

EXTRACT_12_BITS         MACRO
        push    es
        pusha
        mov     bx,     FAT_SEG
        mov     es,     bx
        mov     bx,     3
        mul     bx


        mov     di,     bx
        rcr     ax,     1

        xchg    ax,     di
        mov     ax,     ES:[di]
        jnc     WAS_EVEN

        shr     ax,     4
WAS_EVEN:
        and     ax,     0FFFh
        mov     es,     ax
        popa
        mov     ax,     es
        pop     es
ENDM
;************************************
;DESC: converts a linear sector into a sector, track, & head
;IN: ax = linear sector
;OUT: cx, dx = bios values
;SAVES: NONE
;MISC: 
;************************************

LINEAR_TO_BIOS  MACRO
        push    ax
IF LOADER_SEG EQ 100h
        push    bx
ENDIF
        xor     dx,     dx      ; clear dx for div
        push    ax              ; save linear sector
        mov     di,     [BOOT_RECORD.SECTORS_PER_TRACK]
        div     di              ; ax / di
        inc     dx              ; dx = dx mod di + 1
        mov     cx,     dx      ; save it in cx
        ; cx = 1 + (linear_sector mod sectors_per_track = sector
        mov     si,     [BOOT_RECORD.NUMBER_OF_HEADS]
        xor     dx,     dx      ; clear dx for div
        div     si              ; dx = ax mod si
        shl     dx,     8       ; dl->dh
        mov     dl,     [BOOT_RECORD.PHYSICAL_DRIVE_NUMBER]
IF LOADER_SEG EQ 100h
        mov     bx,     dx
ENDIF
IF LOADER_SEG EQ 7C00h
        mov     fs,     dx
ENDIF
        ; fs = dx = (linear_sector / sectors_per_track) mod number_of_heads
        xchg    ax,     di      ; ax = sectors_per_track
        mul     si              ; si = number_of_heads
        pop     si              ; si = linear sector
        xchg    ax,     si      ; swap'em
        div     si              ; ax = ax / si
        ; track = ax = linear sector / (sectors_per_track * number_of_heads)
        mov     ch,     al      ; cl = sector; ch = track
IF LOADER_SEG EQ 7C00h
        mov     dx,     fs
ENDIF
IF LOADER_SEG EQ 100h
        mov     dx,     bx
        pop     bx
ENDIF
        pop     ax
ENDM




BOOT_RECORD_TAG STRUCT
        OEM_NAME                        db      'PHEONIX1'
        BYTES_PER_SECTOR                dw      512
        SECTORS_PER_CLUSTER             db      1
        RESERVED_SECTORS                dw      1
        FATS_ON_DISK                    db      2
        ROOT_DIR_ENTRIES                dw      244
        SECTORS_IN_LOGICAL_DISK         dw      2880
        MEDIA_DESCRIPTOR_BYTE           db      0F0h
        SECTORS_PER_FAT                 dw      9
        SECTORS_PER_TRACK               dw      18
        NUMBER_OF_HEADS                 dw      2
        NUMBER_OF_HIDDEN_SECTORS        dd      0
        TOTAL_NUMBER_OF_SECTORS         dd      2880
        PHYSICAL_DRIVE_NUMBER           db      0
        RESERVED_1                      db      0
        SIGNATURE_BYTE                  db      29h
        VOLUME_SERIAL_NUMBER            dd      0
        VOLUME_LABEL                    db      'NO NAME    '
        FAT_SIGNATURE                   db      'FAT12   '
BOOT_RECORD_TAG ENDS


FILE_RECORD_TAG STRUCT
        NAME                            db      8 DUP (?)
        EXTENSION                       db      3 DUP (?)
        ATTRIBUTES                      db      ?
        RESERVED                        db      10 DUP (?)
        TIME                            dw      ?
        DATE                            dw      ?
        STARTING_CLUSTER                dw      ?
        FILE_SIZE                       dd      ?
FILE_RECORD_TAG ENDS


LOADER SEGMENT USE16 BYTE 'LOADER'
ASSUME CS:LOADER,DS:LOADER
org LOADER_SEG
;org 100h
LOADER_STARTING_ADDRESS:        ; main entry point, BIOS loads
                                ; bootstraper at 0:7C00h
                                ; .com needs to be 100h to run
                                ; under dos for debugging.
  jmp   short LOADER_CODE       ; short or long...
  nop                           ; if short
  BOOT_RECORD BOOT_RECORD_TAG <>; the bootrecord goes here
  KERNEL_NAME           DB      'KERNEL  COM'
                                ;           ;
  DIR_NAME              DB      'OS         '
  RETRY_COUNT_VAR       DB      RETRY_COUNT     ; number of times to retry disk read
  DATA_START            DW      0
  DIR_FILES             DW      0

LOADER_CODE:
  cld
  mov   ax,     STACK_SEG       ; point SS:SP to a unused
  mov   ss,     ax              ; memory area
  mov   sp,     STACK_SIZE              

  FIXUP_INT1E

  push  cs                      ; point ds to our code segment
  pop   ds                      ; to be used with data

IF LOADER_SEG EQ 100h
  call  clean_up_for_dos
ENDIF



  LOAD_FAT_AND_ROOT             ; load the fat & root dir


  mov   ax,     DIR_SEG
  mov   es,     ax
  mov   bx,     DIR_OFS
  mov   si,     OFFSET DIR_NAME
  call  LOAD_FILE

  mov   ax,     [BOOT_RECORD.BYTES_PER_SECTOR]
  xor   bx,     bx  
  mov   bl,     [BOOT_RECORD.SECTORS_PER_CLUSTER]
  mul   bx
  shr   ax,     5

  mul   si
  mov   [DIR_FILES],    ax
  mov   ax,     FILE_SEG
  mov   es,     ax
  mov   bx,     FILE_OFS
  mov   si,     OFFSET KERNEL_NAME
  call  LOAD_FILE


IF LOADER_SEG EQ 100h           ; exit to dos if assembled for com
  mov   ax,     4C00h           ; return to dos
  int   21h                     ; used for debugging
ENDIF

IF LOADER_SEG EQ 7C00h          ; else jump to file code
  db    0eah                    ; far jump opcode
  dw    FILE_OFS                ; offset to jump to
  dw    FILE_SEG                ; segment to jump to
ENDIF



;************************************
;DESC: reads a sector into memory
;IN: es:bx = seg:ofs of memory location; ax = linear_sector; bp = # of sectors to read
;OUT: nothing
;SAVES: all general purpose regs
;MISC: 
;************************************

READ_SECTOR     PROC
  pusha
RETRY_READ:
  xor   cx,     cx
  mov   cl,     [BOOT_RECORD.SECTORS_PER_CLUSTER]
  mul   cx                      ; ax = linear_sector * sectors_per_clusters
;^^^******* MIGHT NOT BE NEEDED, Just a precaution ***********^^^
; instead of pointing to every sector... points to every cluster
; if SPC = 1 then linear_sector = linear_sector...
; if SPC = 2 then linear_sector = linear_sector * 2...
; linear_sector is actually converted into a linear_cluster
  push  ax
  mov   ax,     bp              ; get # of sectors to read
  mul   cx                      ; converts number of sectors to read
                                ; into number of clusters
  mov   bp,     ax               
  pop   ax

  LINEAR_TO_BIOS                ; convert linear to bios
  mov   ax,     bp              ; get ax = clusters to read



  mov   ah,     02h             ; function: read sector
  int   13h                     ; cx:dx = bios values... 
  jnc   READ_OK                 ; test if read ok
       
  xor   ax,     ax              ; function: reset disk
  int   13h                     ; do it
  jnc   RESET_OK                ; jump if reset ok (:)(::)(:)
DISK_ERROR:
  mov   si,     OFFSET DISK_ERROR_MSG   ; offset of string to display
  mov   cx,     SIZEOF DISK_ERROR_MSG   ; # of chars to show
  call  WRITE_STRING            ; just do it

RESET_OK:                       
  dec   [RETRY_COUNT_VAR]       ; test for retry count
  jnz   RETRY_READ              ; retry until 0
  jmp   short DISK_ERROR

READ_OK:
  mov   [RETRY_COUNT_VAR],      RETRY_COUNT     ; get it back
  popa
  ret                           ; return to caller
READ_SECTOR     ENDP




;************************************
;DESC: loads a file into memory pointed to by ES:bx
;IN: es:bx = seg:ofs of memory location; si = offset of file name 
;OUT: nothing
;SAVES: NONE
;MISC: 
;************************************

LOAD_FILE       PROC
        push    es              ; save seg of memory location for later
        push    bx              ; save ofs of memory location for later
        mov     ax,     DIR_SEG ; points es:di to directory segment
        mov     es,     ax      
        mov     di,     DIR_OFS ; di = offset of directory entries
        mov     bx,     [DIR_FILES] ; # number of files is directory
        xor     dx,     dx      ; dx = first dir entry
        mov     bp,     si      ; bp = offset of file name
SEARCH_FOR_FILES:
        mov     cx,     11      ; length of file name
        repe    cmpsb           ; search for file name
        pushf                   ; save flags... for later jump


        mov     si,     bp      ; cmpsb incs si... need it to be normal
        inc     dx              ; increment file_pointer

        add     di,     32-11   ; fixes di to point to next dir entry
        add     di,     cx      ;

        popf
        jz      FILE_FOUND      ; file name matched a directory entry
        cmp     dx,     bx      ; dx = file entry, bx = max entries
        jle     SEARCH_FOR_FILES; continue if > all files entries have been
                                ; serched

        mov     si,     OFFSET FILE_NOT_FOUND_MSG
        mov     cx,     SIZEOF FILE_NOT_FOUND_MSG
        call    WRITE_STRING    ; display error msg
FILE_FOUND:

        mov     ax,     ES:[DI-6] ; DI-6 points to the previous starting cluster
        ; ax = starting cluster; ES:di = directory seg:ofs
        pop     bx      ; bx = file buffer offset
        pop     es      ; es = file segment
        xor     si,     si      ; used for DIR entries... counts how many
                                ; sectors were loaded


LOAD_ALL_FILE:
        mov     cx,     ax      ; save actual index into FAT table
        mov     bp,     1       ; number of sectors to load
        SECTOR_TO_CLUSTER       ; converts ax into a data cluster #
        call    read_sector     ; reads the cluster at ax
        inc     si              ; inc dir entry
        mov     ax,     [BOOT_RECORD.BYTES_PER_SECTOR]
        movzx   di,     [BOOT_RECORD.SECTORS_PER_CLUSTER]
        mul     di 
        add     bx,     ax      ; bx = bx + (BPS * SPC)
        mov     ax,     cx      ; get back our FAT index
        EXTRACT_12_BITS         ; extract the next cluster to load

        cmp     ax,     0FF8h
        jl      LOAD_ALL_FILE


        ret                     ; return to called
LOAD_FILE       ENDP
        FILE_NOT_FOUND_MSG      DB      7,'INVALID SYSTEM DISK!'



;************************************
;DESC: writes string to screen
;IN: si = offset string; cx = string size
;OUT: nothing
;SAVES: NONE
;MISC: Never returns if BOOT STRAPED
;************************************

WRITE_STRING    PROC
  mov   ah,     0Eh             ; function: write teletype

DO_CHARS:
  lodsb                         ; load al with es:si
  int   10h                     ; print char
  loop  DO_CHARS                ; print rest of chars


IF LOADER_SEG EQ 100h           ; exit if assembled for com
  mov   ax,     4C00h           
  int   21h
ENDIF

IF LOADER_SEG EQ 7C00h          ; infinity loop if assembled for
NEVER_RETURN:                   ; loader
  jmp   short NEVER_RETURN      ; make it so
ENDIF

WRITE_STRING    ENDP


        DISK_ERROR_MSG  DB      7,'FATAL DISK ERROR!'


IF LOADER_SEG EQ 100h
clean_up_for_dos        proc    ; clears memory area's, etc...
        cli
        mov     eax,    esp
        xor     esp,    esp
        mov     sp,     ax
        xor     eax,    eax
        xor     ebx,    ebx
        xor     ecx,    ecx
        xor     edx,    edx
        xor     esi,    esi
        xor     edi,    edi
        xor     ebp,    ebp


        mov     ax,     FAT_SEG
        mov     es,     ax
        mov     di,     FAT_OFS
        mov     ax,     00101h
        mov     cx,     8000/2
        rep     stosw

        mov     ax,     DIR_SEG
        mov     es,     ax
        mov     di,     DIR_OFS
        mov     ax,     00101h
        mov     cx,     8000/2
        rep     stosw

        mov     ax,     FILE_SEG
        mov     es,     ax
        mov     di,     FILE_OFS
        mov     ax,     0101h
        mov     cx,     8000/2
        rep     stosw
        ret
clean_up_for_dos        endp
ENDIF

IF LOADER_SEG EQ 7C00h
org     07C00h+510
        dw      0AA55h
ENDIF

LOADER ENDS

END LOADER_STARTING_ADDRESS


