/******************************************************************************/
/* Andreas Haack
** BD:290365
**
** Copyright 1995 (C) by Andreas Haack
**
** $Id: install.cmd,v 1.6 1996/06/19 22:27:32 hak Exp hak $
** $Revision: 1.6 $
*******************************************************************************
** Installation of Arieel (C)
**
** $Log: install.cmd,v $
** Revision 1.6  1996/06/19 22:27:32  hak
** dereg-> deinst
**
** Revision 1.5  1996/03/03 21:12:01  hak
** Released Version
**
** Revision 1.4  1996/02/29 09:08:34  hak
** removed brasil and japan
**
** Revision 1.3  1996/02/22 22:20:26  hak
** Luxemburg correted
**
** Revision 1.1  1996/02/20 22:49:36  hak
** Initial revision
**
*******************************************************************************/

trace('O');


/************************************************************
** setup
Brasil_Portuguese       PT_PT    PT
Belgium_French          FR_FR    BE
Belgium_Nederlands      NL_NL    BE
Canada_French           FR_FR    CA
Canada_English          EN_US    CA
Denmark_Danish          DA_DK    DK
Finland_Finnish         FI_FI    FI
France_French           FR_FR    FR
Germany_Deutsch         DE_DE    DE
Iceland_slensk         IS_IS    IS
Italy_Italian           IT_IT    IT
Japan_English           EN_JP    JP
Japan_Japanese          JA_JP    JP
Netherlands_Nederlands  NL_NL    NL
Norway_Norwegian        NO_NO    NO
Portugal_Portuguese     PT_PT    PT
Spain_Espaol           ES_ES    ES
Sweden_Svensk           SV_SE    SE
Switzerland_Deutsch     DE_DE    CH
Switzerland_French      FR_FR    CH
Turkey_Turkish          TR_TR    TR
United Kingdom_English  EN_US    GB
United States_English   EN_US    US -cwm-
************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call 'SysLoadFuncs';


call SysFileTree '.\Arieel.exe', 'matches';

if (matches.0 = 0) then
do
    say "Must be started in directory where Arieel.exe is located!";
    signal ERROR;
end



    call directory('..');

    Object = directory();
    Params = 'OBJECTID=<WPH_ARIEEL>;';
    Params = Params || 'ICONFILE=Icons\Ariell.ico;'
    Params = Params || 'BACKGROUND=(none),,,C,0 206 0;'


    call setupObject;

    Params = 'OPEN=DEFAULT;'

    call setupObject;

    TargetLocation='<WPH_ARIEEL>'
    Class='WPProgram'


    call createArieelObject "Belgium_French",       "FR_FR", "BE", "";
    call createArieelObject "Belgium_Nederlands",   "NL_NL", "BE", "";
    call createArieelObject "Canada_French",        "FR_FR", "CA", "";
    call createArieelObject "Canada_English",       "EN_US", "CA", "";
    call createArieelObject "Denmark",              "DA_DK", "DK", "";
    call createArieelObject "Finland",              "FI_FI", "FI", "";
    call createArieelObject "France",               "FR_FR", "FR", "";
    call createArieelObject "Germany",              "DE_DE", "DE", "";
    call createArieelObject "Iceland",              "IS_IS", "IS", "";
    call createArieelObject "Italy",                "IT_IT", "IT", "-cwm-";
    call createArieelObject "Luxemburg",            "FR_FR", "LX", "";
    call createArieelObject "Netherlands",          "NL_NL", "NL", "";
    call createArieelObject "Norway",               "NO_NO", "NO", "";
    call createArieelObject "Portugal",             "PT_PT", "PT", "-cwm-";
    call createArieelObject "Spain",                "ES_ES", "ES", "-cwm-";
    call createArieelObject "Sweden",               "SV_SE", "SE", "";
    call createArieelObject "Switzerland_Deutsch",  "DE_DE", "CH", "";
    call createArieelObject "Switzerland_French",   "FR_FR", "CH", "";
    call createArieelObject "Turkey",               "TR_TR", "TR", "";
    call createArieelObject "United Kingdom",       "EN_US", "GB", "";
    call createArieelObject "United States",        "EN_US", "US", "-cwm-";



    Title = 'Reset'
    Params =  'ICONFILE=' || Object ||'\Icons\Ariell.ICO;'
    Params =  Params || 'EXENAME=' || Object ||'\Bin\Arieel.exe;'
    Params =  Params || 'PARAMETERS= -xr;'
    call installObject;

    Title='Deinstall'
    Params =  'EXENAME=' || Object ||'\Bin\Arieel.exe;'
    Params =  Params 'ICONFILE=' || Object ||'\Icons\Ariell.ICO;'
    Params =  Params || 'PARAMETERS= -xd;'

    call installObject;


    Title='Arieel Your Gateway to the Time';
    Params = 'EXENAME=view.exe;'
    Params =  Params || 'PARAMETERS=' || Object ||'\Bin\Arieel.inf;'

    call installObject;

signal done;


/************************************************************
** create Arieel Object
************************************************************/

createArieelObject:
parse arg Title, Language, Territory, Extra .
    Params = 'EXENAME='|| Object ||'\Bin\Arieel.exe;';
    Params = Params || 'ICONFILE='|| Object ||'\Icons\'||Territory||'.ICO;';
    Params = Params || 'PARAMETERS= -glng ' || Language || ' -gter ' || Territory || ' ' || Extra || ';';
    Params = Params || 'SET LOCPATH='|| Object ||'\locale;';
    call installObject;
return;

hallo:
say "T: " Title " C:" Class " T:" TargetLocation " P:" Params;
return;

/************************************************************
** install object
***********************************************************/



installObject:
    rc = SysCreateObject( Class, Title, TargetLocation, Params, 'UpdateIfExists' );
    if rc = 0 Then
       do
        say 'ERROR -     Object' Title 'not created.'
        say '            Params:['Params']'
        end;
    else
       do
        say 'success -   Object' Title' created. - done';
        end;
return;

setupObject:
    rc = SysSetObjectData(Object, Params);
    if rc = 0 then
        do
        say 'ERROR -     Object' Object 'not updated.'
        say '            Params:['Params']'
        end;
    else
        do
        say 'success -   Object' Object ' updated. - done';
        end;
return;


FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

ERROR:
say "Error"

DONE:
Exit
