/**************************************************************************
 * Adept REXX Menu Structure - Written by Richard W. Hawley - Erasmus BBS *
 *      FidoNET 1:142/113.0 - Internet hawley_riw@ccsu.ctstateu.edu       *
 **************************************************************************
 * NOTE:  This is an example  REXX script for Adept BBS.  I have tried to *
 * comment when possible.  You may use the C2D() REXX function instead of *
 * simply  using the  ASCii code for  the letters.  My text  editor has a *
 * built in chart, so  I didn't bother.  Also, please  note that  if  you *
 * wish a  pause, use the AdeptSleep() function, not  AdeptPause().  This *
 * will make your REXX scripts CPU friendly.                              *
 **************************************************************************/

Arg line

/* Begin TOP Menu */
Call TodaysCallers

key = AdeptShow(line,1,2,CMDSCRN.ASC,sS)

Sec1=AdeptGetVar(line, 40)  /* Gets the users Sec1 */

SELECT
      WHEN Sec1=5
        THEN DO
               key = AdeptShow(line,1,2,NEWINFO.ASC,X)  /* Shows New User information */
               key = AdeptShow(line,1,2,RULES.ASC,X)    /* Shows BBS rules */
               key = AdeptShow(line,1,2,HELPSCRN.ASC,X) /* Shows Help Screen */
               AdeptCls(line)
               AdeptPrint(line, "{F4You must leave the Sysop an introductory message{FF.\r\n")
               AdeptPrint(line, "{F4Failure to do so will delay your verification{FF.\r\n")
               AdeptPrint(line, "{F4A call back verifier is currently not available for Adept BBS{FF.\r\n")
               AdeptHitReturn(line)
               AdeptPrint(line, "{CS{B2{FG")
               AdeptPrint(line, "From: {U0                                                                 ")
               AdeptPrint(line, "To: {S7                                                                        ")
               AdeptMessage(line, 3, 1, "")
               AdeptWrite(line, 1, 3, "")
               AdeptPrint(line, "{B1{F8")
             END
      WHEN Sec1=10
        THEN DO
               AdeptShow(line,1,2,SEC10.ASC,S)  /* Shows the Please Register Msg */
                                                /* The 2 is a flag that converts */
                                                /* META commands in the files.   */
                                                /* It is not yet in the DOCS.    */
               AdeptSleep(line, 750)
               AdeptPrint(line, "{FG5 ")
               AdeptSleep(line, 750)
               AdeptPrint(line, "{FC4 ")
               AdeptSleep(line, 750)
               AdeptPrint(line, "{F43 ")
               AdeptSleep(line, 750)
               AdeptPrint(line, "{FA2 ")
               AdeptSleep(line, 750)
               AdeptPrint(line, "{F21\r\n ")
               AdeptPrint(line, "{PC")
             END
      WHEN Sec1=500
        THEN key = AdeptShow(line,1,2,VSYSOP.ASC,sS)  /* Shows visiting sysop screen */
      OTHERWISE
END



key = AdeptShow(line,1,2,PRIV.ASC,sS)
key = AdeptShow(line,1,2,ERASNEWS.ASC,sS)
key = AdeptShow(line,1,2,SCINET.ASC,sS)
key = AdeptShow(line,1,2,SALE.ASC,sS)

CALL MainMenu
/* End TOP Menu */

/***************************************************************************/

/* Begin MAIN Menu */
MainMenu:
Menu = 1

key=AdeptShow(line,1,2,MAINMENU.ASC,fmbdplxyg)
SELECT
        WHEN key=1
          THEN CALL FileRoom

        WHEN key=2
          THEN CALL MailRoom

        WHEN key=3
          THEN CALL Bulletin

        WHEN key=4
          THEN CALL Doors

        WHEN key=5
          THEN AdeptMenuType(line, 48, "")

        WHEN key=6
          THEN DO
                 AdeptMessage(line, 3, 1, "")
                 AdeptWrite(line, 1, 3, "")
               END

        WHEN key=7
          THEN DO
                 AdeptPrint(line,"{CS{FGWelcome to Erasmus First National.\r\n Please deposit all firearms at the courtesy desk.")
                 AdeptMenuType(line,10,xbank.cmd)
               END

        WHEN key=8
          THEN CALL YourSettings

        WHEN key=9
          THEN CALL LogOff

        WHEN key=10
          THEN CALL FastBye

        OTHERWISE
          NOP
END

key = AdeptWaitKey(line)
adeptsleep(line,32)

SELECT
        WHEN (key=70) | (key=102)               /* =F or f */
          THEN CALL FileRoom

        WHEN (key=77) | (key=109)               /* =M or m */
          THEN CALL MailRoom

        WHEN (key=66) | (key=98)                /* =B or b */
          THEN CALL Bulletin

        WHEN (key=68) | (key=100)               /* =D or d */
          THEN CALL Doors

        WHEN (key=80) | (key=112)               /* =P or p */
          THEN AdeptMenuType(line, 48, "")      /* Page Sysop */

        WHEN (key=76) | (key=108)               /* =L or l */
          THEN DO
                 AdeptMessage(line, 3, 1, "")   /* Go to msg area 1 */
                 AdeptWrite(line, 1, 3, "")     /* Start the editor */
               END

        WHEN (key=89) | (key=121)               /* =Y or y */
          THEN CALL YourSettings

        WHEN (key=84) | (key=116)               /* =T or t */
          THEN DO
                 AdeptShow(line,1,2,CALLERS.ASC,X)
                 AdeptHitReturn(line)
               END

        WHEN (key=88) | (key=120)               /* =X or x */
          THEN DO
                 AdeptPrint(line,"{CS{FGWelcome to Erasmus First National.\r\n Please deposit all firearms at the courtesy desk.")
                 AdeptMenuType(line,10,xbank.cmd)
               END

        WHEN (key=63)                           /* =? */
          THEN AdeptShow(line,1,2,HELPSCRN.ASC,sS)

        WHEN (key=71) | (key=103)               /* =G or g */
          THEN CALL LogOff

        WHEN key=95
          THEN CALL FastBye                     /* Fast Logoff */

        WHEN (Sec1=1000) & (key=46)
          THEN AdeptMenuType(line,800,"C:\\OS2\\CMD.EXE /C","D:\\ADEPT\\TEMP.CMD")

        OTHERWISE
          CALL NOTACMD
END

CALL MainMenu
/* End MAIN Menu */

/***************************************************************************/

/* Begin FILE Menu */
FileRoom:
Menu = 2

AdeptCls(line)
key=AdeptShow(line,1,2,FILEROOM.ASC,plsnvdue)

SELECT
        WHEN key=1
          THEN AdeptMenuType(line, 61, "")

        WHEN key=2
          THEN AdeptMenuType(line, 70, "")

        WHEN key=3
          THEN AdeptMenuType(line, 71, "")

        WHEN key=4
          THEN AdeptMenuType(line, 73, "")

        WHEN key=5
          THEN AdeptMenuType(line, 80, "")

        WHEN key=6
          THEN AdeptMenuType(line, 85, "")

        WHEN key=7
          THEN AdeptMenuType(line, 90, "")

        WHEN key=8
          THEN AdeptMenuType(line, 670, "")

        WHEN key=9
          THEN CALL MailRoom

        WHEN key=10
          THEN CALL MainMenu

        OTHERWISE
END

AdeptSleep(line, 32)
key=AdeptWaitkey(line)

SELECT

        WHEN (key=80) | (key=112)                  /* =P or p */
          THEN AdeptMenuType(line, 61, "")         /* Pick file area */

        WHEN (key=76) | (key=108)                  /* =L or l */
          THEN AdeptMenuType(line, 78, "")         /* List files in area */

        WHEN (key=83) | (key=115)                  /* =S or s */
          THEN AdeptMenuType(line, 76, "")         /* Search files in area */

        WHEN (key=78) | (key=110)                  /* =N or n */
          THEN AdeptMenuType(line, 74, "")         /* New files */

        WHEN (key==86) | (key=118)                 /* =V or v */
          THEN AdeptMenuType(line, 80, "")         /* View archive */

        WHEN (key=68) | (key=100)                  /* =D or d */
          THEN AdeptMenuType(line, 85, "")         /* Download */

        WHEN (key=85) | (key=117)                  /* =U or u */
          THEN AdeptMenuType(line, 90, "")         /* Upload */

        WHEN (key=69) | (key=101)                  /* =E or e */
          THEN AdeptMenuType(line, 670, "")        /* Edit tagged list */

        WHEN (key=77) | (key=109)                  /* =M or m */
          THEN CALL MailRoom

        WHEN (key=27) | (key=45)                  /* <ESC> */
          THEN CALL MainMenu

        WHEN (key=63)                           /* =? */
          THEN AdeptShow(line,1,2,HELPSCRN.ASC,sS)

        WHEN (key=71) | (key=103)                  /* =G or g */
          THEN CALL Logoff

        WHEN key=95                                /* =_ (underscore char) */
          THEN CALL FastBye                        /* Fast Logoff */

        OTHERWISE
          CALL NOTACMD
END

CALL FileRoom
/* End FILE Menu */

/***************************************************************************/

/* Begin MAIL Menu */
MailRoom:
Menu = 3

AdeptCls(line)
key=AdeptShow(line,1,2,MAILROOM.ASC,preodufq)

SELECT
        WHEN key=1
          THEN AdeptMenuType(line, 60, "")

        WHEN key=2
          THEN AdeptRead(line, 1, , 1)

        WHEN key=3
          THEN AdeptWrite(line, 1,, "")

        WHEN key=4
          THEN CALL Offline

        WHEN key=5
          THEN DO
                 AdeptMenuType(line, 35, "")
               END

        WHEN key=6
          THEN DO
                 AdeptMenuType(line, 36, "")
               END

        WHEN key=7
          THEN CALL FileRoom

        WHEN key=8
          THEN CALL MainMenu

        OTHERWISE
END

AdeptSleep(line, 32)
key=AdeptWaitkey(line)

SELECT
        WHEN (key=80) | (key=112)                  /* =P or p */
          THEN AdeptMenuType(line, 60, "")         /* Pick msg area */

        WHEN (key=82) | (key=114)                  /* =R or r */
          THEN AdeptMenuType(line, 20, "")         /* Read a msg */

        WHEN (key=69) | (key=101)                  /* =E or e */
          THEN AdeptWrite(line, 1,, "")            /* Enter a msg */

        WHEN (key=83) | (key=115)                  /* =S or s */
          THEN AdeptMenuType(line, 17)             /* Scan messages */

        WHEN (key=81) | (key=113)                  /* =Q or q */
          THEN AdeptMenuType(line, 16)             /* Quickscan messages */

        WHEN (key=79) | (key=111)                  /* =O or o */
          THEN CALL OffLine

        WHEN (key=68) | (key=100)                  /* =D or d */
          THEN DO
                 AdeptMenuType(line, 35, "")
               END

        WHEN (key=85) | (key=117)                  /* =U or u */
          THEN DO
                 AdeptMenuType(line, 36, "")
               END

        WHEN (key=70) | (key=102)                  /* =F or f */
          THEN CALL FileRoom

        WHEN (key=27) | (key=45)
          THEN CALL MainMenu

        WHEN (key=71) | (key=103)                  /* =G or g */
          THEN CALL Logoff

        WHEN (key=63)                              /* =? */
          THEN AdeptShow(line,1,2,HELPSCRN.ASC,sS)

        WHEN key=62                                /* = > */
          THEN AdeptMessage(line,5,,"")            /* Goto next area */

        WHEN key=60                                /* = < */
          THEN AdeptMessage(line,6,,"")            /* Goto next area */


        WHEN key=95                                /* =_ */
          THEN CALL FastBye                        /* Fast logoff */

        OTHERWISE
          CALL NOTACMD
END

CALL MailRoom
/* End MAIL Menu */

/***************************************************************************/

/* Begin OFFline Menu */
OffLine:

key=AdeptShow(line,1,2,OFFline.ASC,q)

IF key=1 THEN RETURN

AdeptSleep(line, 32)

key=AdeptWaitkey(line)
SELECT

        WHEN (key=85) | (key=117)                  /* =U or u */
          THEN AdeptMenuType(line, 702, "")        /* Update msg areas */

        WHEN (key=65) | (key=97)                   /* =A or a */
          THEN AdeptMenuType(line, 166, "")        /* Change archiver */

        WHEN (key=77) | (key=109)                  /* =M or m */
          THEN AdeptMenuType(line, 632, "")        /* Toggle mail monitoring */

        WHEN (key=67) | (key=99)                   /* =C or c */
          THEN AdeptMenuType(line, 701, "")        /* Clear ALL tagged areas */

        WHEN (key=70) | (key=102)                  /* =F or =f */
          THEN AdeptMenuType(line, 155, "")        /* Mail format */

        WHEN (key=84) | (key=116)                  /* =T or t */
          THEN AdeptMenuType(line, 700, "")        /* Tag ALL areas */

        WHEN (key=27) | (key=45)
          THEN CALL MailRoom

        OTHERWISE
          CALL NOTACMD
END

CALL OffLine
/* End OFFline Menu */

/***************************************************************************/

/* Begin DOORS Menu */
Doors:
Menu = 4

AdeptCls(line)
key=AdeptShow(line,1,2,DOORS.ASC,1234567890fm)

SELECT

        WHEN key=1
          THEN DO
                 AdeptPrint(line, "{CS{F4Don't panic, loading {FFTrade Wars 2002{F4!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C tw2002.cmd {LN")
               END

        WHEN key=2
          THEN DO
                 AdeptPrint(line, "{CS{F4Relax, I'm looking for the {F5Dragon{F4..")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C lord{LN.cmd {LN")
               END

        WHEN key=3
          THEN DO
                 AdeptPrint(line, "{CS{F2At last, the {FCChild of Peace {F2 has arrived..")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Planets.Cmd {LN")
               END

        WHEN key=4
          THEN DO
                 AdeptPrint(line, "{CS{F2Trade Wars/2!  The {FCORIGINAL {F2 Trade Wars door game!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Tw2.Cmd {LN {H0")
               END

        WHEN key=5
          THEN DO
                 AdeptPrint(line, "{CS{F4Stand by for {FBSEX{F4, {FBDRUGS{F4, and {FBSTEEL GAUNTLETS{F4!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Usurper.Cmd {LN")
               END

        WHEN key=6
          THEN DO
                 AdeptShow(line,1,2,MELEE.ASC,sS)
               END

        WHEN key=7
          THEN DO
                 AdeptPrint(line, "{CS{FEGreetings my lord Baron...")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Bre.Cmd {LN")
               END

        WHEN key=8
          THEN DO
                 AdeptPrint(line, "{CS{F4Are you prepared to spit teeth?")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Hockey.Cmd {LN")
               END

        WHEN key=9
          THEN DO
                 AdeptPrint(line, "{CS{FEJust how {FGSICK {FE are you? {FG<{F9grin{FG>")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Kink.Cmd {LN")
               END

        WHEN key=10
          THEN DO
                 AdeptPrint(line, "{CSIt ain't workin'!!!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Vga.Cmd {LN")
               END

        WHEN key=11
          THEN CALL FileRoom

        WHEN key=12
          THEN CALL MailRoom

        WHEN key=13
          THEN CALL MainMenu

        OTHERWISE
END

AdeptSleep(line, 32)
key=AdeptWaitkey(line)

SELECT
        WHEN key=49
          THEN DO
                 AdeptPrint(line, "{CS{F4Don't panic, loading {FFTrade Wars 2002{F4!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C tw2002.cmd {LN")
               END

        WHEN key=50
          THEN DO
                 AdeptPrint(line, "{CS{F4Relax, I'm looking for the {F5Dragon{F4..")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C lord{LN.cmd {LN")
               END

        WHEN key=51
          THEN DO
                 AdeptPrint(line, "{CS{F2At last, the {FCChild of Peace {F2 has arrived..")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Planets.Cmd {LN")
               END

        WHEN key=52
          THEN DO
                 AdeptPrint(line, "{CS{F2Trade Wars/2!  The {FCORIGINAL {F2 Trade Wars door game!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Tw2.Cmd {LN {H0")
               END

        WHEN key=53
          THEN DO
                 AdeptPrint(line, "{CS{F4Stand by for {FBSEX{F4, {FBDRUGS{F4, and {FBSTEEL GAUNTLETS{F4!")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Usurper.Cmd {LN")
               END

        WHEN key=54
          THEN DO
                 AdeptShow(line,1,2,MELEE.ASC,sS)
               END

        WHEN key=55
          THEN DO
                 AdeptPrint(line, "{CS{FEGreetings my lord Baron...")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Bre.Cmd {LN")
               END

        WHEN key=56
          THEN DO
                 AdeptPrint(line, "{CS{F4Are you prepared to spit teeth?")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Hockey.Cmd {LN")
               END

        WHEN key=57
          THEN DO
                 AdeptPrint(line, "{CS{FEJust how {FGSICK {FE are you? {FG<{F9grin{FG>")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Kink.Cmd {LN")
               END

        WHEN key=48
          THEN DO
                 AdeptPrint(line, "{CSDoes it work?")
                 AdeptMenuType(line, 801, "C:\\OS2\\CMD.EXE /C Vga.Cmd {LN")
               END


        WHEN (key=70) | (key=102)               /* =F or f */
          THEN CALL FileRoom

        WHEN (key=77) | (key=109)               /* =M or m */
          THEN CALL MailRoom

        WHEN (key=27) | (key=45)
          THEN CALL MainMenu

        WHEN (key=63)                              /* =? */
          THEN AdeptShow(line,1,2,HELPSCRN.ASC,sS)

        WHEN (key=71) | (key=103)
          THEN CALL Logoff

        WHEN key=95
          THEN CALL FastBye

        OTHERWISE
          CALL NOTACMD
END

CALL Doors
/* End DOORS Menu */

/***************************************************************************/

/* Begin TimeBank */
TimeBank:

AdeptShow(line,1,2,XBANK.ASC,X)

AdeptSleep(line,32)

key=AdeptWaitkey(line)

SELECT
        WHEN (key=68) | (key=100)                /* =D or d */
          THEN AdeptMenuType(line, 167, "")      /* Deposit Time */

        WHEN (key=87) | (key=119)                /* =W or w */
          THEN AdeptMenuType(line, 168, "")      /* Withdraw time */

        WHEN (key=27) | (key=45)                 /* =<ESC> or - */
          THEN CALL Doors                        /* Return to doors */

        OTHERWISE
          CALL NOTACMD
END

CALL TimeBank
/* End TimeBank */

/***************************************************************************/

/* Begin BULLETIN Menu */
Bulletin:

key=AdeptShow(line,1,2,BULLETIN.ASC,q)

AdeptSleep(line, 32)
key=AdeptWaitkey(line)

SELECT
        WHEN key=49                              /* =1 */
          THEN AdeptShow(line,1,2,NEWS.ASC,X)

        WHEN key=50                              /* =2 */
          THEN AdeptShow(line,1,2,SALE.ASC,X)

        WHEN key=52                              /* =4 */
          THEN AdeptShow(line,1,2,SECLEVEL.ASC,X)

        WHEN key=53                              /* =5 */
          THEN AdeptPrint(line, "Sorry, can't find WARP2.ANN")

        WHEN key=54                              /* =6 */
          THEN AdeptShow(line,1,2,LORD.ASC,X)

        WHEN key=55
          THEN AdeptShow(line,1,2,TWTRADE.TXT,X)

        WHEN key=56
          THEN AdeptShow(line,1,2,TWCORP.TXT,X)

        WHEN key=57
          THEN AdeptShow(line,1,2,BRE.ASC,X)

        WHEN (key=63)                            /* =? */
          THEN AdeptShow(line,1,2,HELPSCRN.ASC,sS)

        WHEN (key=13) | (key=27) | (key=45)      /* =<ENTER>, <ESC>, or - */
          THEN CALL MainMenu

        WHEN key=95
          THEN CALL FastBye

        OTHERWISE
          CALL NOTACMD
END

CALL Bulletin
/* End BULLETIN Menu */

/***************************************************************************/

/* Begin Your Settings Menu */
YourSettings:

AdeptShow(line,1,2,SETTINGS.ASC,X)

key=AdeptWaitkey(line)
AdeptSleep(line, 32)

SELECT
        WHEN (key=65) | (key=97)                   /* =A or a */
          THEN AdeptMenuType(line,130, "")         /* Address */

        WHEN (key=67) | (key=99)                   /* =C or c */
          THEN AdeptMenuType(line,131, "")         /* Color */

        WHEN (key=72) | (key=104)                  /* =H or h */
          THEN AdeptMenuType(line,132, "")         /* High ASCii */

        WHEN (key=73) | (key=105)                  /* =I or i */
          THEN AdeptMenuType(line,133, "")         /* Input */
        
        WHEN (key=76) | (key=108)                  /* =L or l */
          THEN AdeptMenuType(line,134, "")         /* Screen Length */

        WHEN (key=77) | (key=109)                  /* =M or m */
          THEN AdeptMenuType(line,135, "")         /* More prompts */

        WHEN (key=78) | (key=110)                  /* =N or n */
          THEN AdeptMenuType(line,136, "")         /* Name/Handle */

        WHEN (key=80) | (key=112)                  /* =P or p */
          THEN AdeptMenuType(line,137, "")         /* Password */

        WHEN (key=87) | (key=119)                  /* =W or w */
          THEN AdeptMenuType(line,138, "")         /* Screen Width */

        WHEN key=35                                /* =# */
          THEN AdeptMenuType(line,139, "")         /* Phone number */

        WHEN (key=85) | (key=117)                  /* =U or u */
          THEN AdeptMenuType(line,141, "")         /* User Record Info */

        WHEN (key=69) | (key=101)                  /* =E or e */
          THEN AdeptMenuType(line,142, "")         /* Expert/Novice */

        WHEN key=33                                /* = ! */
          THEN AdeptMenuType(line,631, "")         /* Avatar */

        WHEN (key=70) | (key=102)                  /* =F or f */
          THEN AdeptMenuType(line,154, "")         /* Full Screen Editor */

        WHEN (key=81) | (key=113)                  /* =Q or q */
          THEN DO
                 AdeptMenuType(line,2, "")           /* Quit Editing */
                 CALL MainMenu
               END

        OTHERWISE
          CALL NOTACMD
END

CALL YourSettings
/* End Your Settings Menu */
 
/***************************************************************************/

TodaysCallers:

ansifile = 'd:\adept\text\callers.ans'
asciifile = 'd:\adept\text\callers.asc'

name = adeptgetvar(line,1)
node = adeptgetvar(line,201)
calls = adeptgetvar(line,30)

do 3
readdate = linein(asciifile)
end

filedate = word(readdate,4)
today = DATE("U")
a = compare(filedate,today)

if a > 0
  then do
         lineout(asciifile,'   Ŀ',1)
         lineout(asciifile,'                                 Erasmus BBS                             ')
         lineout(asciifile,'                            Callers for 'today'                         ')
         lineout(asciifile,'   ')
         lineout(asciifile,'       Name                         Node                  No. of Calls')
         lineout(asciifile,'      ')

         lineout(ansifile,'{CS   [0;36mĿ',1)
         lineout(ansifile,'   [0;36m                              Erasmus BBS                             ')
         lineout(ansifile,'   [0;36m                         Callers for [1;33m'DATE("U")'                         [0;36m')
         lineout(ansifile,'   [0;36m')
         lineout(ansifile,'   [1;33m    Name                         Node                  No[0;36m. [1;33mof Calls')
         lineout(ansifile,'   [0;36m   ')
       end

c1 = insert(name,'',6,36)
c2 = insert(node,c1,38,1)
c3 = insert(calls,c2,61,6)
caller = lineout(asciifile,c3)

caller = lineout(ansifile,'[0;36m'c3)

return

/***************************************************************************/

/* Begin LOGOFF Menu */
LogOff:
key=AdeptShow(line,1,2,LOGOFF.ASC,gnl)

SELECT
        WHEN key=1 THEN
          DO
            AdeptShow(line,1,2,SEEYA.ASC)
            CALL FastBye
          END

        WHEN key=2
            THEN CALL Menu

        WHEN key=3 THEN
            DO
              AdeptMessage(line, 3, 1)
              AdeptWrite(line, 1, 3)
            END

        OTHERWISE NOP
END

AdeptSleep(line, 32)
key=AdeptWaitkey(line)
SELECT
        WHEN (key=71) | (key=103)
          THEN DO
                 AdeptShow(line,1,2,SEEYA.ASC,S)
                 AdeptSleep(line, 64)
                 AdeptMenuType(line, 1001, "")
                 EXIT
               END

        WHEN (key=78) | (key=110)
            THEN DO
                   IF Menu = 1 THEN CALL MainMenu
                   IF Menu = 2 THEN CALL FileRoom
                   IF Menu = 3 THEN CALL MailRoom
                   IF Menu = 4 THEN CALL Doors
                 END

        WHEN (key=76) | (key=108)
            THEN DO
                   AdeptMessage(line, 3, 1, "")
                   AdeptWrite(line, 1, 3, "")
                 END

        OTHERWISE
          CALL NOTACMD
END

CALL LogOff
/* End LOGOFF Menu */

/***************************************************************************/

/* Fastbye */
Fastbye:

AdeptPrint(line, "{F9Click!")
AdeptMenuType(line, 1001, "")
EXIT

/***************************************************************************/

/* Invalid key Command */
NOTACMD:
/* Generate a random number between 1 and 3. */
rand = RANDOM(1,3)
SELECT
        WHEN rand = 1
          THEN AdeptPrint(line, "{F4'{FF",D2C(KEY),"{F4' isn't a command!")

        WHEN rand = 2
          THEN AdeptPrint(line, "{F4You hit '{FF",D2C(KEY),"{F4'. That's not an option!")

        OTHERWISE
          AdeptPrint(line, "{F4You hit '{FF",D2C(KEY),"{F4', which is not a valid option.")
END

AdeptSleep(line, 1000)
RETURN

/* End REXX Script */
EXIT
