#include <stdio.h>
#include <os2.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <fcntl.h>
#include <share.h>


#define bit   unsigned
#define sword signed short
#define word  unsigned short
#define dword long
#define byte  unsigned char

#define MAX_ALEN         10     /* Max length of usr.msg[] and usr.files[]  */

/* Masks for usr.bits1, below */

#define BITS_HOTKEYS     0x0001 /* Hotkeys, independent of HOTFLASH level   */
#define BITS_NOTAVAIL    0x0002 /* If set, user is NOT normally available   *
                                 * for chat.                                */
#define BITS_FSR         0x0004 /* Full-screen reading in msg areas         */
#define BITS_NERD        0x0008 /* Yelling makes no noise on sysop console  */
#define BITS_NOULIST     0x0010 /* Don't display name in userlist           */
#define BITS_TABS        0x0020 /* Reserved                                 */
#define BITS_BIT6        0x0040 /* Reserved                                 */
#define BITS_BIT7        0x0080 /* Reserved                                 */


/* Masks for usr.bits2, below */

#define BITS2_BADLOGON   0x0001 /* MAX: if user's last logon attempt was bad*/
#define BITS2_IBMCHARS   0x0002 /* MAX: if user can receive high-bit chars  */
#define BITS2_RSVD1      0x0004 /* MAX: *obsolete* 1.02 avatar flag         */
#define BITS2_BORED      0x0008 /* Use the line-oriented editor             */
#define BITS2_MORE       0x0010 /* Wants the "MORE?" prompt                 */
#define BITS2_RSVD2      0x0020 /* OPUS: set=wants Ansi                     */
#define BITS2_CONFIGURED 0x0040 /* OPUS: set=used Maximus before            */
#define BITS2_CLS        0x0080 /* OPUS: set=transmit ^L, clear=ignore ^L   */
#define BITS2_BIT8       0x0100 /* used to be 'usr.keys'                    */
#define BITS2_BIT9       0x0200 /* used to be 'usr.keys'                    */
#define BITS2_BITA       0x0400 /* used to be 'usr.keys'                    */
#define BITS2_BITB       0x0800 /* used to be 'usr.keys'                    */
#define BITS2_BITC       0x1000 /* used to be 'usr.keys'                    */
#define BITS2_BITD       0x2000 /* used to be 'usr.keys'                    */
#define BITS2_BITE       0x4000 /* used to be 'usr.keys'                    */
#define BITS2_BITF       0x8000 /* used to be 'usr.keys'                    */


/* Masks for usr.delflag, below */

#define UFLAG_DEL   0x01
#define UFLAG_PERM  0x02

/* Masks for usr.xp_flag, below */

#define XFLAG_EXPDATE    0x0001 /* Use the xp_date to control access        */
#define XFLAG_EXPMINS    0x0002 /* Use the xp_mins number to control access */
#define XFLAG_DEMOTE     0x0004 /* Demote user to priv level in usr.xp_priv */
#define XFLAG_AXE        0x0008 /* Just hang up on user                     */

/* Constants for usr.video, below */

#define GRAPH_TTY         0x00 /* The current user's graphics setting...    */
#define GRAPH_ANSI        0x01 
#define GRAPH_AVATAR      0x02

#define TWIT        -2 /* 0xFFFE */
#define DISGRACE    0x0000
#define LIMITED     0x0001  /**/
#define NORMAL      0x0002
#define WORTHY      0x0003  /**/
#define PRIVIL      0x0004
#define FAVORED     0x0005  /**/
#define EXTRA       0x0006
#define CLERK       0x0007  /**/
#define ASSTSYSOP   0x0008
#define SYSOP       0x000A
#define HIDDEN      0x000b

#define GRAPH_TTY         0x00 /* The current user's graphics setting...    */
#define GRAPH_ANSI        0x01 
#define GRAPH_AVATAR      0x02

/* user[cp]->attribs */

#define U_ANSI            0x00000001
#define U_COLOR           0x00000002
#define U_HIGHASCII       0x00000004
#define U_NOMORE          0x00000008
#define U_NOCLEAR         0x00000010
#define U_COLD            0x00000020
#define U_NOSHOWADDRESS   0x00000040
#define U_NOSHOWPHONE     0x00000080
#define U_NOSHOWREAL      0x00000100
#define U_NOKILL          0x00000200
#define U_DELETED         0x00000400
#define U_EXPERT          0x00000800
#define U_TWIT            0x00001000
#define U_NEWFILES        0x00002000
#define U_NEWMSGS         0x00004000
#define U_DLNEWMSGS       0x00008000
#define U_DLNEWFILELIST   0x00010000
#define U_SEENEWS         0x00020000
#define U_ASKDL           0x00040000
#define U_NOVICE          0x00080000
#define U_NOROLL          0x00100000
#define U_POINTONLY       0x00200000
#define U_LOCKEDOUT       0x00400000
#define U_AVAILABLE       0x00800000
#define U_LISTPROTECTED   0x01000000
#define U_MISCNEWSOK      0x02000000
#define U_LIMITFLIST      0x04000000
#define U_EBCDIC          0x08000000
#define U_VERIFIED        0x10000000  // user call back verified, turn this off, they get
                                      // verified again.. (if BBS verifies)
#define U_ANSITE2         0x20000000
#define U_RIPSCRIPT       0x40000000
#define U_AVATAR          0x80000000

/* user[cp]->attribs2*/

#define U2_FSE            0x00000001
#define U2_OFF_AFTER_MAIL 0x00000002
#define U2_MONITOR_MAIL   0x00000004
#define U2_INT_NEW_FILES  0x00000008
#define U2_INC_BULLETS    0x00000010
#define U2_INC_WELCOME    0x00000020
#define U2_DEFAULT_QWK    0x00000040
#define U2_DEFAULT_FIDO   0x00000080
#define U2_DEFAULT_TEXT   0x00000100
#define U2_DEFAULT_BLUE   0x00000200
#define U2_AVTANS         0x00000400
#define U2_8DOT3          0x00000800

typedef struct   _max_usr
{
    byte name[36];        /* Caller's name                                */
    byte city[36];        /* Caller's location                            */

    byte alias[21];       /* MAX: user's alias (handle)                   */
    byte phone[15];       /* MAX: user's phone number                     */

    word lastread_ptr;    /* MAX: a num which points to offset in LASTREAD*/
                            /* file -- Offset of lastread pointer will be   */
                            /* lastread_ptr*sizeof(int).                    */

    word timeremaining;   /* MAX: time left for current call (xtern prog) */

    byte pwd[16];         /* Password                                     */
    word times;           /* Number of previous calls to this system      */
    byte help;            /* Help level                                   */
    byte rsvd1[2];        /* Reserved by Maximus for future use           */
    byte video;           /* user's video mode (see GRAPH_XXXX)           */
    byte nulls;           /* Number of Nulls (delays) after <cr>          */

    byte bits;            /* Bit flags for user (number 1)                */

    word rsvd2;           /* Reserved by Maximus for future use           */

    word bits2;           /* Bit flags for user (number 2)                */

    sword priv;           /* Access level                                 */
    byte rsvd3[19];       /* Reserved by Maximus for future use           */
    byte struct_len;      /* len of struct, divided by 20. SEE ABOVE!     */

    word time;            /* Time on-line so far today                    */

    word delflag;         /* Used to hold baud rate for O)utside command  */
                            /* In USER.BBS, usr.flag uses the constants     */
                            /* UFLAG_xxx, defined earlier in this file.     */
      
    byte rsvd4[8];        /* Reserved by Maximus for future use           */

    byte width;           /* Width of the caller's screen                 */
    byte len;             /* Height of the caller's screen                */
    word credit;          /* Matrix credit, in cents                      */
    word debit;           /* Current matrix debit, in cents               */

    word  xp_priv;        /* Priv to demote to, when time or minutes run  */
                            /* out.                                         */

//    union stamp_combo xp_date;  /* Bit-mapped date of when user expires.  */
                                  /* If zero, then no expiry date.          */
     long xp_date;  /* Bit-mapped date of when user expires.  */
                                  /* If zero, then no expiry date.          */
 
    dword xp_mins;        /* How many minutes the user has left before    *
                             * expiring.                                    */

    byte  xp_flag;        /* Flags for expiry.  See above XFLAG_XXX defs. */
    byte  xp_rsvd;

//    union stamp_combo ludate;   /* Bit-mapped date of user's last call    */

    long ludate;   /* Bit-mapped date of user's last call    */

    dword xkeys;          /* User's keys (all 32 of 'em)                  */
    byte  lang;           /* The user's current language #                */
    byte def_proto;      /* Default file-transfer protocol               */

    dword up;             /* K-bytes uploaded, all calls                  */
    dword down;           /* K-bytes downloaded, all calls                */
    dword downtoday;      /* K-bytes downloaded, today                    */

    byte msg[MAX_ALEN];   /* User's last msg area (string)                */
    byte files[MAX_ALEN]; /* User's last file area (string)               */

    byte compress;        /* Default compression program to use           */

    byte rsvd5;
    dword extra;

} MAXUSER, *PMAXUSER;

typedef struct   _Start_File
{
    char name[36];        /* Caller's name                                */
    char city[36];        /* Caller's location                            */

    char alias[21];       /* MAX: user's alias (handle)                   */
    char phone[15];       /* MAX: user's phone number                     */

    short lastread_ptr;    /* MAX: a num which points to offset in LASTREAD*/
                            /* file -- Offset of lastread pointer will be   */
                            /* lastread_ptr*sizeof(int).                    */

    short timeremaining;   /* MAX: time left for current call (xtern prog) */

    char pwd[16];         /* Password                                     */
    short times;           /* Number of previous calls to this system      */
    char help;            /* Help level                                   */
    char rsvd1[2];        /* Reserved by Maximus for future use           */
    char video;           /* user's video mode (see GRAPH_XXXX)           */
    char nulls;           /* Number of Nulls (delays) after <cr>          */

    char bits;            /* Bit flags for user (number 1)                */

    short rsvd2;           /* Reserved by Maximus for future use           */

    short bits2;           /* Bit flags for user (number 2)                */

    short priv;           /* Access level                                 */
    char rsvd3[19];       /* Reserved by Maximus for future use           */
    char struct_len;      /* len of struct, divided by 20. SEE ABOVE!     */

} MAXBEGIN, *PMAXBEGIN;

typedef struct _user_info
{
    UCHAR       name[36];
    UCHAR       handle[36];
    UCHAR       address[60];
    UCHAR       address1[60];
    UCHAR       address2[60];
    UCHAR       city[20];
    UCHAR       state[5];
    UCHAR       zipcode[10];
    UCHAR       home_phone[21];
    UCHAR       data_phone[21];
    UCHAR       fax_phone[21];
    UCHAR       bus_phone[21];
    UCHAR       interests[78];
    UCHAR       SysOpComment[78];
    USHORT      BankTime;
    USHORT      computer_type;
    ULONG       userid;
    USHORT      pointid;
    time_t      initial_logon;
    time_t      expires;
    time_t      last_logon;
    time_t      logon_today;
    USHORT      birthyear;
    UCHAR       birthmonth;
    UCHAR       birthday;
    UCHAR       Gender;
    LONG        credit;
    LONG        minlimit;
    LONG        Group;           // must match Group->Number
    ULONG       CurrLastRead;    // last Read for current msg area
    ULONG       time_today;      // seconds used today
    ULONG       time_per_day;    // minutes allowed per day
    ULONG       time_per_call;   // minutes per call  0=just per day
    ULONG       numcalls;
    ULONG       ulnum;           // files uploaded (ever)
    ULONG       dlnum;           // files downloaded (ever)
    ULONG       ulk;             // UL in K (ever)
    ULONG       dlk;             // DL in K (ever)
    ULONG       uktoday;         // UL in K Today 
    ULONG       dktoday;         // DL in K Today
    ULONG       ukperday;        // Max UL K Per day
    ULONG       dkperday;        // Max DL K Per day
    ULONG       numposts;
    ULONG       security1;
    ULONG       security2;
    ULONG       flags1;
    ULONG       flags2;
    ULONG       attribs;
    ULONG       attribs2;    
    USHORT      length;
    USHORT      width;
    USHORT      lastmsgarea;
    USHORT      lastfilearea;
    UCHAR       lastprotocol;
    UCHAR       lastarchiver;
    LONG        forsysop;
    UCHAR       interface;
    UCHAR       exp;
    USHORT      leech_percent;
    USHORT      MaxBankTime;
    SHORT       TimeCredit;    // can be negative or positive
    SHORT       CallsToday;
    LONG        TotalMinsEver;
    LONG        NetmailDebits;
    time_t      LastPWChange;
    time_t      LastListedNewFiles;
    UCHAR       _Unused[106];
    UCHAR       OfflineMailTags[128];
    UCHAR       usermsg[128];
    UCHAR       userfile[128];
    ULONG       PasswordCRC;
    ULONG       PasswordCRC2;
    USHORT      Max_Mail_Pkt;
    CHAR        ReAsked;      // TRUE if reasked question were answered
    char        Reserved[75];

} USER, *PUSER;

long  crc32str(char *str);

long cr3tab[] =
{
          /* CRC polynomial 0xEDB88320 */

    0x00000000, 0x77073096, 0xee0e612c, 0x990951ba,
    0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3,
    0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988,
    0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91,
    0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de,
    0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
    0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec,
    0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5,
    0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172,
    0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
    0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940,
    0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
    0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116,
    0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f,
    0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
    0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d,
    0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a,
    0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
    0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818,
    0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
    0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e,
    0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457,
    0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c,
    0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
    0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2,
    0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb,
    0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0,
    0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9,
    0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086,
    0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
    0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4,
    0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad,
    0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a,
    0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683,
    0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8,
    0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
    0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe,
    0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7,
    0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc,
    0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
    0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252,
    0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
    0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60,
    0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79,
    0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
    0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f,
    0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04,
    0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
    0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a,
    0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
    0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38,
    0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21,
    0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e,
    0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
    0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c,
    0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45,
    0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2,
    0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db,
    0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0,
    0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
    0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6,
    0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf,
    0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94,
    0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d
};


main()
{
    int MaxFileHandle = 0;
    int AdeptFileHandle = 0;
    MAXBEGIN StartMax;
    MAXUSER MaxUser;
    USER AdeptUser;
    int MaxUserStructSize;
    struct stat buf;
    int x;
    int NumUsers;
    long maxfileloc;
    long adeptfileloc;

    printf("Really stupid and dumb Max to Adept user converter\r\n");

    MaxFileHandle = open("user.bbs", O_RDONLY | O_BINARY);

    AdeptFileHandle = open("Users", O_WRONLY | O_BINARY | O_CREAT);

    if(MaxFileHandle == -1)
    {
        printf("user.bbs not accessable\r\n");
        return;
    }

    read(MaxFileHandle, &StartMax, sizeof(MAXBEGIN));

    MaxUserStructSize = StartMax.struct_len * 20;

    lseek(MaxFileHandle, 0, SEEK_SET);

    fstat(MaxFileHandle, &buf);

    NumUsers = buf.st_size / MaxUserStructSize;

    printf("Num Users = %d\r\n", NumUsers);

    for(x = 1; x <= NumUsers; x++)
    {
        read(MaxFileHandle, &MaxUser, MaxUserStructSize); //MaxUserStructSize);

        maxfileloc = x * MaxUserStructSize;

        lseek(MaxFileHandle, maxfileloc, SEEK_SET);

        strcpy(AdeptUser.name, MaxUser.name);
        strcpy(AdeptUser.handle, MaxUser.alias);
        strcpy(AdeptUser.city, MaxUser.city);
        strcpy(AdeptUser.home_phone, MaxUser.phone);
        AdeptUser.PasswordCRC = crc32str(MaxUser.pwd);
        strrev(MaxUser.pwd);
        AdeptUser.PasswordCRC2 = (crc32str(MaxUser.pwd) + strlen(MaxUser.pwd));
        AdeptUser.numcalls = MaxUser.times;
        AdeptUser.credit = MaxUser.credit;
        AdeptUser.NetmailDebits = MaxUser.debit;

        AdeptUser.userid = x;

        if(MaxUser.video & GRAPH_TTY)
        {
            AdeptUser.attribs |= U_HIGHASCII;
        }
        else if(MaxUser.video & GRAPH_ANSI)
        {
            AdeptUser.attribs |= U_ANSI;
            AdeptUser.attribs |= U_COLOR;
            AdeptUser.attribs |= U_HIGHASCII;
        }
        else if(MaxUser.video & GRAPH_AVATAR)
        {
            AdeptUser.attribs |= U_AVATAR;
            AdeptUser.attribs |= U_COLOR;
            AdeptUser.attribs |= U_HIGHASCII;
        } else {
            AdeptUser.attribs |= U_HIGHASCII;
        }

        AdeptUser.time_per_day = 45;

        memset(AdeptUser.usermsg, 255, 128);
        memset(AdeptUser.userfile, 255, 128);

        if(MaxUser.priv == TWIT)
        {
            AdeptUser.security1 = 5;
            AdeptUser.time_per_day = 15;
            AdeptUser.time_per_call = 5;
            AdeptUser.dkperday = 1;
            AdeptUser.ukperday = 1;
        }
        else if(MaxUser.priv == DISGRACE)
        {
            AdeptUser.security1 = 10;
            AdeptUser.time_per_day = 30;
            AdeptUser.time_per_call = 30;
            AdeptUser.dkperday = 200;
            AdeptUser.ukperday = 200;
        }
        else if(MaxUser.priv == LIMITED)
        {
            AdeptUser.security1 = 20;
            AdeptUser.time_per_day = 30;
            AdeptUser.time_per_call = 30;
            AdeptUser.dkperday = 400;
            AdeptUser.ukperday = 400;
        }
        else if(MaxUser.priv == NORMAL)
        {
            AdeptUser.security1 = 30;
            AdeptUser.time_per_day = 60;
            AdeptUser.time_per_call = 60;
            AdeptUser.dkperday = 5000;
            AdeptUser.ukperday = 5000;
        }
        else if(MaxUser.priv == WORTHY)
        {
            AdeptUser.security1 = 40;
            AdeptUser.time_per_day = 90;
            AdeptUser.time_per_call = 90;
            AdeptUser.dkperday = 5000;
            AdeptUser.ukperday = 5000;
        }
        else if(MaxUser.priv == PRIVIL)
        {
            AdeptUser.security1 = 50;
            AdeptUser.time_per_day = 90;
            AdeptUser.time_per_call = 90;
            AdeptUser.dkperday = 5000;
            AdeptUser.ukperday = 5000;
        }
        else if(MaxUser.priv == FAVORED)
        {
            AdeptUser.security1 = 60;
            AdeptUser.time_per_day = 1440;
            AdeptUser.time_per_call = 1440;
            AdeptUser.dkperday = 30000;
            AdeptUser.ukperday = 30000;
        }
        else if(MaxUser.priv == EXTRA)
        {
            AdeptUser.security1 = 70;
            AdeptUser.time_per_day = 60;
            AdeptUser.time_per_call = 60;
            AdeptUser.dkperday = 5000;
            AdeptUser.ukperday = 5000;
        }
        else if(MaxUser.priv == CLERK)
        {
            AdeptUser.security1 = 80;
            AdeptUser.time_per_day = 90;
            AdeptUser.time_per_call = 90;
            AdeptUser.dkperday = 5500;
            AdeptUser.ukperday = 5500;
        }
        else if(MaxUser.priv == ASSTSYSOP)
        {
            AdeptUser.security1 = 90;
            AdeptUser.time_per_day = 120;
            AdeptUser.time_per_call = 120;
            AdeptUser.dkperday = 5000;
            AdeptUser.ukperday = 5000;
        }
        else if(MaxUser.priv == SYSOP)
        {
            AdeptUser.security1 = 100;
            AdeptUser.time_per_day = 1440;
            AdeptUser.time_per_call = 1440;
            AdeptUser.dkperday = 30000;
            AdeptUser.ukperday = 30000;
        }
        else {
            AdeptUser.security1 = 10;
            AdeptUser.time_per_day = 30;
            AdeptUser.time_per_call = 30;
            AdeptUser.dkperday = 200;
            AdeptUser.ukperday = 200;
        }

        AdeptUser.Group = AdeptUser.security1;

        AdeptUser.width = 80;
        AdeptUser.length = 24;

        AdeptUser.ulk = MaxUser.up;
        AdeptUser.dlk = MaxUser.down;

        if(!(MaxUser.bits & BITS_HOTKEYS))
        {
            AdeptUser.attribs |= U_COLD;
        }

        if(!(MaxUser.bits & BITS_NOTAVAIL))
        {
            AdeptUser.attribs |= U_AVAILABLE;
        }

        if(MaxUser.bits & BITS_NOULIST)
        {
            AdeptUser.attribs |= U_LISTPROTECTED;
        }

        if(MaxUser.bits2 & BITS2_IBMCHARS)
        {
            AdeptUser.attribs |= U_HIGHASCII;
        }

        if(!(MaxUser.bits2 & BITS2_BORED))
        {
            AdeptUser.attribs2 |= U2_FSE;
        }

        if(!(MaxUser.bits2 & BITS2_MORE))
        {
            AdeptUser.attribs |= U_NOMORE;
        }

        printf("Converting user = %s\r\n", AdeptUser.name);

        write(AdeptFileHandle, &AdeptUser, sizeof(USER));

        memset(&AdeptUser, 0, sizeof(USER));
        memset(&MaxUser, 0, sizeof(MAXUSER));
    }

}

long  crc32str(char *str)
{
    long crc = -1L;

    while (*str)
    {
        crc = cr3tab[((int) crc ^ toupper(*str)) & 0xff] ^ ((crc >> 8) & 0x00FFFFFF);
        str++;
    }
    return crc;
}


