/* $Id: souper.c 1.3 1995/01/08 21:26:16 cthuang Exp $
 *
 * Fetch mail and news using POP3 and NNTP into a SOUP packet.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>
#include "souper.h"

/* global data */
char *progname;

/* program options */
enum Mode { RECEIVE, SEND, CATCHUP } mode = RECEIVE;
char doMail = 1;
char doNews = 1;
char doXref = 1;
char readOnly = 0;
long maxBytes = 2048*1024L;
char *homeDir;
char newsrcFile[FILENAME_MAX];
char killFile[FILENAME_MAX];
int catchupCount;

/* Try to allocate some memory.  Exit if unsuccessful.
 */
void *
xmalloc (size_t sz)
{
    void *p;

    if ((p = malloc(sz)) == NULL) {
	fputs("out of memory\n", stderr);
	exit(1);
    }
    return p;
}

/* Copy string to allocated memory.  Exit if unsuccessful.
 */
char *
xstrdup (const char *s)
{
    return strcpy((char *)xmalloc(strlen(s)+1), s);
}

static void
setDefaults (void)
{
    if ((homeDir = getenv("HOME")) == NULL)
	homeDir = ".";

    sprintf(newsrcFile, "%s/newsrc", homeDir);
    sprintf(killFile, "%s/kill", homeDir);
}

static void
usage (void)
{
    fputs("Souper v1.2 - transfer POP3 mail and NNTP news to SOUP\n", stderr);
    fprintf(stderr, "usage: %s [options] [mailhost userid password]\n", progname);
    fputs("  -c n     Mark every article as read except for the last n in each newsgroup.\n", stderr);
    fputs("  -h dir   Set home directory\n", stderr);
    fputs("  -k n     Set maximum news packet size in Kbytes\n", stderr);
    fputs("  -m       Do not get mail\n", stderr);
    fputs("  -n       Do not get news\n", stderr);
    fputs("  -N file  Set newsrc file\n", stderr);
    fputs("  -K file  Set kill file\n", stderr);
    fputs("  -r       Read only mode.  Do not delete mail or update newsrc\n", stderr);
    fputs("  -s       Send replies\n", stderr);
    fputs("  -x       Do not process news Xref headers\n", stderr);
    exit(1);
}

static void
parseOptions (int argc, char **argv)
{
    int c;

    while ((c = getopt(argc, argv, "c:h:K:k:mN:nrsx")) != EOF) {
	switch (c) {
	case 'c':
	    mode = CATCHUP;
	    catchupCount = atoi(optarg);
	    break;
	case 'h':
	    homeDir = optarg;
	    break;
	case 'K':
	    strcpy(killFile, optarg);
	    break;
	case 'k':
	    maxBytes = atol(optarg) * 1024L;
	    break;
	case 'm':
	    doMail = 0;
	    break;
	case 'N':
	    strcpy(newsrcFile, optarg);
	    break;
	case 'n':
	    doNews = 0;
	    break;
	case 'r':
	    readOnly = 1;
	    break;
	case 's':
	    mode = SEND;
	    break;
	case 'x':
	    doXref = 0;
	    break;
	default:
	    usage();
	}
    }

}

int
main (int argc, char **argv)
{
    progname = strrchr(argv[0], '\\');
    if (progname == NULL)
	progname = argv[0];
    else
	++progname;

    setDefaults();
    parseOptions(argc, argv);

    switch (mode) {
    case RECEIVE:
	if (doMail && argc - optind != 3)
	    usage();

	openAreas();
	signal(SIGINT, closeAreasOnSignal);
	if (doMail) getMail(argv[optind], argv[optind+1], argv[optind+2]);
	if (doNews) getNews();
	closeAreas();
	break;
    case SEND:
	sendReply();
	break;
    case CATCHUP:
	catchupNews(catchupCount);
	break;
    }

    return 0;
}
